/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.webapp;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.extension.WebExtensionProcessor;
import com.ibm.ws.webcontainer.osgi.collaborator.CollaboratorHelperImpl;
import com.ibm.ws.webcontainer.osgi.extension.DefaultExtensionProcessor;
import com.ibm.ws.webcontainer.osgi.extension.InvokerExtensionProcessor;
import com.ibm.ws.webcontainer.osgi.filter.WebAppFilterManagerImpl;
import com.ibm.ws.webcontainer.osgi.managed.WCManagedObjectImpl;
import com.ibm.ws.webcontainer.osgi.metadata.WebComponentMetaDataImpl;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppInjectionClassList;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppSCIHelper;
import com.ibm.ws.webcontainer.servlet.DirectoryBrowsingServlet;
import com.ibm.ws.webcontainer.servlet.H2Handler;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.WsocHandler;
import com.ibm.ws.webcontainer.util.DocumentRootUtils;
import com.ibm.ws.webcontainer.util.EntryResource;
import com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfigurationProvider;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefBindingHelper;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.annotation.AnnotationHelperManager;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Inherited;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebServlet;

public class WebApp
extends com.ibm.ws.webcontainer.webapp.WebApp
implements ComponentNameSpaceConfigurationProvider {
    private static final TraceComponent tc = Tr.register(WebApp.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    protected static final String CLASS_NAME = "com.ibm.ws.webcontainer.osgi.webapp.WebApp";
    private final MetaDataService metaDataService;
    private volatile boolean namespacePopulated;
    private final ReferenceContext referenceContext;
    private J2EENameFactory j2eeNameFactory;
    private ClassLoader moduleLoader;
    private WebAppConfiguration webAppConfig;
    private boolean extensionProcessingDisabled = false;
    private ManagedObjectService managedObjectService;
    protected WebComponentMetaData[] internalServletMetaData = new WebComponentMetaData[this.internalServletList.length];

    public WebApp(WebAppConfiguration webAppConfig, ClassLoader moduleLoader, ReferenceContext referenceContext, MetaDataService metaDataService, J2EENameFactory j2eeNameFactory, ManagedObjectService managedObjectService) {
        super(webAppConfig, null);
        this.webAppConfig = webAppConfig;
        this.moduleLoader = moduleLoader;
        this.referenceContext = referenceContext;
        this.metaDataService = metaDataService;
        this.j2eeNameFactory = j2eeNameFactory;
        this.managedObjectService = managedObjectService;
    }

    public String toString() {
        WebModuleMetaData mmd = this.config == null ? null : this.config.getMetaData();
        return mmd == null ? super.toString() : super.toString() + '[' + mmd.getJ2EEName() + ']';
    }

    @Override
    public com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext createDispatchContext() {
        return new WebAppDispatcherContext(this);
    }

    protected ExtensionProcessor getInvokerExtensionProcessor() {
        return new InvokerExtensionProcessor(this, this.config.getInvokerAttributes());
    }

    @Override
    public ExtensionProcessor getLoginProcessor() {
        IWebAppSecurityCollaborator secCollab = this.collabHelper.getSecurityCollaborator();
        this.loginProcessor = secCollab.getFormLoginExtensionProcessor(this);
        return this.loginProcessor;
    }

    @Override
    public ExtensionProcessor getLogoutProcessor() {
        IWebAppSecurityCollaborator secCollab = this.collabHelper.getSecurityCollaborator();
        this.logoutProcessor = secCollab.getFormLogoutExtensionProcessor(this);
        return this.logoutProcessor;
    }

    @Override
    public String getNodeName() {
        return "default_node";
    }

    @Override
    public String getServerInfo() {
        return "SMF WebContainer";
    }

    @Override
    public String getServerName() {
        return "SMF WebContainer";
    }

    @Override
    public WebExtensionProcessor getWebExtensionProcessor() {
        return new com.ibm.ws.webcontainer.osgi.extension.WebExtensionProcessor(this);
    }

    @Override
    protected void commonInitializationStart(com.ibm.ws.webcontainer.webapp.WebAppConfiguration config, DeployedModule moduleConfig) throws Throwable {
        this.referenceContext.process();
        super.commonInitializationStart(config, moduleConfig);
        Dictionary<String, String> headers = this.webAppConfig.getBundleHeaders();
        if (headers != null) {
            String implicitMappingDisabledHeader = headers.get("IBM-Web-Extension-Processing-Disabled");
            this.extensionProcessingDisabled = Boolean.valueOf(implicitMappingDisabledHeader);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "commonInitializationStart", "ExtensionProcessingDisabled-->" + this.extensionProcessingDisabled + ", header value = " + implicitMappingDisabledHeader);
            }
        }
    }

    @Override
    protected void processDynamicInjectionMetaData(Class<?> klass) throws InjectionException {
        List<Class<?>> injectionClasses;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "processDynamicInjectionMetaData", "MetadataComplete  = " + this.config.isMetadataComplete() + ", Class-->" + klass.getName());
        }
        if (!this.config.isMetadataComplete() && this.referenceContext.isProcessDynamicNeeded(injectionClasses = Collections.singletonList(klass))) {
            ComponentNameSpaceConfiguration compNSConfig = this.createComponentNameSpaceConfiguration(Collections.singletonList(klass), false);
            this.referenceContext.processDynamic(compNSConfig);
        }
    }

    public ComponentNameSpaceConfiguration getComponentNameSpaceConfiguration() {
        return this.createComponentNameSpaceConfiguration(this.getInjectionClasses(), true);
    }

    private ComponentNameSpaceConfiguration createComponentNameSpaceConfiguration(List<Class<?>> injectionClasses, boolean xml) {
        J2EEName j2eeName = this.getModuleMetaData().getJ2EEName();
        ComponentNameSpaceConfiguration compNSConfig = new ComponentNameSpaceConfiguration(this.config.getDisplayName(), j2eeName);
        compNSConfig.setClassLoader(this.moduleLoader);
        compNSConfig.setModuleMetaData((ModuleMetaData)this.getModuleMetaData());
        compNSConfig.setMetaDataComplete(this.config.isMetadataComplete());
        compNSConfig.setInjectionClasses(injectionClasses);
        if (xml) {
            JNDIEnvironmentRefType.setAllRefs((ComponentNameSpaceConfiguration)compNSConfig, this.config.getAllRefs());
        }
        JNDIEnvironmentRefBindingHelper.setAllBndAndExt((ComponentNameSpaceConfiguration)compNSConfig, this.config.getAllRefBindings(), this.config.getEnvEntryValues(), (ResourceRefConfigList)this.config.getResourceRefConfigList(null));
        return compNSConfig;
    }

    private List<Class<?>> getInjectionClasses() {
        TreeSet<String> classNames;
        block8: {
            block7: {
                if (this.config.isMetadataComplete()) {
                    return Collections.emptyList();
                }
                classNames = new TreeSet<String>();
                try {
                    WebAppInjectionClassList injectionClassList = (WebAppInjectionClassList)this.container.adapt(WebAppInjectionClassList.class);
                    classNames.addAll(injectionClassList.getClassNames());
                }
                catch (UnableToAdaptException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"getInjectionClasses: failed to adapt to WebAppInjectionClassList ", (Object[])new Object[]{e});
                }
            }
            Iterator<Object> it = this.config.getServletInfos();
            while (it.hasNext()) {
                IServletConfig servletInfo = it.next();
                this.addInjectionClassName(classNames, servletInfo.getClassName());
            }
            it = this.config.getFilterInfos();
            while (it.hasNext()) {
                IFilterConfig filterInfo = (IFilterConfig)it.next();
                this.addInjectionClassName(classNames, filterInfo.getClassName());
            }
            classNames.addAll(this.config.getListeners());
            try {
                WebAnnotations webAnnotations = this.getWebAnnotations();
                AnnotationTargets_Targets webModuleTargets = webAnnotations.getAnnotationTargets();
                classNames.addAll(webModuleTargets.getAnnotatedClasses(WebServlet.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
                classNames.addAll(webModuleTargets.getAnnotatedClasses(WebFilter.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"getInjectionClasses: got exception looking for annotations of servlets and filters", (Object[])new Object[]{e});
            }
        }
        return this.getInjectionClasses(classNames);
    }

    private void addInjectionClassName(Set<String> classNames, String className) {
        if (className != null) {
            classNames.add(className);
        }
    }

    @FFDCIgnore(value={Throwable.class})
    private List<Class<?>> getInjectionClasses(Set<String> classNames) {
        ArrayList classes = new ArrayList();
        for (String className : classNames) {
            try {
                classes.add(this.moduleLoader.loadClass(className));
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("getInjectionClasses: failed to load " + className), (Object[])new Object[]{t});
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public URL getResource(String p) throws MalformedURLException {
        String uri;
        String rPath = null;
        if (p.charAt(0) != '/' && p.charAt(0) != '\\') {
            if (!prependSlashToResource) throw new MalformedURLException(nls.getString("resource.path.has.to.start.with.slash"));
            logger.logp(Level.WARNING, CLASS_NAME, "getResource", "resource.path.has.to.start.with.slash");
            rPath = "/" + p;
        } else {
            rPath = p;
        }
        if (this.container != null) {
            if (p.equals("/")) {
                Collection urls = this.container.getURLs();
                Iterator it = urls.iterator();
                if (it.hasNext()) {
                    File file;
                    URL url = (URL)it.next();
                    if (!url.getProtocol().equals("file") || !(file = new File(url.getFile())).exists() || file.isDirectory()) return url;
                    return new URL("jar", "", -1, url + "!/");
                }
            } else {
                Entry entry = this.container.getEntry(rPath);
                if (entry == null) return this.getDocumentRootUtils(rPath).getURL(rPath, this.metaInfCache);
                return entry.getResource();
            }
        }
        if ((uri = this.getRealPath(rPath)) == null) {
            return null;
        }
        File checkFile = new File(uri);
        if (checkFile.exists()) return checkFile.toURL();
        if (!WCCustomProperties.SKIP_META_INF_RESOURCES_PROCESSING) {
            if (useMetaInfCache) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getResource", "trying META-INF/resources cache");
                }
                Map url = this.metaInfCache;
                synchronized (url) {
                    if (this.metaInfCache.containsKey(rPath)) {
                        URL cachedURL = (URL)this.metaInfCache.get(rPath);
                        if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) return cachedURL;
                        logger.logp(Level.FINE, CLASS_NAME, "getResource", "got cached META-INF name->[{0}], URL->[{1}]", new Object[]{rPath, cachedURL});
                        return cachedURL;
                    }
                }
            }
            MetaInfResourcesFileUtils metaInfFileUtil = new MetaInfResourcesFileUtils(this);
            metaInfFileUtil.findInMetaInfResource(rPath);
            URL metaInfURL = metaInfFileUtil.getURL();
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getResource", "file did not exist, trying META-INF/resources");
                logger.logp(Level.FINE, CLASS_NAME, "getResource", "metaInfPath->/META-INF/resources" + rPath);
            }
            if (!useMetaInfCache) return metaInfURL;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getResource", "adding to META-INF cache name->[{0}], URL->[{1}]", new Object[]{rPath, metaInfURL});
            }
            Map map = this.metaInfCache;
            synchronized (map) {
                this.metaInfCache.put(rPath, metaInfURL);
                return metaInfURL;
            }
        }
        if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) return null;
        logger.logp(Level.FINE, CLASS_NAME, "getResource", "skipping META-INF/resources processing");
        return null;
    }

    @Override
    @FFDCIgnore(value={IOException.class})
    public InputStream getResourceAsStream(String path) {
        try {
            if (this.container != null) {
                Entry entry = this.container.getEntry(path);
                if (entry != null) {
                    return (InputStream)entry.adapt(InputStream.class);
                }
                DocumentRootUtils dru = this.getDocumentRootUtils(path);
                dru.handleDocumentRoots(path, null);
                return dru.getInputStream();
            }
            URL url = this.getResource(path);
            if (url == null) {
                return null;
            }
            URLConnection conn = url.openConnection();
            return conn.getInputStream();
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (UnableToAdaptException e) {
            return null;
        }
    }

    @Override
    public String getRealPath(String path) {
        return this.getRealPath(path, true);
    }

    public String getRealPath(String path, boolean checkDocRoot) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getRealPath", new Object[]{path, checkDocRoot});
        }
        String basePath = null;
        if (path == null || path.equals("")) {
            path = "/";
        }
        if (this.container != null) {
            boolean pathIsBackslash = false;
            if (path.contains("\\")) {
                if (path.equals("\\")) {
                    pathIsBackslash = true;
                }
                path = path.replace("\\", "/");
            }
            if (path.equals("/")) {
                String physicalPath = this.container.getPhysicalPath();
                if (physicalPath == null) {
                    return null;
                }
                File file = new File(physicalPath);
                if (!file.exists() || !file.isDirectory()) {
                    return null;
                }
                if (pathIsBackslash) {
                    physicalPath = physicalPath + "\\";
                    return physicalPath;
                }
                return file.getAbsolutePath();
            }
            try {
                Entry entry = this.container.getEntry(path);
                if (entry != null) {
                    String s = entry.getPhysicalPath();
                    if (s != null && path.length() > 1 && path.endsWith("/") && s.charAt(s.length() - 1) != File.separatorChar) {
                        s = s + File.separator;
                    }
                    return s;
                }
                if (!checkDocRoot) {
                    return null;
                }
                DocumentRootUtils dru = this.getDocumentRootUtils(path);
                if (dru != null) {
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "obtained dru");
                    }
                    dru.handleDocumentRoots(path, WCCustomProperties.CHECK_EDR_IN_GET_REAL_PATH);
                    EntryResource er = dru.getMatchedEntryResource();
                    if (er != null) {
                        Entry ety;
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "obtained er: " + er);
                        }
                        if ((ety = er.getEntry()) != null) {
                            String s;
                            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "obtained entry: " + ety);
                            }
                            if ((s = ety.getPhysicalPath()) != null && s.length() > 0) {
                                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "getPhysicalPath() is: " + s);
                                }
                                if (path.endsWith("/") && s.charAt(s.length() - 1) != File.separatorChar) {
                                    s = s + File.separator;
                                }
                                return s;
                            }
                            if (!WCCustomProperties.CHECK_EDR_IN_GET_REAL_PATH || WCCustomProperties.GET_REAL_PATH_RETURNS_QUALIFIED_PATH) {
                                basePath = this.container.getPhysicalPath();
                            }
                        }
                    } else {
                        File matchedFile = dru.getMatchedFile();
                        if (matchedFile != null) {
                            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "obtained file [" + matchedFile.getAbsolutePath() + "]");
                            }
                            return matchedFile.getAbsolutePath();
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "caught IllegalArgument Exception. path: " + path + "  Exception: " + e);
                return null;
            }
            catch (IOException e) {
                logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "caught IOException processing document root getReadPath: " + path + "  Exception: " + e);
                if (!WCCustomProperties.GET_REAL_PATH_RETURNS_QUALIFIED_PATH) {
                    return null;
                }
                basePath = this.container.getPhysicalPath();
            }
        }
        if (basePath == null) {
            return null;
        }
        basePath = basePath.replace('\\', '/');
        if (File.separatorChar != '/') {
            basePath = basePath.replace('/', File.separatorChar);
            path = path.replace('/', File.separatorChar);
        }
        String realPath = "";
        realPath = path.charAt(0) == File.separatorChar ? basePath + path : basePath + File.separatorChar + path;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.INFO, CLASS_NAME, "getRealPath", "returning path: " + realPath);
        }
        return realPath;
    }

    @Override
    public Set getResourcePaths(String path, boolean searchMetaInf) {
        File[] fileList;
        HashSet<String> set = new HashSet<String>();
        if (WCCustomProperties.SKIP_META_INF_RESOURCES_PROCESSING && searchMetaInf) {
            searchMetaInf = false;
            logger.logp(Level.FINE, CLASS_NAME, "getResourcePaths", "override searchMetaInf to false becuase of custom property");
        }
        if (this.container != null) {
            try {
                this.addResourcePaths(set, this.container, path, searchMetaInf);
            }
            catch (UnableToAdaptException e) {
                throw new IllegalStateException(e);
            }
            set.addAll(this.getStaticDocumentRootUtils().getResourcePaths(path, false));
            set.addAll(this.getJSPDocumentRootUtils().getResourcePaths(path, false));
            return set;
        }
        File root = new File(this.documentRoot + path);
        if (root.exists() && (fileList = root.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                String resourcePath = fileList[i].getPath();
                resourcePath = resourcePath.substring(this.documentRoot.length());
                resourcePath = resourcePath.replace('\\', '/');
                if (fileList[i].isDirectory() && !resourcePath.endsWith("/")) {
                    resourcePath = resourcePath + "/";
                }
                set.add(resourcePath);
            }
        }
        return set;
    }

    @Override
    protected ExtensionProcessor getDefaultExtensionProcessor(com.ibm.ws.webcontainer.webapp.WebApp app, HashMap map) {
        return new DefaultExtensionProcessor(this, map);
    }

    @Override
    protected InvokerExtensionProcessor getInvokerExtensionProcessor(com.ibm.ws.webcontainer.webapp.WebApp app) {
        return new InvokerExtensionProcessor(app, this.config.getInvokerAttributes());
    }

    @Override
    protected Object loadListener(String className) throws InjectionException, Throwable {
        Object listener;
        block4: {
            listener = null;
            try {
                final String serializedName = className.replace('.', '/').concat(".ser");
                final ClassLoader loader = this.getClassLoader();
                ManagedObject mo = null;
                InputStream is = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return loader.getResourceAsStream(serializedName);
                    }
                });
                if (is != null) {
                    listener = super.loadListener(className);
                    mo = this.injectAndPostConstruct(listener);
                } else {
                    Class<?> listenerClass = this.getClassLoader().loadClass(className);
                    mo = this.injectAndPostConstruct(listenerClass);
                    listener = mo.getObject();
                }
                this.cdiContexts.put(listener, mo);
            }
            catch (ClassNotFoundException exc) {
                this.logError("Failed to load listener: " + className, exc);
                if (!WCCustomProperties.STOP_APP_STARTUP_ON_LISTENER_EXCEPTION) break block4;
                throw exc;
            }
        }
        return listener;
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> classToCreate) throws ServletException {
        logger.logp(Level.FINE, CLASS_NAME, "createListener", "called for class: " + classToCreate);
        return super.createListener(classToCreate);
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> classToCreate) throws ServletException {
        logger.logp(Level.FINE, CLASS_NAME, "createFilter", "called for class: " + classToCreate);
        return super.createFilter(classToCreate);
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> classToCreate) throws ServletException {
        logger.logp(Level.FINE, CLASS_NAME, "createServlet", "called for class: " + classToCreate);
        return super.createServlet(classToCreate);
    }

    @Override
    protected void initializeFilterManager() {
        if (this.filterManager == null) {
            this.filterManager = new WebAppFilterManagerImpl(this.config, this);
            this.filterManager.init();
        }
    }

    @Override
    protected void initializeServletContextFacades() {
    }

    @Override
    protected void determineWhetherToAddScis(ServletContainerInitializer sci, List<ServletContainerInitializer> scis) {
        if (this.acceptAnnotationsFrom(sci.getClass().getName(), true, false)) {
            scis.add(sci);
        }
    }

    private WebAnnotations getWebAnnotations() throws UnableToAdaptException {
        return AnnotationsBetaHelper.getWebAnnotations((Container)this.getModuleContainer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scanForHandlesTypesClasses(DeployedModule deployedModule, HashMap<ServletContainerInitializer, Class[]> handleTypesMap, HashMap<ServletContainerInitializer, HashSet<Class<?>>> onStartupMap) {
        InfoStore infoStore;
        AnnotationTargets_Targets annoTargets;
        WebAnnotations webAppAnnos;
        String methodName = "scanForHandlesTypesClasses";
        boolean enableTrace = com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE);
        try {
            webAppAnnos = this.getWebAnnotations();
            annoTargets = webAppAnnos.getAnnotationTargets();
            infoStore = webAppAnnos.getInfoStore();
        }
        catch (UnableToAdaptException e) {
            return;
        }
        boolean didOpen = false;
        try {
            for (Map.Entry<ServletContainerInitializer, Class[]> sciEntry : handleTypesMap.entrySet()) {
                ServletContainerInitializer sci = sciEntry.getKey();
                Class[] handledTypes = sciEntry.getValue();
                Set startupTypes = onStartupMap.get(sci);
                for (Class handledType : handledTypes) {
                    String handledTypeName = handledType.getName();
                    boolean isAnnotation = handledType.isAnnotation();
                    if (enableTrace) {
                        logger.logp(Level.FINE, CLASS_NAME, methodName, "Handled Type      [ {0} ]", handledTypeName);
                        logger.logp(Level.FINE, CLASS_NAME, methodName, "  isAnnotation     [ {0} ]", isAnnotation);
                    }
                    if (isAnnotation) {
                        Object targetClassName2;
                        boolean isClassAnnotation = WebAppSCIHelper.isClassTarget(handledType);
                        boolean isInheritedAnnotation = isClassAnnotation && handledType.isAnnotationPresent(Inherited.class);
                        boolean isMethodAnnotation = WebAppSCIHelper.isMethodTarget(handledType);
                        if (enableTrace) {
                            logger.logp(Level.FINE, CLASS_NAME, methodName, "  isClassAnno      [ {0} ]", isClassAnnotation);
                            logger.logp(Level.FINE, CLASS_NAME, methodName, "  isInherited      [ {0} ]", isInheritedAnnotation);
                            logger.logp(Level.FINE, CLASS_NAME, methodName, "  isMethodAnno     [ {0} ]", isMethodAnnotation);
                        }
                        if (isClassAnnotation) {
                            Set targetClassNames = isInheritedAnnotation ? annoTargets.getAllInheritedAnnotatedClasses(handledTypeName, AnnotationTargets_Targets.POLICY_SEED_AND_PARTIAL) : annoTargets.getAnnotatedClasses(handledTypeName, AnnotationTargets_Targets.POLICY_SEED_AND_PARTIAL);
                            String classReason = "Selection on class annotation [ " + handledTypeName + " ]";
                            for (Object targetClassName2 : targetClassNames) {
                                this.addClassToHandlesTypesStartupSet((String)targetClassName2, startupTypes, classReason);
                            }
                        }
                        if (!isMethodAnnotation) continue;
                        HashSet<String> testedClassNames = new HashSet<String>();
                        HashSet<String> foundClassNames = new HashSet<String>();
                        Set targetClassNames = annoTargets.getClassesWithMethodAnnotation(handledTypeName, AnnotationTargets_Targets.POLICY_SEED_AND_PARTIAL);
                        targetClassName2 = targetClassNames.iterator();
                        while (targetClassName2.hasNext()) {
                            String targetClassName3 = (String)targetClassName2.next();
                            if (testedClassNames.contains(targetClassName3)) continue;
                            testedClassNames.add(targetClassName3);
                            foundClassNames.add(targetClassName3);
                            Set targetSubclassNames = annoTargets.getSubclassNames(targetClassName3);
                            for (String targetSubclassName : targetSubclassNames) {
                                ClassInfo subclassInfo;
                                if (testedClassNames.contains(targetSubclassName)) continue;
                                testedClassNames.add(targetSubclassName);
                                if (!didOpen) {
                                    try {
                                        webAppAnnos.openInfoStore();
                                    }
                                    catch (UnableToAdaptException e) {
                                        if (didOpen) {
                                            try {
                                                webAppAnnos.closeInfoStore();
                                            }
                                            catch (UnableToAdaptException unableToAdaptException) {
                                                // empty catch block
                                            }
                                        }
                                        return;
                                    }
                                    didOpen = true;
                                }
                                if (!WebAppSCIHelper.anyMethodHasAnnotation(subclassInfo = infoStore.getDelayableClassInfo(targetSubclassName), handledTypeName)) continue;
                                foundClassNames.add(targetSubclassName);
                            }
                        }
                        String methodReason = "Selection on method annotation [ " + handledTypeName + " ]";
                        for (String foundClassName : foundClassNames) {
                            this.addClassToHandlesTypesStartupSet(foundClassName, startupTypes, methodReason);
                        }
                        continue;
                    }
                    if (enableTrace) {
                        logger.logp(Level.FINE, CLASS_NAME, methodName, "Selection Type: [ {0} ]", handledType.getName());
                    }
                    if (!WCCustomProperties.EXCLUDE_ALL_HANDLED_TYPES_CLASSES) {
                        String actualClassReason = "Selection of handlesType class [ " + handledTypeName + " ]";
                        this.addClassToHandlesTypesStartupSet(handledTypeName, startupTypes, actualClassReason);
                    } else if (enableTrace) {
                        logger.logp(Level.FINE, CLASS_NAME, methodName, "Skipping type, {0}, is not added to the ServletContainerInitializers in the application: {1}.", new Object[]{handledTypeName, this.config.getDisplayName()});
                    }
                    if (((com.ibm.wsspi.annocache.targets.AnnotationTargets_Targets)annoTargets).isInterface(handledTypeName)) {
                        String interfaceReason = "Selection on interface [ " + handledTypeName + " ]";
                        Set implementerClassNames = annoTargets.getAllImplementorsOf(handledTypeName);
                        for (String implementerClassName : implementerClassNames) {
                            this.addClassToHandlesTypesStartupSet(implementerClassName, startupTypes, interfaceReason);
                        }
                        continue;
                    }
                    String classesReason = "Selection on sub-classes of [ " + handledTypeName + " ]";
                    for (String targetClassName : annoTargets.getSubclassNames(handledTypeName)) {
                        this.addClassToHandlesTypesStartupSet(targetClassName, startupTypes, classesReason);
                    }
                }
            }
        }
        finally {
            if (didOpen) {
                try {
                    webAppAnnos.closeInfoStore();
                }
                catch (UnableToAdaptException unableToAdaptException) {}
            }
        }
    }

    protected void addClassToHandlesTypesStartupSet(String targetClassName, Set<Class<?>> handlesTypesOnStartupSet, String reasonText) {
        Class<?> targetInitializerClass;
        boolean enableTrace;
        String methodName;
        block20: {
            methodName = "addClassToHandlesTypesStartupSet";
            boolean bl = enableTrace = com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE);
            if (targetClassName.startsWith("java.") || targetClassName.startsWith("javax.")) {
                if (enableTrace) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "Internal class, {0}, is not added to the ServletContainerInitializers in the application: {1}", new Object[]{targetClassName, this.config.getDisplayName()});
                }
                return;
            }
            try {
                WebAnnotations webAppAnnotations = this.getWebAnnotations();
                AnnotationTargets_Targets table = webAppAnnotations.getAnnotationTargets();
                if (table.isExcludedClassName(targetClassName)) {
                    if (enableTrace) {
                        logger.logp(Level.FINE, CLASS_NAME, methodName, "Class, {0}, exists in a fragment that has been excluded in the application: {1}", new Object[]{targetClassName, this.config.getDisplayName()});
                    }
                    return;
                }
            }
            catch (UnableToAdaptException e) {
                if (enableTrace) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "caught UnableToAdaptException: " + (Object)((Object)e));
                }
                return;
            }
            try {
                if (enableTrace) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "InitializeClassInHandlesTypesStartup: {0} ", WCCustomProperties.INITIALIZE_CLASS_IN_HANDLES_TYPES_STARTUP);
                }
                targetInitializerClass = Class.forName(targetClassName, WCCustomProperties.INITIALIZE_CLASS_IN_HANDLES_TYPES_STARTUP, ThreadContextHelper.getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                targetInitializerClass = null;
                if (WCCustomProperties.LOG_SERVLET_CONTAINER_INITIALIZER_CLASSLOADER_ERRORS) {
                    logger.logp(Level.WARNING, CLASS_NAME, methodName, "exception.occurred.while.initializing.ServletContainerInitializers.class.lookup", new Object[]{targetClassName, this.config.getDisplayName()});
                } else if (enableTrace) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "exception.occurred.while.initializing.ServletContainerInitializers.class.lookup", new Object[]{targetClassName, this.config.getDisplayName()});
                }
            }
            catch (NoClassDefFoundError e) {
                targetInitializerClass = null;
                if (WCCustomProperties.LOG_SERVLET_CONTAINER_INITIALIZER_CLASSLOADER_ERRORS) {
                    logger.logp(Level.WARNING, CLASS_NAME, methodName, "exception.occurred.while.initializing.ServletContainerInitializers.class.lookup", new Object[]{targetClassName, this.config.getDisplayName()});
                }
                if (!enableTrace) break block20;
                logger.logp(Level.FINE, CLASS_NAME, methodName, "exception.occurred.while.initializing.ServletContainerInitializers.class.lookup", new Object[]{targetClassName, this.config.getDisplayName()});
            }
        }
        if (targetInitializerClass != null) {
            if (handlesTypesOnStartupSet.contains(targetInitializerClass)) {
                if (enableTrace) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "{0} already in onStartup set for {1} : {2}", new Object[]{targetClassName, this.config.getDisplayName(), reasonText});
                }
            } else {
                handlesTypesOnStartupSet.add(targetInitializerClass);
                if (enableTrace) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "Adding initializer [ {0} ] to [ {1} ] [ {2} ]", new Object[]{targetClassName, this.config.getDisplayName(), reasonText});
                }
            }
        }
    }

    @Override
    public WebComponentMetaData getWebAppCmd() {
        return ((WebAppConfiguration)this.config).getDefaultComponentMetaData();
    }

    public WebComponentMetaData createComponentMetaData(String servletName) throws MetaDataException {
        WebComponentMetaDataImpl wccmd = new WebComponentMetaDataImpl(this.config.getMetaData());
        J2EEName moduleJ2EEName = this.getModuleMetaData().getJ2EEName();
        wccmd.setJ2EEName(this.j2eeNameFactory.create(moduleJ2EEName.getApplication(), moduleJ2EEName.getModule(), servletName));
        this.metaDataService.fireComponentMetaDataCreated((ComponentMetaData)wccmd);
        return wccmd;
    }

    @Override
    protected ServletConfig createConfig(String servletName, int internalIndex) throws ServletException {
        ServletConfig sconfig = new ServletConfig(servletName, this.getWebAppConfig());
        WebComponentMetaData wccmd = this.internalServletMetaData[internalIndex];
        if (wccmd == null) {
            WebComponentMetaDataImpl wccmdImpl = new WebComponentMetaDataImpl(this.config.getMetaData());
            J2EEName moduleJ2EEName = this.getModuleMetaData().getJ2EEName();
            wccmdImpl.setJ2EEName(this.j2eeNameFactory.create(moduleJ2EEName.getApplication(), moduleJ2EEName.getModule(), servletName));
            wccmd = this.internalServletMetaData[internalIndex] = wccmdImpl;
        }
        sconfig.setMetaData(wccmd);
        return sconfig;
    }

    @Override
    public Servlet getSimpleFileServlet() {
        if (this.defaultExtProc == null) {
            this.defaultExtProc = new DefaultExtensionProcessor(this, this.getConfiguration().getFileServingAttributes());
        }
        return this.defaultExtProc;
    }

    @Override
    public Servlet getDirectoryBrowsingServlet() {
        if (this.directoryBrowsingServlet == null) {
            this.directoryBrowsingServlet = new DirectoryBrowsingServlet();
        }
        return this.directoryBrowsingServlet;
    }

    @Override
    public boolean getExtensionProcessingDisabled() {
        return this.extensionProcessingDisabled;
    }

    @Override
    protected ICollaboratorHelper createCollaboratorHelper(DeployedModule moduleConfig) {
        return new CollaboratorHelperImpl(this, moduleConfig);
    }

    public boolean isNamespacePopulated() {
        return this.namespacePopulated;
    }

    public void setNamespacePopulated(boolean namespacePopulated) {
        this.namespacePopulated = namespacePopulated;
    }

    public ManagedObject inject(Class<?> Klass) throws InjectionException {
        return this.inject(Klass, null);
    }

    public ManagedObject inject(Class<?> Klass, ClassLoader cl) throws InjectionException {
        WCManagedObjectImpl<Object> r;
        block9: {
            r = null;
            String METHOD_NAME = "inject(class)";
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.entering(CLASS_NAME, "inject(class)", Klass);
            }
            try {
                WCManagedObjectImpl<Object> mo;
                if (null == this.managedObjectService) break block9;
                this.processDynamicInjectionMetaData(Klass);
                try {
                    WebModuleMetaData moduleMetaData = this.getModuleMetaData();
                    ManagedObjectFactory mof = this.managedObjectService.createManagedObjectFactory((ModuleMetaData)moduleMetaData, Klass, false);
                    mo = mof.createManagedObject();
                }
                catch (IllegalStateException ise) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "inject(class)", "IllegalStateException from managed object service:" + ise);
                    }
                    if (cl == null) {
                        cl = this.getClassLoader();
                    }
                    mo = new WCManagedObjectImpl<Object>(Beans.instantiate(cl, Klass.getName()));
                }
                r = mo;
                mo.inject(this.referenceContext);
            }
            catch (InjectionException iex) {
                throw iex;
            }
            catch (Exception ex) {
                throw new InjectionException(ex.getCause() != null ? ex.getCause() : ex);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "inject(class)", r);
        }
        return r;
    }

    public ManagedObject inject(Object target) throws InjectionException {
        ManagedObject r;
        block7: {
            String METHOD_NAME = "inject";
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.entering(CLASS_NAME, "inject", target);
            }
            r = null;
            try {
                ManagedObject mo;
                if (null == this.managedObjectService) break block7;
                this.processDynamicInjectionMetaData(target.getClass());
                try {
                    WebModuleMetaData moduleMetaData = this.getModuleMetaData();
                    ManagedObjectFactory mof = this.managedObjectService.createManagedObjectFactory((ModuleMetaData)moduleMetaData, target.getClass(), false);
                    mo = mof.createManagedObject(target, null);
                }
                catch (ManagedObjectException moe) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "inject", "IllegalStateException from managed object service:" + (Object)((Object)moe));
                    }
                    mo = new WCManagedObjectImpl(target);
                }
                r = mo;
                mo.inject(this.referenceContext);
            }
            catch (ManagedObjectException e) {
                throw new InjectionException(e.getCause());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "inject", r);
        }
        return r;
    }

    public ManagedObject injectAndPostConstruct(Object target) throws InjectionException {
        String METHOD_NAME = "injectAndPostConstruct";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "injectAndPostConstruct", target);
        }
        ManagedObject r = this.inject(target);
        Throwable t = this.invokeAnnotTypeOnObjectAndHierarchy(target, WebApp.ANNOT_TYPE.POST_CONSTRUCT);
        if (null != t) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "injectAndPostConstruct", "Exception caught during post construct processing: " + t);
            }
            if (t instanceof InjectionException) {
                InjectionException ie = (InjectionException)t;
                throw ie;
            }
            RuntimeException re = new RuntimeException(t);
            throw re;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "injectAndPostConstruct", r);
        }
        return r;
    }

    @Override
    protected <T> T createAsManageObject(final Class<?> Klass) throws ServletException {
        ManagedObject mo = null;
        try {
            mo = System.getSecurityManager() != null ? (ManagedObject)AccessController.doPrivileged(new PrivilegedExceptionAction<ManagedObject<?>>(){

                @Override
                public ManagedObject<?> run() throws Exception {
                    return WebApp.this.injectAndPostConstruct(Klass);
                }
            }) : this.injectAndPostConstruct(Klass);
            this.cdiContexts.put(mo.getObject(), mo);
            return (T)mo.getObject();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ManagedObject injectAndPostConstruct(Class<?> Klass) throws InjectionException {
        return this.injectAndPostConstruct(Klass, null);
    }

    public ManagedObject injectAndPostConstruct(Class<?> Klass, ClassLoader cl) throws InjectionException {
        ManagedObject r;
        Throwable t;
        String METHOD_NAME = "injectAndPostConstruct(class)";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "injectAndPostConstruct(class)", Klass);
        }
        if (null != (t = this.invokeAnnotTypeOnObjectAndHierarchy((r = this.inject(Klass, cl)).getObject(), WebApp.ANNOT_TYPE.POST_CONSTRUCT))) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "injectAndPostConstruct(class)", "Exception caught during post construct processing: " + t);
            }
            if (t instanceof InjectionException) {
                InjectionException ie = (InjectionException)t;
                throw ie;
            }
            RuntimeException re = new RuntimeException(t);
            throw re;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "injectAndPostConstruct(class)", r);
        }
        return r;
    }

    @Override
    public void performPreDestroy(Object target) throws InjectionException {
        Throwable t = this.invokeAnnotTypeOnObjectAndHierarchy(target, WebApp.ANNOT_TYPE.PRE_DESTROY);
        if (t != null && com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "inject", "Exception caught during pre destroy processing: " + t);
        }
    }

    @Override
    public void destroy() {
        if (super.getDestroyed()) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "destroy", "WebApp is already destroyed. RETURN. this ->" + this);
            }
            return;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", "osgi.WebApp.destroy entered. this -> " + this);
        }
        super.destroy();
        AnnotationHelperManager.removeInstance(this);
    }

    public void setOrderedLibPaths(List<String> orderedLibPaths) {
        this.orderedLibPaths = orderedLibPaths;
    }

    private DocumentRootUtils getDocumentRootUtils(String uri) {
        DocumentRootUtils docRoot;
        boolean useJSPRoot;
        block4: {
            RequestProcessor requestProcessor;
            useJSPRoot = false;
            docRoot = null;
            if ((this.staticDocRoot.hasDocRoot() || this.jspDocRoot.hasDocRoot()) && (requestProcessor = this.requestMapper.map(uri)) != null) {
                try {
                    Class<?> jspProcessorClass = Class.forName("com.ibm.ws.jsp.webcontainerext.AbstractJSPExtensionProcessor");
                    useJSPRoot = jspProcessorClass.isInstance(requestProcessor);
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "useJSPDocRoot", "useJSPRoot = " + useJSPRoot + ", request Processor is " + requestProcessor.getClass().getName());
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    useJSPRoot = false;
                    if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block4;
                    logger.logp(Level.FINE, CLASS_NAME, "useJSPDocRoot", "useJSPRoot = " + useJSPRoot + ", ClassNotFoundException.", cnfe);
                }
            }
        }
        docRoot = useJSPRoot ? this.getJSPDocumentRootUtils() : this.getStaticDocumentRootUtils();
        return docRoot;
    }

    public DocumentRootUtils getJSPDocumentRootUtils() {
        return new DocumentRootUtils((ServletContext)this, this.jspDocRoot.getedrSearchPath(), this.jspDocRoot.getpfedrSearchPath());
    }

    public DocumentRootUtils getStaticDocumentRootUtils() {
        return new DocumentRootUtils((ServletContext)this, this.staticDocRoot.getedrSearchPath(), this.staticDocRoot.getpfedrSearchPath());
    }

    @Override
    protected boolean isHttpSessionIdListener(Object listener) {
        return false;
    }

    @Override
    protected void checkForSessionIdListenerAndAdd(Object listener) {
    }

    public void registerWebSocketHandler(WsocHandler wsocServHandler) {
    }

    public WsocHandler getWebSocketHandler() {
        return null;
    }

    public H2Handler getH2Handler() {
        return null;
    }
}

