/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PropertiesEntityResolver
implements EntityResolver {
    private static TraceComponent tc = Tr.register(PropertiesEntityResolver.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    static String propertiesDir = "";

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolveEntity", (Object[])new Object[0]);
        }
        String fileName = null;
        if (systemId.toLowerCase().endsWith("servletcache.dtd")) {
            fileName = "/servletcache.dtd";
        } else if (systemId.toLowerCase().endsWith("dynacache.dtd")) {
            fileName = "/dynacache.dtd";
        }
        if (fileName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("If this is being used for servlet caching, we shouldn't be here; systemId=" + systemId + ", publicId=" + publicId), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resolveEntity");
            }
            return null;
        }
        String xmlFileLoc = propertiesDir + fileName;
        try {
            FileInputStream in = new FileInputStream(xmlFileLoc);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("InputStrean for " + fileName + " is " + in), (Object[])new Object[0]);
            }
            InputSource is = new InputSource(in);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("InputSource.getSystemId() = " + is.getSystemId()), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resolveEntity");
            }
            return is;
        }
        catch (FileNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.PropertiesEntityResolver.resolveEntity", (String)"80", (Object)this);
            return null;
        }
    }
}

