/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.adaptable.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.adaptable.module.NotifierExtension;
import com.ibm.ws.adaptable.module.internal.NotifierImpl;
import com.ibm.ws.adaptable.module.structure.StructureHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.InterpretedContainer;
import com.ibm.wsspi.adaptable.module.Notifier;
import com.ibm.wsspi.artifact.ArtifactContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class InterpretedNotifier
implements Notifier {
    private final boolean isNotifierForFakeRoot;
    private final Notifier delegateNotifier;
    private final String pathInRealRoot;
    private final Map<Notifier.NotificationListener, CorrectInterpretedPathListener> listeners = new HashMap<Notifier.NotificationListener, CorrectInterpretedPathListener>();
    private final InterpretedContainer rootContainer;
    private final StructureHelper structureHelper;
    private final ArtifactContainer rootArtifactContainer;
    static final long serialVersionUID = 5670773220470153517L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public InterpretedNotifier(InterpretedContainer rootContainer, ArtifactContainer rootDelegate, StructureHelper structureHelper) {
        this.delegateNotifier = new NotifierImpl(rootDelegate, rootContainer);
        String rootDelegatePath = rootDelegate.getPath();
        this.isNotifierForFakeRoot = !"/".equals(rootDelegatePath);
        this.pathInRealRoot = this.isNotifierForFakeRoot ? rootDelegatePath : null;
        this.rootContainer = rootContainer;
        this.rootArtifactContainer = rootDelegate;
        this.structureHelper = structureHelper;
    }

    @Override
    public boolean registerForNotifications(Notifier.Notification targets, Notifier.NotificationListener callbackObject) throws IllegalArgumentException {
        Notifier.Notification rootNotification;
        if (this.isNotifierForFakeRoot) {
            HashSet<String> newTargetPaths = new HashSet<String>();
            for (String oldPath : targets.getPaths()) {
                StringBuilder newPath = new StringBuilder();
                if (oldPath.startsWith("!")) {
                    newPath.append("!");
                    oldPath = oldPath.substring(1);
                }
                newPath.append(this.pathInRealRoot);
                if (!oldPath.equals("/")) {
                    newPath.append(oldPath);
                }
                newTargetPaths.add(newPath.toString());
            }
            rootNotification = new DefaultNotification(targets.getContainer(), newTargetPaths);
        } else {
            rootNotification = targets;
        }
        CorrectInterpretedPathListener interpretedListener = new CorrectInterpretedPathListener(callbackObject);
        boolean isRegistered = this.delegateNotifier.registerForNotifications(rootNotification, interpretedListener);
        if (isRegistered) {
            this.listeners.put(callbackObject, interpretedListener);
        }
        return isRegistered;
    }

    @Override
    public boolean removeListener(Notifier.NotificationListener listenerToRemove) {
        Notifier.NotificationListener interpretedListener = this.listeners.remove(listenerToRemove);
        if (interpretedListener != null) {
            return this.delegateNotifier.removeListener(interpretedListener);
        }
        return false;
    }

    @Override
    public boolean setNotificationOptions(long interval, boolean useMBean) {
        return this.delegateNotifier.setNotificationOptions(interval, useMBean);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.adaptable.module.internal.InterpretedNotifier", InterpretedNotifier.class, (String)"archive.adaptable", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class CorrectInterpretedPathListener
    implements NotifierExtension.NotificationListener {
        private final Notifier.NotificationListener listener;
        private final int lengthOfPathInRoot;
        private String id;
        static final long serialVersionUID = 1658620816872501277L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CorrectInterpretedPathListener(Notifier.NotificationListener listener) {
            this.listener = listener;
            int n = this.lengthOfPathInRoot = InterpretedNotifier.this.isNotifierForFakeRoot ? InterpretedNotifier.this.pathInRealRoot.length() : -1;
            if (listener instanceof NotifierExtension.NotificationListener) {
                this.id = ((NotifierExtension.NotificationListener)listener).getId();
            }
        }

        @Override
        public void notifyEntryChange(Notifier.Notification added, Notifier.Notification removed, Notifier.Notification modified) {
            HashSet<String> changedFakeRoots = new HashSet<String>();
            Notifier.Notification interpretedAdded = this.correctPaths(added, changedFakeRoots);
            Notifier.Notification interpretedRemoved = this.correctPaths(removed, changedFakeRoots);
            Notifier.Notification interpretedModified = this.correctPaths(modified, changedFakeRoots);
            interpretedModified.getPaths().addAll(changedFakeRoots);
            this.listener.notifyEntryChange(interpretedAdded, interpretedRemoved, interpretedModified);
        }

        private Notifier.Notification correctPaths(Notifier.Notification notification, Set<String> changedFakeRoots) {
            HashSet<String> interpretedPaths = new HashSet<String>();
            for (String rootPath : notification.getPaths()) {
                String correctedPath;
                correctedPath = InterpretedNotifier.this.isNotifierForFakeRoot ? ((correctedPath = rootPath.substring(this.lengthOfPathInRoot)).isEmpty() ? "/" : correctedPath) : rootPath;
                if (InterpretedNotifier.this.structureHelper.isValid(InterpretedNotifier.this.rootArtifactContainer, rootPath)) {
                    interpretedPaths.add(correctedPath);
                    continue;
                }
                String[] pathParts = correctedPath.split("/");
                StringBuffer pathToTest = new StringBuffer(pathParts[1]);
                String lastValidPath = pathToTest.toString();
                for (int i = 2; i < pathParts.length; ++i) {
                    pathToTest.append("/");
                    pathToTest.append(pathParts[i]);
                    String newPathToTest = pathToTest.toString();
                    if (!InterpretedNotifier.this.structureHelper.isValid(InterpretedNotifier.this.rootArtifactContainer, newPathToTest)) break;
                    lastValidPath = newPathToTest;
                }
                changedFakeRoots.add("/" + lastValidPath);
            }
            DefaultNotification interpretedNotification = new DefaultNotification((Container)InterpretedNotifier.this.rootContainer, interpretedPaths);
            return interpretedNotification;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.adaptable.module.internal.InterpretedNotifier$CorrectInterpretedPathListener", CorrectInterpretedPathListener.class, (String)"archive.adaptable", null);
        }
    }
}

