/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.collector.CollectorJsonUtils;
import com.ibm.ws.logging.collector.Formatter;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.CollectorManager;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public abstract class JsonLogHandler
implements SynchronousHandler,
Formatter {
    protected String serverHostName = null;
    protected String serverName = null;
    protected String wlpUserDir = null;
    protected String wlpServerName = null;
    protected final int MAXFIELDLENGTH = -1;
    protected static volatile boolean isInit = false;
    protected static final String ENV_VAR_CONTAINERHOST = "CONTAINER_HOST";
    protected static final String ENV_VAR_CONTAINERNAME = "CONTAINER_NAME";
    protected static volatile boolean appsWriteJson = false;
    List<String> sourcesList = new ArrayList<String>();
    protected CollectorManager collectorMgr = null;

    @Override
    public void init(CollectorManager collectorManager) {
        try {
            this.collectorMgr = collectorManager;
            this.collectorMgr.subscribe(this, this.convertToSourceIDList(this.sourcesList));
            isInit = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JsonLogHandler(String serverName, String wlpUserDir, List<String> sourcesList) {
        this.wlpServerName = serverName;
        this.wlpUserDir = wlpUserDir;
        this.sourcesList = sourcesList;
        String containerName = System.getenv(ENV_VAR_CONTAINERNAME);
        this.serverName = containerName == null || containerName.equals("") || containerName.length() == 0 ? this.wlpServerName : containerName;
        String containerHost = System.getenv(ENV_VAR_CONTAINERHOST);
        if (containerHost == null || containerHost.equals("") || containerHost.length() == 0) {
            try {
                this.serverHostName = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws UnknownHostException {
                        return InetAddress.getLocalHost().getCanonicalHostName();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.serverHostName = "";
            }
        } else {
            this.serverHostName = containerHost;
        }
        CollectorJsonHelpers.setHostName(this.serverHostName);
        CollectorJsonHelpers.setServerName(this.wlpServerName);
        CollectorJsonHelpers.setWlpUserDir(wlpUserDir);
    }

    public void modified(List<String> newSources) {
        if (this.collectorMgr == null || !isInit) {
            this.sourcesList = newSources;
            return;
        }
        try {
            ArrayList<String> oldSources = new ArrayList<String>(this.sourcesList);
            ArrayList<String> sourcesToRemove = new ArrayList<String>(oldSources);
            sourcesToRemove.removeAll(newSources);
            this.collectorMgr.unsubscribe(this, this.convertToSourceIDList(sourcesToRemove));
            ArrayList<String> sourcesToAdd = new ArrayList<String>(newSources);
            sourcesToAdd.removeAll(oldSources);
            this.collectorMgr.subscribe(this, this.convertToSourceIDList(sourcesToAdd));
            this.sourcesList = newSources;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void setWriter(Object var1);

    @Override
    public void setBufferManager(String sourceId, BufferManager bufferMgr) {
    }

    @Override
    public void unsetBufferManager(String sourceId, BufferManager bufferMgr) {
    }

    @Override
    public Object formatEvent(String source, String location, Object event, String[] tags, int maxFieldLength) {
        String eventType = CollectorJsonUtils.getEventType(source, location);
        String jsonStr = CollectorJsonUtils.jsonifyEvent(event, eventType, this.serverName, this.wlpUserDir, this.serverHostName, "JSON", tags, -1);
        return jsonStr;
    }

    public void setWlpServerName(String serverName) {
        this.wlpServerName = serverName;
    }

    public void setWlpUserDir(String wlpUserDir) {
        this.wlpUserDir = wlpUserDir;
    }

    protected List<String> convertToSourceIDList(List<String> sourceList) {
        ArrayList<String> sourceIDList = new ArrayList<String>();
        for (String source : sourceList) {
            String sourceName = this.getSourceName(source);
            if (sourceName.equals("")) continue;
            if (!sourceName.contains("audit")) {
                sourceIDList.add(this.getSourceName(source) + "|" + "memory");
                continue;
            }
            sourceIDList.add(this.getSourceName(source) + "|" + "server");
        }
        return sourceIDList;
    }

    protected String getSourceName(String source) {
        if (source.equals("message")) {
            return "com.ibm.ws.logging.source.message";
        }
        if (source.equals("ffdc")) {
            return "com.ibm.ws.logging.ffdc.source.ffdcsource";
        }
        if (source.equals("trace")) {
            return "com.ibm.ws.logging.source.trace";
        }
        if (source.equalsIgnoreCase("accessLog")) {
            return "com.ibm.ws.http.logging.source.accesslog";
        }
        if (source.equalsIgnoreCase("audit")) {
            return "audit";
        }
        return "";
    }

    protected String getSourceNameFromDataObject(Object event) {
        GenericData genData = (GenericData)event;
        String sourceName = genData.getSourceName();
        if (sourceName.equals("com.ibm.ws.logging.source.message")) {
            return "com.ibm.ws.logging.source.message";
        }
        if (sourceName.equals("com.ibm.ws.logging.source.trace")) {
            return "com.ibm.ws.logging.source.trace";
        }
        if (sourceName.equals("com.ibm.ws.http.logging.source.accesslog")) {
            return "com.ibm.ws.http.logging.source.accesslog";
        }
        if (sourceName.equals("com.ibm.ws.logging.ffdc.source.ffdcsource")) {
            return "com.ibm.ws.logging.ffdc.source.ffdcsource";
        }
        if (sourceName.contains("audit")) {
            return "audit";
        }
        return "";
    }

    protected static boolean isJSON(String message) {
        return message != null && message.startsWith("{") && message.endsWith("}");
    }

    public void setAppsWriteJson(boolean appsWriteJson) {
        JsonLogHandler.appsWriteJson = appsWriteJson;
    }
}

