/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.server.internal;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ServerInfoMBean.class, DynamicMBean.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "jmx.objectname=WebSphere:feature=kernel,name=ServerInfo"})
public class ServerInfoMBeanImpl
extends StandardMBean
implements ServerInfoMBean {
    static final String VAR_DEFAULTHOSTNAME = "${defaultHostName}";
    private WsLocationAdmin locAdmin;
    private VariableRegistry varReg;
    private static final String JAVA_SPEC_VERSION;
    private static final String JAVA_RUNTIME_VERSION;
    static final long serialVersionUID = 4352355110093159907L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ServerInfoMBeanImpl() throws NotCompliantMBeanException {
        super(ServerInfoMBean.class);
    }

    @Reference(service=WsLocationAdmin.class)
    protected void setWsLocationAdmin(WsLocationAdmin ref) {
        this.locAdmin = ref;
    }

    protected void unsetWsLocationAdmin(WsLocationAdmin ref) {
        if (this.locAdmin == ref) {
            this.locAdmin = null;
        }
    }

    @Reference(service=VariableRegistry.class)
    protected void setVariableRegistry(VariableRegistry ref) {
        this.varReg = ref;
    }

    protected void unsetVariableRegistry(VariableRegistry ref) {
        if (this.varReg == ref) {
            this.varReg = null;
        }
    }

    @Override
    public String getDefaultHostname() {
        String hostname = this.varReg.resolveString(VAR_DEFAULTHOSTNAME);
        if (VAR_DEFAULTHOSTNAME.equals(hostname) || hostname.trim().isEmpty()) {
            return "localhost";
        }
        if ("*".equals(hostname)) {
            return null;
        }
        return hostname.toLowerCase();
    }

    @Override
    public String getUserDirectory() {
        return this.locAdmin.resolveString("${wlp.user.dir}/");
    }

    @Override
    public String getInstallDirectory() {
        return this.locAdmin.resolveString("${wlp.install.dir}/");
    }

    @Override
    public String getName() {
        return this.locAdmin.getServerName();
    }

    @Override
    public String getLibertyVersion() {
        Map productIdToVersionPropertiesMap = null;
        try {
            productIdToVersionPropertiesMap = ProductInfo.getAllProductInfo();
            for (ProductInfo versionProperties : productIdToVersionPropertiesMap.values()) {
                if (versionProperties.getReplacedBy() != null) continue;
                return versionProperties.getVersion();
            }
        }
        catch (ProductInfoParseException productInfoParseException) {
            FFDCFilter.processException((Throwable)productInfoParseException, (String)"com.ibm.ws.kernel.server.internal.ServerInfoMBeanImpl", (String)"121", (Object)this, (Object[])new Object[0]);
        }
        catch (DuplicateProductInfoException duplicateProductInfoException) {
            FFDCFilter.processException((Throwable)duplicateProductInfoException, (String)"com.ibm.ws.kernel.server.internal.ServerInfoMBeanImpl", (String)"123", (Object)this, (Object[])new Object[0]);
        }
        catch (ProductInfoReplaceException productInfoReplaceException) {
            FFDCFilter.processException((Throwable)productInfoReplaceException, (String)"com.ibm.ws.kernel.server.internal.ServerInfoMBeanImpl", (String)"125", (Object)this, (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public String getJavaSpecVersion() {
        return JAVA_SPEC_VERSION;
    }

    @Override
    public String getJavaRuntimeVersion() {
        return JAVA_RUNTIME_VERSION;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.server.internal.ServerInfoMBeanImpl", ServerInfoMBeanImpl.class, null, null);
        JAVA_SPEC_VERSION = System.getProperty("java.specification.version");
        JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    }
}

