/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.service.BeanValidationUsingClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.internal.BeanValidationHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.validation.Validator;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BeanValidationHelperImpl
implements BeanValidationHelper {
    private static final TraceComponent tc = Tr.register(BeanValidationHelperImpl.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
    private BeanValidationUsingClassLoader beanValidationSvc;
    static final long serialVersionUID = -7272852501100971623L;

    @Override
    public void setBeanValidationSvc(Object svc) {
        this.beanValidationSvc = (BeanValidationUsingClassLoader)svc;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateInstance(ModuleMetaData mmd, ClassLoader loader, Object instance) {
        Validator validator = this.beanValidationSvc.getValidator(mmd, loader);
        Set cvSet = null;
        try {
            cvSet = validator.validate(instance, new Class[0]);
        }
        catch (ValidationException validationException) {
            void ve;
            FFDCFilter.processException((Throwable)validationException, (String)"com.ibm.ws.jca.internal.BeanValidationHelperImpl", (String)"49", (Object)this, (Object[])new Object[]{mmd, loader, instance});
            Object[] msgArgs = new Object[]{Util.identity((Object)validator), ve, Util.identity((Object)instance)};
            Tr.error((TraceComponent)tc, (String)"BEAN_VALIDATION_VALIDATOR_FAILED_J2CA1008", (Object[])msgArgs);
        }
        if (cvSet != null && !cvSet.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (ConstraintViolation constraintViolation : cvSet) {
                msg.append("\n\t" + constraintViolation);
            }
            ConstraintViolationException cve = new ConstraintViolationException(msg.toString(), cvSet);
            Object[] msgArgs = new Object[]{Util.identity((Object)instance), cve.getMessage()};
            Tr.error((TraceComponent)tc, (String)"BEAN_VALIDATION_FAILED_J2CA0238", (Object[])msgArgs);
            throw cve;
        }
    }
}

