/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.nio.BufferUnderflowException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DataItem {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    protected static final int HEADER_SIZE = 4;
    protected static final int UNWRITTEN = -1;
    protected int _storageMode = 1;
    protected byte[] _data = null;
    protected int _filePosition = -1;
    protected LogRecord _logRecord = null;
    protected int _dataSize = 0;
    protected RecoverableUnitSectionImpl _rus = null;
    protected boolean _written = false;
    static final long serialVersionUID = -1381324794300558664L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DataItem(int storageMode, byte[] data, RecoverableUnitSectionImpl rus) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"DataItem", (Object)new Object[]{new Integer(storageMode), RLSUtils.toHexString(data, 32), rus});
        }
        this._rus = rus;
        this._data = data;
        this._storageMode = storageMode;
        this._dataSize = data.length;
        this._rus.payloadAdded(this._dataSize + 4);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"DataItem", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DataItem(int storageMode, ReadableLogRecord logRecord, RecoverableUnitSectionImpl rus) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"DataItem", (Object)new Object[]{new Integer(storageMode), logRecord, rus});
        }
        this._rus = rus;
        this._storageMode = storageMode;
        this._logRecord = logRecord;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Reading data size field @ position " + logRecord.position()));
            }
            this._dataSize = logRecord.getInt();
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("This data item contains " + this._dataSize + " bytes of data"));
            }
            this._rus.payloadAdded(this._dataSize + 4);
            this._rus.payloadWritten(this._dataSize + 4);
            this._written = true;
            if (storageMode == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Reading " + this._dataSize + "bytes of data @ position " + logRecord.position()));
                }
                this._data = new byte[this._dataSize];
                this._logRecord.get(this._data);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Tracking " + this._dataSize + "bytes of data @ position " + logRecord.position()));
                }
                this._filePosition = logRecord.position();
                this._data = null;
                this._logRecord.advancePosition(this._dataSize);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            void exc;
            com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)bufferUnderflowException, (String)"com.ibm.ws.recoverylog.spi.DataItem", (String)"162", (Object)this, (Object[])new Object[]{storageMode, logRecord, rus});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.DataItem.DataItem", (String)"176", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"DataItem", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        catch (Exception exc) {
            com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.DataItem", (String)"168", (Object)this, (Object[])new Object[]{storageMode, logRecord, rus});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.DataItem.DataItem", (String)"182", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"DataItem", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"DataItem", (Object)this);
        }
    }

    protected void write(WriteableLogRecord logRecord) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"write", (Object)new Object[]{logRecord, this});
        }
        byte[] data = this.getData();
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Writing '" + data.length + "' bytes " + RLSUtils.toHexString(data, 32)));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Writing length field");
        }
        logRecord.putInt(data.length);
        if (this._storageMode == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Updaing data location references");
            }
            this._filePosition = logRecord.position();
            this._logRecord = logRecord;
            this._data = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Writing data field");
        }
        logRecord.put(data);
        if (!this._written) {
            this._rus.payloadWritten(this._dataSize + 4);
        }
        this._written = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"write");
        }
    }

    protected byte[] getData() {
        byte[] data;
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getData", (Object)this);
        }
        if ((data = this._data) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Cached data located");
            }
        } else if (this._storageMode == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"No cached data located. Attempting data retreival");
            }
            if (this._filePosition != -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Retrieving " + this._dataSize + " bytes of data @ position " + this._filePosition));
                }
                this._logRecord.position(this._filePosition);
                data = new byte[this._dataSize];
                this._logRecord.get(data);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Unable to retrieve data as file position is not set");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)"No cached data located");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getData", (Object)new Object[]{new Integer(data.length), RLSUtils.toHexString(data, 32)});
        }
        return data;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.DataItem", DataItem.class, null, null);
        tc = Tr.register(DataItem.class, (String)"Transaction", null);
    }
}

