/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.impl.Clock;
import com.ibm.ws.microprofile.metrics.impl.CounterImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.SimpleTimer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SimpleTimer30Impl
implements SimpleTimer {
    private final AtomicLong max_previousMinute;
    private final AtomicLong min_previousMinute;
    private final AtomicLong max_thisMinute;
    private final AtomicLong min_thisMinute;
    private final AtomicLong thisMinute;
    private final Counter count;
    private Duration elapsedTime;
    private final Clock clock;
    static final long serialVersionUID = 9146339299271287017L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SimpleTimer30Impl() {
        this(Clock.defaultClock());
    }

    public SimpleTimer30Impl(Clock clock) {
        this.clock = clock;
        this.count = new CounterImpl();
        this.elapsedTime = Duration.ZERO;
        this.max_previousMinute = new AtomicLong(0L);
        this.min_previousMinute = new AtomicLong(0L);
        this.max_thisMinute = new AtomicLong(0L);
        this.min_thisMinute = new AtomicLong(0L);
        this.thisMinute = new AtomicLong(this.getCurrentMinuteFromSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Duration duration) {
        this.maybeStartNewMinute();
        Long duration_nanos = duration.toNanos();
        if (duration_nanos >= 0L) {
            SimpleTimer30Impl simpleTimer30Impl = this;
            synchronized (simpleTimer30Impl) {
                this.count.inc();
                this.elapsedTime = this.elapsedTime.plus(duration);
                if (duration_nanos > this.max_thisMinute.get()) {
                    this.max_thisMinute.set(duration_nanos);
                }
                if (duration_nanos < this.min_thisMinute.get() || this.min_thisMinute.get() == 0L) {
                    this.min_thisMinute.set(duration_nanos);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        this.maybeStartNewMinute();
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Runnable event) {
        this.maybeStartNewMinute();
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    public Context time() {
        this.maybeStartNewMinute();
        return new Context(this, this.clock);
    }

    public long getCount() {
        this.maybeStartNewMinute();
        return this.count.getCount();
    }

    public Duration getElapsedTime() {
        this.maybeStartNewMinute();
        return this.elapsedTime;
    }

    public Duration getMaxTimeDuration() {
        this.maybeStartNewMinute();
        return this.max_previousMinute.get() == 0L ? null : Duration.ofNanos(this.max_previousMinute.get());
    }

    public Duration getMinTimeDuration() {
        this.maybeStartNewMinute();
        return this.min_previousMinute.get() == 0L ? null : Duration.ofNanos(this.min_previousMinute.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStartNewMinute() {
        long newMinute = this.getCurrentMinuteFromSystem();
        if (newMinute > this.thisMinute.get()) {
            SimpleTimer30Impl simpleTimer30Impl = this;
            synchronized (simpleTimer30Impl) {
                if (newMinute > this.thisMinute.get()) {
                    this.thisMinute.set(newMinute);
                    this.max_previousMinute.set(this.max_thisMinute.get());
                    this.min_previousMinute.set(this.min_thisMinute.get());
                    this.max_thisMinute.set(0L);
                    this.min_thisMinute.set(0L);
                }
            }
        }
    }

    private long getCurrentMinuteFromSystem() {
        return System.currentTimeMillis() / 60000L;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.SimpleTimer30Impl", SimpleTimer30Impl.class, (String)"METRICS", (String)"io.openliberty.microprofile.metrics.internal.resources.Metrics");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Context
    implements SimpleTimer.Context {
        private final SimpleTimer30Impl simpleTimer;
        private final Clock clock;
        private final long startTime;
        static final long serialVersionUID = -3458470183370825591L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Context(SimpleTimer30Impl simpleTimer, Clock clock) {
            this.simpleTimer = simpleTimer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.simpleTimer.update(Duration.ofNanos(elapsed));
            return elapsed;
        }

        public void close() {
            this.stop();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.SimpleTimer30Impl$Context", Context.class, (String)"METRICS", (String)"io.openliberty.microprofile.metrics.internal.resources.Metrics");
        }
    }
}

