/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.opentracing.OpentracingFilterHelper;
import com.ibm.ws.opentracing.OpentracingTracerManager;
import com.ibm.ws.opentracing.OpentracingUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.ActiveSpan;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final TraceComponent tc = Tr.register(OpentracingClientFilter.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
    public static final String CLIENT_CONTINUATION_PROP_ID = OpentracingClientFilter.class.getName() + ".Span";
    public static final String CLIENT_SPAN_SKIPPED_ID = OpentracingClientFilter.class.getName() + ".Skipped";
    private OpentracingFilterHelper helper;
    static final long serialVersionUID = 8850730926147154060L;

    OpentracingClientFilter(OpentracingFilterHelper helper) {
        this.setFilterHelper(helper);
    }

    void setFilterHelper(OpentracingFilterHelper helper) {
        this.helper = helper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        boolean process;
        block11: {
            String methodName = "filter(outgoing)";
            Tracer tracer = OpentracingTracerManager.getTracer();
            if (tracer == null) {
                if (!TraceComponent.isAnyTracingEnabled()) return;
                if (!tc.isDebugEnabled()) return;
                Tr.debug((TraceComponent)tc, (String)(methodName + " no tracer"), (Object[])new Object[0]);
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{OpentracingUtils.getTracerText(tracer)});
            }
            URI outgoingUri = clientRequestContext.getUri();
            String outgoingURL = outgoingUri.toURL().toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " outgoing URL"), (Object[])new Object[]{outgoingURL});
            }
            if (process = true) {
                String buildSpanName = this.helper != null ? this.helper.getBuildSpanName(clientRequestContext) : outgoingURL;
                Tracer.SpanBuilder spanBuilder = tracer.buildSpan(buildSpanName);
                spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "client");
                spanBuilder.withTag(Tags.HTTP_URL.getKey(), outgoingURL);
                spanBuilder.withTag(Tags.HTTP_METHOD.getKey(), clientRequestContext.getMethod());
                ActiveSpan activeSpan = spanBuilder.startActive();
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " activeSpan"), (Object[])new Object[]{activeSpan});
                    }
                    tracer.inject(activeSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, Object>)clientRequestContext.getHeaders()));
                    ActiveSpan.Continuation continuation = activeSpan.capture();
                    clientRequestContext.setProperty(CLIENT_CONTINUATION_PROP_ID, (Object)continuation);
                    if (activeSpan == null) break block11;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.opentracing.OpentracingClientFilter", (String)"117", (Object)this, (Object[])new Object[]{clientRequestContext});
                    if (activeSpan == null) throw throwable;
                    try {
                        activeSpan.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.opentracing.OpentracingClientFilter", (String)"117", (Object)this, (Object[])new Object[]{clientRequestContext});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                activeSpan.close();
            } else {
                ActiveSpan currentActiveSpan = tracer.activeSpan();
                if (currentActiveSpan != null) {
                    tracer.inject(currentActiveSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, Object>)clientRequestContext.getHeaders()));
                }
            }
        }
        clientRequestContext.setProperty(CLIENT_SPAN_SKIPPED_ID, (Object)(!process ? 1 : 0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        String methodName = "filter(incoming)";
        Boolean skip = (Boolean)clientRequestContext.getProperty(CLIENT_SPAN_SKIPPED_ID);
        if (skip != null && skip.booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"skipped"});
            }
            clientRequestContext.removeProperty(CLIENT_SPAN_SKIPPED_ID);
            return;
        }
        ActiveSpan.Continuation continuation = (ActiveSpan.Continuation)clientRequestContext.getProperty(CLIENT_CONTINUATION_PROP_ID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{continuation});
        }
        if (continuation == null) {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)(methodName + " no continuation"), (Object[])new Object[0]);
            return;
        }
        clientRequestContext.removeProperty(CLIENT_CONTINUATION_PROP_ID);
        ActiveSpan activeSpan = continuation.activate();
        try {
            Integer httpStatus = clientResponseContext.getStatus();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " httpStatus"), (Object[])new Object[]{httpStatus});
            }
            activeSpan.setTag(Tags.HTTP_STATUS.getKey(), (Number)httpStatus);
            if (clientResponseContext.getStatus() >= 400) {
                activeSpan.setTag(Tags.ERROR.getKey(), true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " error"), (Object[])new Object[]{clientResponseContext.getStatus()});
                }
            }
            if (activeSpan == null) return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.opentracing.OpentracingClientFilter", (String)"183", (Object)this, (Object[])new Object[]{clientRequestContext, clientResponseContext});
            if (activeSpan == null) throw throwable;
            try {
                activeSpan.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.opentracing.OpentracingClientFilter", (String)"183", (Object)this, (Object[])new Object[]{clientRequestContext, clientResponseContext});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        activeSpan.close();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, Object> mvMap;
        static final long serialVersionUID = 4322697928672580337L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapToTextMap(MultivaluedMap<String, Object> mvMap) {
            this.mvMap = mvMap;
        }

        @Trivial
        public Iterator<Map.Entry<String, String>> iterator() {
            throw new UnsupportedOperationException();
        }

        @Trivial
        public void put(String key, String value) {
            this.mvMap.add((Object)key, (Object)value);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.opentracing.OpentracingClientFilter$MultivaluedMapToTextMap", MultivaluedMapToTextMap.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
        }
    }
}

