/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.webcontainer;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.WebModuleInfoImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedWebModuleInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.jaxws.support.JaxWsWebContainerManager;
import com.ibm.ws.jaxws.webcontainer.JaxWsRouterWebApp;
import com.ibm.ws.jaxws.webcontainer.internal.FileUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsWebContainerManagerImpl
implements JaxWsWebContainerManager {
    private static final TraceComponent tc = Tr.register(JaxWsWebContainerManagerImpl.class, (String)"JaxWsWebContainer", (String)"com.ibm.ws.jaxws.webcontainer.internal.resources.JaxWsWebContainerMessages");
    private final AtomicServiceReference<ModuleHandler> webModuleHandlerRef = new AtomicServiceReference("webModuleHandler");
    private final AtomicServiceReference<ArtifactContainerFactory> artifactContainerFactoryRef = new AtomicServiceReference("artifactContainerFactory");
    private final AtomicServiceReference<AdaptableModuleFactory> adaptableModuleFactoryRef = new AtomicServiceReference("adaptableModuleFactory");
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("wsLocationAdmin");
    private final Map<J2EEName, File> moduleCacheBaseDirectoryMap = new ConcurrentHashMap<J2EEName, File>();
    private File cacheBaseDirectory;
    static final long serialVersionUID = 1274331058515189761L;

    protected void activate(ComponentContext cc) {
        this.webModuleHandlerRef.activate(cc);
        this.artifactContainerFactoryRef.activate(cc);
        this.adaptableModuleFactoryRef.activate(cc);
        this.locationAdminRef.activate(cc);
        this.cacheBaseDirectory = ((WsLocationAdmin)this.locationAdminRef.getServiceWithException()).getBundleFile((Object)this, "routermodules");
        if (!FileUtils.ensureDirExists(this.cacheBaseDirectory) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{this.cacheBaseDirectory.getAbsolutePath()});
        }
    }

    protected void deactivate(ComponentContext cc) {
        for (File moduleCacheBaseDirectory : this.moduleCacheBaseDirectoryMap.values()) {
            FileUtils.recursiveDelete(moduleCacheBaseDirectory);
        }
        this.moduleCacheBaseDirectoryMap.clear();
        this.webModuleHandlerRef.deactivate(cc);
        this.artifactContainerFactoryRef.deactivate(cc);
        this.adaptableModuleFactoryRef.deactivate(cc);
        this.locationAdminRef.deactivate(cc);
    }

    protected void setWebModuleHandler(ServiceReference<ModuleHandler> ref) {
        this.webModuleHandlerRef.setReference(ref);
    }

    protected void unsetWebModuleHandler(ServiceReference<ModuleHandler> ref) {
        this.webModuleHandlerRef.setReference(null);
    }

    protected void setArtifactContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.artifactContainerFactoryRef.setReference(ref);
    }

    protected void unsetArtifactContainerFactory(ServiceReference<ArtifactContainerFactory> ref) {
        this.artifactContainerFactoryRef.unsetReference(ref);
    }

    protected void setAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactoryRef.setReference(ref);
    }

    protected void unsetAdaptableModuleFactory(ServiceReference<AdaptableModuleFactory> ref) {
        this.adaptableModuleFactoryRef.unsetReference(ref);
    }

    protected void setWsLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetWsLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedWebModuleInfo createWebModuleInfo(ExtendedModuleInfo moduleInfo, String contextRoot) throws UnableToAdaptException {
        try {
            ArtifactContainer artifactContainer;
            File dummyWebApplicationDirectory;
            File cacheOverlayDirectory;
            File cacheAdaptDirectory;
            File cacheDirectory;
            File moduleCacheBaseDirectory = new File(this.cacheBaseDirectory, UUID.randomUUID().toString());
            if (!FileUtils.ensureDirExists(moduleCacheBaseDirectory) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{moduleCacheBaseDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheDirectory = new File(moduleCacheBaseDirectory, "cache")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheAdaptDirectory = new File(moduleCacheBaseDirectory, "cacheAdapt")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheAdaptDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(cacheOverlayDirectory = new File(moduleCacheBaseDirectory, "cacheOverlay")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{cacheOverlayDirectory.getAbsolutePath()});
            }
            if (!FileUtils.ensureDirExists(dummyWebApplicationDirectory = new File(moduleCacheBaseDirectory, "router.war")) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not create directory at {0}.", (Object[])new Object[]{dummyWebApplicationDirectory.getAbsolutePath()});
            }
            if ((artifactContainer = ((ArtifactContainerFactory)this.artifactContainerFactoryRef.getServiceWithException()).getContainer(cacheDirectory, (Object)dummyWebApplicationDirectory)) == null) {
                throw new IllegalStateException("");
            }
            Container moduleContainer = ((AdaptableModuleFactory)this.adaptableModuleFactoryRef.getServiceWithException()).getContainer(cacheAdaptDirectory, cacheOverlayDirectory, artifactContainer);
            JaxWsModuleMetaData jaxWsModuleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)moduleInfo.getMetaData());
            if (jaxWsModuleMetaData == null) {
                return null;
            }
            Container appContainer = moduleInfo.getApplicationInfo().getContainer();
            NonPersistentCache appCache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
            ApplicationClassesContainerInfo appCCI = (ApplicationClassesContainerInfo)appCache.getFromCache(ApplicationClassesContainerInfo.class);
            DeployedAppInfo deployedAppInfo = (DeployedAppInfo)appCCI;
            deployedAppInfo.getDeployedModule(moduleInfo);
            NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
            overlayCache.addToCache(JaxWsModuleMetaData.class, (Object)jaxWsModuleMetaData);
            overlayCache.addToCache(WebApp.class, (Object)new JaxWsRouterWebApp(jaxWsModuleMetaData.getJ2EEName().toString() + "-Router-WebModule"));
            overlayCache.addToCache(JaxWsModuleInfo.class, moduleInfo.getContainer().adapt(JaxWsModuleInfo.class));
            ApplicationInfo appInfo = moduleInfo.getApplicationInfo();
            String ejbModuleName = moduleInfo.getName();
            String webModuleName = ejbModuleName + "-Router";
            String defaultContextRoot = contextRoot == null || contextRoot.isEmpty() ? "/" + ejbModuleName : contextRoot;
            final ClassLoader moduleClassLoader = moduleInfo.getClassLoader();
            ModuleClassLoaderFactory classPathFactory = new ModuleClassLoaderFactory(){
                static final long serialVersionUID = -1766116444809018342L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesContainers) {
                    return moduleClassLoader;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.webcontainer.JaxWsWebContainerManagerImpl$1", 1.class, (String)"JaxWsWebContainer", (String)"com.ibm.ws.jaxws.webcontainer.internal.resources.JaxWsWebContainerMessages");
                }
            };
            WebModuleInfoImpl webModuleInfo = new WebModuleInfoImpl(appInfo, webModuleName, webModuleName, defaultContextRoot, moduleContainer, null, null, classPathFactory);
            ModuleMetaData webModuleMetaData = ((ModuleHandler)this.webModuleHandlerRef.getServiceWithException()).createModuleMetaData((ExtendedModuleInfo)webModuleInfo, deployedAppInfo);
            JaxWsMetaDataManager.setJaxWsModuleMetaData((ModuleMetaData)webModuleMetaData, (JaxWsModuleMetaData)jaxWsModuleMetaData);
            webModuleInfo.setMetaData(webModuleMetaData);
            this.moduleCacheBaseDirectoryMap.put(webModuleMetaData.getJ2EEName(), moduleCacheBaseDirectory);
            return webModuleInfo;
        }
        catch (MetaDataException moduleCacheBaseDirectory) {
            void e;
            FFDCFilter.processException((Throwable)moduleCacheBaseDirectory, (String)"com.ibm.ws.jaxws.webcontainer.JaxWsWebContainerManagerImpl", (String)"218", (Object)this, (Object[])new Object[]{moduleInfo, contextRoot});
            throw new IllegalStateException((Throwable)e);
        }
    }
}

