/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ArchiveUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.asset.JarAsset;
import com.ibm.ws.install.internal.asset.ServerAsset;
import com.ibm.ws.install.internal.asset.ServerPackageAsset;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;

public class ServerPackageJarAsset
extends JarAsset
implements ServerPackageAsset {
    private final Collection<ServerAsset> servers = new HashSet<ServerAsset>();
    private final Collection<String> requiredFeatures = new HashSet<String>();
    private Map<String, String> manifestAttrs = new HashMap<String, String>(0);

    public ServerPackageJarAsset(File assetFile, boolean temporary) throws InstallException {
        super(assetFile, temporary);
        this.setManifestAttributes();
        this.validation();
        this.processServers();
        this.processRequiredFeaturesFromManifest();
    }

    @Override
    public boolean isServerPackage() {
        return true;
    }

    public static boolean validType(String filename) {
        return filename != null && filename.toLowerCase().endsWith(".jar");
    }

    @Override
    public Collection<ServerAsset> getServers() {
        return Collections.unmodifiableCollection(this.servers);
    }

    @Override
    public Collection<String> getRequiredFeatures() {
        return Collections.unmodifiableCollection(this.requiredFeatures);
    }

    @Override
    public Enumeration<? extends ZipEntry> getPackageEntries() {
        return this.jar.entries();
    }

    @Override
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.jar.getInputStream(entry);
    }

    private void setManifestAttributes() throws InstallException {
        try {
            this.manifestAttrs = ArchiveUtils.processArchiveManifest(this.jar);
        }
        catch (Throwable e) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_PACKAGE", this.getAsset().getAbsolutePath()), e, 25);
        }
    }

    private void validation() throws InstallException {
        String appliesTo;
        ArchiveUtils.ArchiveContentType archiveContentType = this.getArchiveContentType(this.manifestAttrs);
        if (null == archiveContentType || !archiveContentType.isServerPackage()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_PACKAGE", this.getAsset().getAbsolutePath()));
        }
        if (ArchiveUtils.ArchiveContentType.INSTALL.equals((Object)archiveContentType) && (null == (appliesTo = this.manifestAttrs.get("Applies-To")) || appliesTo.isEmpty())) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_SERVER_PACKAGE_CONTAINS_RUNTIME", this.getAsset().getAbsolutePath()));
        }
    }

    private String getArchiveRoot() {
        String archRoot = this.manifestAttrs.get("Archive-Root");
        return null != archRoot ? archRoot : "";
    }

    private void processServers() throws InstallException {
        String rootDir = this.getArchiveRoot();
        if (!rootDir.isEmpty()) {
            String[] dirs;
            if (!rootDir.contains("/")) {
                rootDir = rootDir + "/";
            } else if (!(rootDir.indexOf("/") == rootDir.lastIndexOf("/") && rootDir.endsWith("/") || (dirs = rootDir.split("/")).length <= 0)) {
                rootDir = rootDir.startsWith("/") ? "/" + dirs[1] + "/" : dirs[0] + "/";
            }
        }
        Enumeration<JarEntry> jarEntries = this.jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry nextEntry = jarEntries.nextElement();
            String entryName = nextEntry.getName().toLowerCase();
            if (nextEntry.isDirectory() || !entryName.contains("/servers/") || !entryName.endsWith("/server.xml")) continue;
            File serverXML = new File(Utils.getInstallDir(), nextEntry.getName().substring(rootDir.length()));
            String serverName = serverXML.getParentFile().getName();
            this.servers.add(new ServerAsset(serverName, serverXML));
        }
        if (this.servers.isEmpty()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_PACKAGE", this.getAsset().getAbsolutePath()));
        }
    }

    private void processRequiredFeaturesFromManifest() {
        if (this.manifestAttrs.isEmpty()) {
            return;
        }
        String reqFeatures = this.manifestAttrs.get("Require-Feature");
        if (null != reqFeatures && !reqFeatures.isEmpty()) {
            this.requiredFeatures.addAll(Arrays.asList(reqFeatures.split(",")));
        }
    }
}

