/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rest.handler.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTRoutingHelper;
import com.ibm.wsspi.webcontainer.util.RequestUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DefaultRoutingHelper {
    private static final TraceComponent tc = Tr.register(DefaultRoutingHelper.class, (String)"RESTHandler", (String)"com.ibm.ws.rest.handler.internal.resources.RESTHandlerMessages");
    static final long serialVersionUID = 6520160151945450983L;

    protected void activate(ComponentContext cc, Map<String, Object> props) {
    }

    protected void deactivate(ComponentContext cc) {
    }

    protected void setCollectivePlugin(ServiceReference<RESTRoutingHelper> ref) {
    }

    protected void unsetCollectivePlugin(ServiceReference<RESTRoutingHelper> ref) {
    }

    public void routeRequest(RESTRequest request, RESTResponse response) throws IOException {
    }

    public void routeRequest(RESTRequest request, RESTResponse response, boolean legacyURI) throws IOException {
    }

    public static boolean containsLegacyRoutingContext(RESTRequest request) {
        return request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.hostName") != null;
    }

    public static boolean containsRoutingContext(RESTRequest request) {
        if (request.getHeader("collective.hostNames") != null) {
            return true;
        }
        return DefaultRoutingHelper.getQueryParameterValue(request, "collective.hostNames") != null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getQueryParameterValue(RESTRequest request, String name) {
        if (!"post".equalsIgnoreCase(request.getMethod())) {
            return request.getParameter(name);
        }
        if (request.getQueryString() == null) {
            return null;
        }
        Hashtable params = null;
        try {
            params = RequestUtils.parseQueryString((String)request.getQueryString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"129", null, (Object[])new Object[]{request, name});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void e;
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Failed to parse the query string:\n Exception: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        String[] values = (String[])params.get(name);
        String value = null;
        if (values != null && values.length > 0) {
            value = values[0];
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getQueryParameterValues(RESTRequest request, String name) {
        if (!"post".equalsIgnoreCase(request.getMethod())) {
            return request.getParameterValues(name);
        }
        if (request.getQueryString() == null) {
            return null;
        }
        Hashtable params = null;
        try {
            params = RequestUtils.parseQueryString((String)request.getQueryString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"160", null, (Object[])new Object[]{request, name});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void e;
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Failed to parse the query string:\n Exception: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        return (String[])params.get(name);
    }

    public static RoutingContext getLegacyRoutingContext(RESTRequest request) {
        return null;
    }

    public static String URLDecoder(String name) {
        return null;
    }

    public static List<RoutingContext> getRoutingContext(RESTRequest request) {
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class RoutingContext {
        public final String hostName;
        public final String serverInstallDir;
        public final String serverUserDir;
        public final String serverName;
        static final long serialVersionUID = -1314477724594346763L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RoutingContext(String hostName, String serverUserDir, String serverName) {
            this(hostName, null, serverUserDir, serverName);
        }

        public RoutingContext(String hostName, String serverInstallDir, String serverUserDir, String serverName) {
            this.hostName = hostName;
            this.serverInstallDir = serverInstallDir;
            this.serverUserDir = serverUserDir;
            this.serverName = serverName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper$RoutingContext", RoutingContext.class, (String)"RESTHandler", (String)"com.ibm.ws.rest.handler.internal.resources.RESTHandlerMessages");
        }
    }

    public static interface LegacyJMX {
        public static final String CONNECTOR_URI = "IBMJMXConnectorREST";
        public static final String ROUTER_URI = "IBMJMXConnectorREST/router";
        public static final String ROUTING_KEY_HOST_NAME = "com.ibm.websphere.jmx.connector.rest.routing.hostName";
        public static final String ROUTING_KEY_SERVER_NAME = "com.ibm.websphere.jmx.connector.rest.routing.serverName";
        public static final String ROUTING_KEY_SERVER_USER_DIR = "com.ibm.websphere.jmx.connector.rest.routing.serverUserDir";
    }
}

