/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.GBSNode;
import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.msgstore.gbs.OptimisticDepthException;

public abstract class NodeStack {
    static final int VISIT_LEFT = 1;
    static final int PROCESS_CURRENT = 2;
    static final int VISIT_RIGHT = 3;
    static final int DONE_VISITS = 4;
    private GBSTree _tree;
    private GBSNode _endp;
    private int _endIndex;
    private int _topIndex;
    private static final int nmax = 182;
    protected GBSNode[] _node;
    protected int[] _state;
    protected int _idx;
    private int _cidx;
    private int _bpidx;
    private int _maxIdx;
    private String _starter;
    private String _lastStacker;

    public NodeStack(GBSTree tree) {
        this._tree = tree;
        this._node = new GBSNode[182];
        this._state = new int[182];
        this.nodeStackReset();
    }

    public void reset() {
        this.nodeStackReset();
    }

    private void nodeStackReset() {
        this._idx = -1;
        this._cidx = -1;
        this._bpidx = -1;
        this._topIndex = -222;
        this._endp = null;
        this._endIndex = -111;
        this._maxIdx = -1;
    }

    private void stackStart(GBSNode node) {
        this._idx = 0;
        this._cidx = 0;
        this._state[this._cidx] = 0;
        this._node[this._cidx] = node;
        this._bpidx = this._cidx + 1;
        this._maxIdx = this._cidx;
    }

    protected void stackStart(GBSNode node, String starter) {
        this._starter = starter;
        this._lastStacker = null;
        this.stackStart(node);
    }

    void setStacker(String stacker) {
        this._lastStacker = stacker;
    }

    public void push(int state, GBSNode node, String pusher) {
        this._lastStacker = pusher;
        this.push(state, node);
    }

    public void push(int state, GBSNode node) {
        ++this._cidx;
        this._idx = this._cidx;
        if (this._cidx > 47) {
            throw new OptimisticDepthException("maxDepth (47) exceeded.  Depth is " + this._cidx + ".");
        }
        this._state[this._cidx] = state;
        this._node[this._cidx] = node;
        if (this.index() > this._maxIdx) {
            this._maxIdx = this.index();
        }
    }

    void push(GBSNode node) {
        this.push(0, node);
    }

    void printSummary() {
        System.out.println("balancePointIndex = " + this.balancePointIndex());
        for (int i = 0; i <= this._cidx; ++i) {
            System.out.println(i + ": " + this.node(i));
        }
    }

    void reset(int idx) {
        if (idx < 0) {
            throw new RuntimeException("idx < 0, idx = " + idx + ".");
        }
        this._idx = idx;
        this._cidx = idx;
    }

    void balancedPush(int state, GBSNode node) {
        this.push(state, node);
        if (node.balance() != 0) {
            this._bpidx = this._cidx;
        }
    }

    void pop() {
        --this._cidx;
        this._idx = this._cidx;
    }

    public int index() {
        return this._cidx;
    }

    void resetBalancePointIndex() {
        this._bpidx = -2;
    }

    int balancePointIndex() {
        return this._bpidx;
    }

    GBSNode node(int x) {
        return this._node[x];
    }

    GBSNode node() {
        return this._node[this._cidx];
    }

    public GBSNode parent() {
        GBSNode p = null;
        if (this._cidx > 0) {
            p = this._node[this._cidx - 1];
        }
        return p;
    }

    int state() {
        return this._state[this._cidx];
    }

    void setNode(int x, GBSNode node) {
        this._node[x] = node;
    }

    void processSubFringe(GBSNode p) {
        int t0_depth = this._tree.tZeroDepth();
        int ntop = 0;
        int xChild = 0;
        if (p.hasChild()) {
            xChild = 1;
        }
        if (this.index() > t0_depth) {
            ntop = this.index() - (t0_depth - xChild);
        }
        this.innerProcessSubTree(p, 3, ntop);
    }

    public void processSubTree(GBSNode p) {
        this.stackStart(p, "NodeStack.processSubTree");
        this.innerProcessSubTree(p, 1, 0);
    }

    private void innerProcessSubTree(GBSNode p, int initialState, int topIndex) {
        boolean done = false;
        this._topIndex = topIndex;
        this._endp = p;
        this._endIndex = this._idx;
        int s = initialState;
        block6: while (!done) {
            switch (s) {
                case 1: {
                    s = 2;
                    GBSNode q = p.leftChild();
                    while (q != null) {
                        this.push(s, p);
                        p = q;
                        q = p.leftChild();
                    }
                    continue block6;
                }
                case 2: {
                    s = 3;
                    done = this.processNode(p);
                    this._endp = p;
                    this._endIndex = this._idx;
                    continue block6;
                }
                case 3: {
                    s = 4;
                    GBSNode q = p.rightChild();
                    if (q == null) continue block6;
                    this.push(s, p);
                    s = 1;
                    p = p.rightChild();
                    continue block6;
                }
                case 4: {
                    if (this._idx == topIndex) {
                        done = true;
                        continue block6;
                    }
                    s = this._state[this._cidx];
                    p = this._node[this._cidx];
                    this.pop();
                    continue block6;
                }
            }
            throw new RuntimeException("Help!, s = " + s + ".");
        }
    }

    public abstract boolean processNode(GBSNode var1);

    GBSNode lastNode() {
        return this._endp;
    }

    int lastIndex() {
        return this._endIndex;
    }

    int topIndex() {
        return this._topIndex;
    }

    protected GBSTree tree() {
        return this._tree;
    }

    public String stateName(int state) {
        String name = "Unknown state = " + state;
        switch (state) {
            case 1: {
                name = "VISIT_LEFT";
                break;
            }
            case 2: {
                name = "PROCESS_CURRENT";
                break;
            }
            case 3: {
                name = "VISIT_RIGHT";
                break;
            }
            case 4: {
                name = "DONE_VISITS";
            }
        }
        return name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NodeStack, _idx = " + this._idx + ", _cidx = " + this._cidx + ", maxDepth() = " + this.maxDepth() + ", lastIndex() = " + this.lastIndex() + "\n, starter = " + this._starter + ", lastStacker = " + this._lastStacker + "\n");
        if (this.maxDepth() >= 0) {
            for (int i = 0; i <= this.maxDepth(); ++i) {
                GBSNode p = this.node(i);
                if (p == null) {
                    buf.append(i + ": ???\n");
                    continue;
                }
                buf.append(i + ": " + p.lmkString() + ", s = " + this.stateName(this._state[i]) + "\n");
            }
        }
        return buf.toString();
    }

    public int maxDepth() {
        return this._maxIdx;
    }
}

