/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.credentials.ssotoken.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.credentials.CredentialProvider;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SSOTokenCredentialProvider
implements CredentialProvider {
    static final String KEY_TOKEN_MANAGER = "tokenManager";
    public static final String KEY_CREDENTIALS_SERVICE = "credentialsService";
    private final AtomicServiceReference<TokenManager> tokenManagerRef = new AtomicServiceReference("tokenManager");
    private final AtomicServiceReference<CredentialsService> credentialsServiceRef = new AtomicServiceReference("credentialsService");
    static final long serialVersionUID = -3704187528335789662L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void setTokenManager(ServiceReference<TokenManager> reference) {
        this.tokenManagerRef.setReference(reference);
    }

    protected void unsetTokenManager(ServiceReference<TokenManager> reference) {
        this.tokenManagerRef.unsetReference(reference);
    }

    public void setCredentialsService(ServiceReference<CredentialsService> ref) {
        this.credentialsServiceRef.setReference(ref);
    }

    public void unsetCredentialsService(ServiceReference<CredentialsService> ref) {
        this.credentialsServiceRef.unsetReference(ref);
    }

    protected void activate(ComponentContext cc) {
        this.tokenManagerRef.activate(cc);
        this.credentialsServiceRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.tokenManagerRef.deactivate(cc);
        this.credentialsServiceRef.deactivate(cc);
    }

    public void setCredential(Subject subject) throws CredentialException {
        Set<WSPrincipal> principals = subject.getPrincipals(WSPrincipal.class);
        if (principals.isEmpty()) {
            return;
        }
        if (principals.size() != 1) {
            throw new CredentialException("Too many WSPrincipals in the subject");
        }
        WSPrincipal principal = principals.iterator().next();
        CredentialsService cs = (CredentialsService)this.credentialsServiceRef.getService();
        String unauthenticatedUserid = cs.getUnauthenticatedUserid();
        if (principal.getName() != null && unauthenticatedUserid != null && principal.getName().equals(unauthenticatedUserid)) {
            return;
        }
        this.setSsoTokenCredential(subject, principal.getAccessId());
    }

    /*
     * WARNING - void declaration
     */
    private void setSsoTokenCredential(Subject subject, String principalAccessId) throws CredentialException {
        try {
            TokenManager tokenManager = (TokenManager)this.tokenManagerRef.getService();
            SingleSignonToken ssoToken = null;
            Set<Token> tokens = subject.getPrivateCredentials(Token.class);
            if (!tokens.isEmpty()) {
                Token ssoLtpaToken = tokens.iterator().next();
                subject.getPrivateCredentials().remove(ssoLtpaToken);
                ssoToken = tokenManager.createSSOToken(ssoLtpaToken);
            } else {
                HashMap<String, String> tokenData = new HashMap<String, String>();
                tokenData.put("unique_id", principalAccessId);
                ssoToken = tokenManager.createSSOToken(tokenData);
            }
            subject.getPrivateCredentials().add(ssoToken);
        }
        catch (TokenCreationFailedException tokenManager) {
            void e;
            FFDCFilter.processException((Throwable)tokenManager, (String)"com.ibm.ws.security.credentials.ssotoken.internal.SSOTokenCredentialProvider", (String)"112", (Object)this, (Object[])new Object[]{subject, principalAccessId});
            throw new CredentialException(e.getLocalizedMessage());
        }
    }

    public boolean isSubjectValid(Subject subject) {
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.credentials.ssotoken.internal.SSOTokenCredentialProvider", SSOTokenCredentialProvider.class, null, null);
    }
}

