/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.helper.Tag;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Counting;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Sampling;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrometheusBuilder {
    private static final TraceComponent tc = Tr.register(PrometheusBuilder.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    protected static final String QUANTILE = "quantile";
    protected static Set<MetricID> improperGaugeSet = new HashSet<MetricID>();
    static final long serialVersionUID = -8691662219612439346L;

    @FFDCIgnore(value={IllegalStateException.class})
    public static void buildGauge(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap, Double conversionFactor, String appendUnit) {
        PrometheusBuilder.getPromTypeLine(builder, name, "gauge", appendUnit);
        PrometheusBuilder.getPromHelpLine(builder, name, description, appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            Number gaugeValNumber = null;
            Object gaugeValue = null;
            try {
                gaugeValue = ((Gauge)currentMetricMap.get(mid)).getValue();
            }
            catch (IllegalStateException e) {
                return;
            }
            if (!Number.class.isInstance(gaugeValue)) {
                if (!improperGaugeSet.contains(mid)) {
                    Tr.event((TraceComponent)tc, (String)("Skipping Prometheus output for Gauge: " + mid.toString() + " of type " + ((Gauge)currentMetricMap.get(mid)).getValue().getClass()), (Object[])new Object[0]);
                    improperGaugeSet.add(mid);
                }
                return;
            }
            gaugeValNumber = (Number)gaugeValue;
            if (!Double.isNaN(conversionFactor)) {
                gaugeValNumber = gaugeValNumber.doubleValue() * conversionFactor;
            }
            PrometheusBuilder.getPromValueLine(builder, name, gaugeValNumber, mid.getTagsAsString(), appendUnit);
        }
    }

    public static void buildCounter(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        String lineName = PrometheusBuilder.appendSuffixIfNeeded(PrometheusBuilder.getPrometheusMetricName(name), "total");
        PrometheusBuilder.getPromTypeLine(builder, lineName, "counter");
        PrometheusBuilder.getPromHelpLine(builder, lineName, description);
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder.getPromValueLine(builder, lineName, ((Counter)currentMetricMap.get(mid)).getCount(), mid.getTagsAsString());
        }
    }

    public static void buildConcurrentGauge(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        String lineName = name + "_current";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        PrometheusBuilder.getPromHelpLine(builder, lineName, description);
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder.getPromValueLine(builder, lineName, ((ConcurrentGauge)currentMetricMap.get(mid)).getCount(), mid.getTagsAsString());
        }
        lineName = name + "_min";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder.getPromValueLine(builder, lineName, ((ConcurrentGauge)currentMetricMap.get(mid)).getMin(), mid.getTagsAsString());
        }
        lineName = name + "_max";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder.getPromValueLine(builder, lineName, ((ConcurrentGauge)currentMetricMap.get(mid)).getMax(), mid.getTagsAsString());
        }
    }

    public static void buildTimer(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        PrometheusBuilder.buildMetered(builder, name, description, currentMetricMap);
        double conversionFactor = 1.0E-9;
        PrometheusBuilder.buildSampling(builder, name, description, currentMetricMap, conversionFactor, "_seconds");
    }

    public static void buildHistogram(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap, Double conversionFactor, String appendUnit) {
        PrometheusBuilder.buildSampling(builder, name, description, currentMetricMap, conversionFactor, appendUnit);
    }

    public static void buildMeter(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        PrometheusBuilder.buildCounting(builder, name, description, currentMetricMap);
        PrometheusBuilder.buildMetered(builder, name, description, currentMetricMap);
    }

    protected static void buildSampling(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap, Double conversionFactor, String appendUnit) {
        Sampling sampling;
        String lineName = name + "_mean";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            double meanVal = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().getMean() * conversionFactor : sampling.getSnapshot().getMean();
            PrometheusBuilder.getPromValueLine(builder, lineName, meanVal, mid.getTagsAsString(), appendUnit);
        }
        lineName = name + "_max";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            double maxVal = !Double.isNaN(conversionFactor) ? (double)sampling.getSnapshot().getMax() * conversionFactor : (double)sampling.getSnapshot().getMax();
            PrometheusBuilder.getPromValueLine(builder, lineName, maxVal, mid.getTagsAsString(), appendUnit);
        }
        lineName = name + "_min";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            double minVal = !Double.isNaN(conversionFactor) ? (double)sampling.getSnapshot().getMin() * conversionFactor : (double)sampling.getSnapshot().getMin();
            PrometheusBuilder.getPromValueLine(builder, lineName, minVal, mid.getTagsAsString(), appendUnit);
        }
        lineName = name + "_stddev";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            double stdDevVal = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().getStdDev() * conversionFactor : sampling.getSnapshot().getStdDev();
            PrometheusBuilder.getPromValueLine(builder, lineName, stdDevVal, mid.getTagsAsString(), appendUnit);
        }
        PrometheusBuilder.getPromTypeLine(builder, name, "summary", appendUnit);
        PrometheusBuilder.getPromHelpLine(builder, name, description, appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            if (Counting.class.isInstance(sampling)) {
                PrometheusBuilder.getPromValueLine(builder, name, ((Counting)sampling).getCount(), mid.getTagsAsString(), appendUnit == null ? "_count" : appendUnit + "_count");
            }
            double medianVal = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().getMedian() * conversionFactor : sampling.getSnapshot().getMedian();
            double percentile75th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get75thPercentile() * conversionFactor : sampling.getSnapshot().get75thPercentile();
            double percentile95th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get95thPercentile() * conversionFactor : sampling.getSnapshot().get95thPercentile();
            double percentile98th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get98thPercentile() * conversionFactor : sampling.getSnapshot().get98thPercentile();
            double percentile99th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get99thPercentile() * conversionFactor : sampling.getSnapshot().get99thPercentile();
            double percentile999th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get999thPercentile() * conversionFactor : sampling.getSnapshot().get999thPercentile();
            PrometheusBuilder.getPromValueLine(builder, name, medianVal, mid.getTagsAsString(), new Tag(QUANTILE, "0.5"), appendUnit);
            PrometheusBuilder.getPromValueLine(builder, name, percentile75th, mid.getTagsAsString(), new Tag(QUANTILE, "0.75"), appendUnit);
            PrometheusBuilder.getPromValueLine(builder, name, percentile95th, mid.getTagsAsString(), new Tag(QUANTILE, "0.95"), appendUnit);
            PrometheusBuilder.getPromValueLine(builder, name, percentile98th, mid.getTagsAsString(), new Tag(QUANTILE, "0.98"), appendUnit);
            PrometheusBuilder.getPromValueLine(builder, name, percentile99th, mid.getTagsAsString(), new Tag(QUANTILE, "0.99"), appendUnit);
            PrometheusBuilder.getPromValueLine(builder, name, percentile999th, mid.getTagsAsString(), new Tag(QUANTILE, "0.999"), appendUnit);
        }
    }

    protected static void buildCounting(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        String lineName = name + "_total";
        PrometheusBuilder.getPromTypeLine(builder, lineName, "counter");
        PrometheusBuilder.getPromHelpLine(builder, lineName, description);
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder.getPromValueLine(builder, lineName, ((Counting)currentMetricMap.get(mid)).getCount(), mid.getTagsAsString());
        }
    }

    protected static void buildMetered(StringBuilder builder, String name, String description, Map<MetricID, Metric> map) {
        String lineName = name + "_rate_" + "per_second".toString();
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : map.keySet()) {
            PrometheusBuilder.getPromValueLine(builder, lineName, ((Metered)map.get(mid)).getMeanRate(), mid.getTagsAsString());
        }
        lineName = name + "_one_min_rate_" + "per_second".toString();
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : map.keySet()) {
            PrometheusBuilder.getPromValueLine(builder, lineName, ((Metered)map.get(mid)).getOneMinuteRate(), mid.getTagsAsString());
        }
        lineName = name + "_five_min_rate_" + "per_second".toString();
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : map.keySet()) {
            PrometheusBuilder.getPromValueLine(builder, lineName, ((Metered)map.get(mid)).getFiveMinuteRate(), mid.getTagsAsString());
        }
        lineName = name + "_fifteen_min_rate_" + "per_second".toString();
        PrometheusBuilder.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : map.keySet()) {
            PrometheusBuilder.getPromValueLine(builder, lineName, ((Metered)map.get(mid)).getFifteenMinuteRate(), mid.getTagsAsString());
        }
    }

    protected static void getPromValueLine(StringBuilder builder, String name, Number value, String tags) {
        PrometheusBuilder.getPromValueLine(builder, name, value, tags, null);
    }

    protected static void getPromValueLine(StringBuilder builder, String name, Number value, String tags, Tag quantile, String appendUnit) {
        tags = tags == null || tags.isEmpty() ? quantile.getKey() + "=\"" + quantile.getValue() + "\"" : tags + "," + quantile.getKey() + "=\"" + quantile.getValue() + "\"";
        PrometheusBuilder.getPromValueLine(builder, name, value, tags, appendUnit);
    }

    protected static void getPromValueLine(StringBuilder builder, String name, Number value, String tags, String appendUnit) {
        String metricName = PrometheusBuilder.getPrometheusMetricName(name);
        builder.append(metricName);
        if (appendUnit != null) {
            builder.append(appendUnit);
        }
        if (tags != null && tags.length() > 0) {
            builder.append("{").append(tags).append("}");
        }
        builder.append(" ").append(value).append('\n');
    }

    protected static void getPromHelpLine(StringBuilder builder, String name, String description) {
        PrometheusBuilder.getPromHelpLine(builder, name, description, null);
    }

    protected static void getPromHelpLine(StringBuilder builder, String name, String description, String appendUnit) {
        String metricName = PrometheusBuilder.getPrometheusMetricName(name);
        if (description != null && !description.isEmpty()) {
            builder.append("# HELP ").append(metricName);
            if (appendUnit != null) {
                builder.append(appendUnit);
            }
            builder.append(" ").append(description).append("\n");
        }
    }

    protected static void getPromTypeLine(StringBuilder builder, String name, String type) {
        PrometheusBuilder.getPromTypeLine(builder, name, type, null);
    }

    protected static void getPromTypeLine(StringBuilder builder, String name, String type, String appendUnit) {
        String metricName = PrometheusBuilder.getPrometheusMetricName(name);
        builder.append("# TYPE ").append(metricName);
        if (appendUnit != null) {
            builder.append(appendUnit);
        }
        builder.append(" ").append(type).append("\n");
    }

    protected static String getPrometheusMetricName(String name) {
        String out = name;
        out = out.replaceAll("[-+_.!?@#$%^&*`'\\s]+", "_");
        out = out.replaceAll("^[0-9]*(.*?)", "$1");
        out = out.replaceAll("[^A-Za-z0-9_]", "");
        return out;
    }

    protected static String appendSuffixIfNeeded(String metricName, String suffix) {
        return !metricName.endsWith("_" + suffix) ? metricName + "_" + suffix : metricName;
    }
}

