/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyRecursionResolver;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectReaderBase;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;

public final class CopyState {
    static Logger logger = Logger.getLogger(CopyState.class.getName());
    private IdentityHashMap copied;
    private IdentityHashMap recursionResolverMap;
    private TypeRepository rep;
    private static java.lang.Object recursionCheck = new java.lang.Object();
    private int idx;

    public CopyState(TypeRepository rep) {
        this.rep = rep;
        this.copied = new IdentityHashMap();
        this.recursionResolverMap = new IdentityHashMap();
    }

    public void registerRecursion(CopyRecursionResolver resolver) {
        CopyRecursionResolver orig;
        java.lang.Object key = resolver.orig;
        resolver.next = orig = (CopyRecursionResolver)this.recursionResolverMap.get(key);
        this.recursionResolverMap.put(key, resolver);
        logger.fine("registering recursion resolver " + resolver + " for " + key.getClass() + "@" + System.identityHashCode(key));
    }

    public void put(java.lang.Object orig, java.lang.Object copy) {
        java.lang.Object old = this.copied.put(orig, copy);
        if (old == recursionCheck) {
            CopyRecursionResolver resolver = (CopyRecursionResolver)this.recursionResolverMap.get(orig);
            while (resolver != null) {
                logger.fine("invoking " + resolver + " for " + orig.getClass() + "@" + System.identityHashCode(orig) + " ===> " + copy.getClass() + "@" + System.identityHashCode(copy));
                resolver.resolve(copy);
                resolver = resolver.next;
            }
        }
    }

    private String spaces(int c) {
        StringBuffer sb = new StringBuffer();
        while (c-- != 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public java.lang.Object copy(java.lang.Object orig) throws CopyRecursionException {
        if (orig == null) {
            return orig;
        }
        java.lang.Object copy = this.copied.get(orig);
        if (copy != null) {
            if (copy == recursionCheck) {
                logger.fine("throwign CopyRecursion for " + orig.getClass() + "@" + System.identityHashCode(orig));
                throw new CopyRecursionException(this, orig);
            }
            return copy;
        }
        Class<?> origClass = orig.getClass();
        logger.fine("[" + this.hashCode() + "]" + this.spaces(this.idx++) + "copying instance of " + origClass);
        TypeDescriptor desc = this.rep.getDescriptor(origClass);
        this.copied.put(orig, recursionCheck);
        copy = desc.copyObject(orig, this);
        this.copied.put(orig, copy);
        logger.fine(this.spaces(--this.idx) + "=> " + copy);
        return copy;
    }

    public ObjectWriter createObjectWriter(final Serializable obj) {
        try {
            return (ObjectWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws IOException {
                    return new Writer(obj);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (InternalError)new InternalError(e.getMessage()).initCause(e);
        }
    }

    public class Reader
    extends ObjectReaderBase {
        int cpos;
        List contents;

        private java.lang.Object dequeue() {
            java.lang.Object result;
            if ((result = this.contents.get(this.cpos++)) == recursionCheck) {
                throw new IllegalStateException("recursion was not resolved?");
            }
            return result;
        }

        private void undequeue(java.lang.Object o) {
            this.contents.set(--this.cpos, o);
        }

        Reader(Serializable obj, List data) throws IOException {
            super(obj);
            this.contents = data;
            this.cpos = 0;
        }

        @Override
        public java.lang.Object readAbstractObject() {
            return this.dequeue();
        }

        @Override
        public java.lang.Object readAny() {
            return this.dequeue();
        }

        @Override
        public java.lang.Object readValueObject() {
            return this.dequeue();
        }

        @Override
        public java.lang.Object readValueObject(Class<?> clz) {
            return this.dequeue();
        }

        @Override
        public Object readCorbaObject(Class<?> type) {
            return (Object)this.dequeue();
        }

        @Override
        public Remote readRemoteObject(Class<?> type) {
            return (Remote)this.dequeue();
        }

        @Override
        public void readFully(byte[] arr, int off, int val) throws IOException {
            while (val > 0) {
                int bytes = this.read(arr, off, val);
                off += bytes;
                val -= bytes;
            }
        }

        @Override
        public int read(byte[] arr, int off, int len) throws IOException {
            java.lang.Object obj = this.dequeue();
            if (obj instanceof byte[]) {
                byte[] data = (byte[])obj;
                if (data.length <= len) {
                    System.arraycopy(data, 0, arr, off, data.length);
                    return data.length;
                }
                System.arraycopy(data, 0, arr, off, len);
                byte[] newdata = new byte[data.length - len];
                System.arraycopy(data, len, newdata, 0, data.length - len);
                this.undequeue(newdata);
                return len;
            }
            if (obj instanceof Byte) {
                Byte b = (Byte)obj;
                arr[off] = b;
                return 1;
            }
            throw new IOException("stream contents is not byte[], it is: " + obj.getClass().getName());
        }

        @Override
        public int skipBytes(int len) throws IOException {
            byte[] data = new byte[len];
            this.readFully(data);
            return len;
        }

        @Override
        public boolean readBoolean() throws IOException {
            try {
                return (Boolean)this.dequeue();
            }
            catch (ClassCastException ex) {
                IOException iox = new IOException(ex.getMessage());
                iox.initCause(ex);
                throw iox;
            }
        }

        @Override
        public byte readByte() throws IOException {
            try {
                return (Byte)this.dequeue();
            }
            catch (ClassCastException ex) {
                IOException iox = new IOException(ex.getMessage());
                iox.initCause(ex);
                throw iox;
            }
        }

        @Override
        public short readShort() throws IOException {
            try {
                return (Short)this.dequeue();
            }
            catch (ClassCastException ex) {
                IOException iox = new IOException(ex.getMessage());
                iox.initCause(ex);
                throw iox;
            }
        }

        @Override
        public char readChar() throws IOException {
            try {
                return ((Character)this.dequeue()).charValue();
            }
            catch (ClassCastException ex) {
                IOException iox = new IOException(ex.getMessage());
                iox.initCause(ex);
                throw iox;
            }
        }

        @Override
        public int readInt() throws IOException {
            try {
                return (Integer)this.dequeue();
            }
            catch (ClassCastException ex) {
                IOException iox = new IOException(ex.getMessage());
                iox.initCause(ex);
                throw iox;
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                return (Long)this.dequeue();
            }
            catch (ClassCastException ex) {
                IOException iox = new IOException(ex.getMessage());
                iox.initCause(ex);
                throw iox;
            }
        }

        @Override
        public float readFloat() throws IOException {
            try {
                return ((Float)this.dequeue()).floatValue();
            }
            catch (ClassCastException ex) {
                IOException iox = new IOException(ex.getMessage());
                iox.initCause(ex);
                throw iox;
            }
        }

        @Override
        public double readDouble() throws IOException {
            try {
                return (Double)this.dequeue();
            }
            catch (ClassCastException ex) {
                IOException iox = new IOException(ex.getMessage());
                iox.initCause(ex);
                throw iox;
            }
        }

        @Override
        public String readLine() throws IOException {
            throw new InternalError("cannot use readline");
        }

        @Override
        public String readUTF() throws IOException {
            return (String)this.dequeue();
        }

        @Override
        protected void _startValue() {
        }

        @Override
        protected void _endValue() {
        }
    }

    class Writer
    extends ObjectWriter {
        List contents;

        private void enqueue(java.lang.Object o) {
            this.contents.add(o);
        }

        Writer(Serializable obj) throws IOException {
            super(obj);
            this.contents = new ArrayList();
        }

        @Override
        public ObjectReader getObjectReader(java.lang.Object val) {
            try {
                CopyState.this.put(this.object, val);
                return new Reader((Serializable)val, this.contents);
            }
            catch (IOException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
        }

        @Override
        public void write(int val) throws IOException {
            this.beforeWriteData();
            this.enqueue(new Byte((byte)val));
        }

        @Override
        public void write(byte[] val) throws IOException {
            this.write(val, 0, val.length);
        }

        @Override
        public void write(byte[] arr, int off, int len) throws IOException {
            if (arr == null || arr.length == 0) {
                this.beforeWriteData();
                this.enqueue(null);
            } else if (off == 0 && len == arr.length) {
                this.beforeWriteData();
                this.enqueue(arr);
            } else {
                byte[] data = new byte[len];
                System.arraycopy(arr, off, data, 0, len);
                this.beforeWriteData();
                this.enqueue(data);
            }
        }

        @Override
        public void writeBoolean(boolean val) throws IOException {
            this.beforeWriteData();
            this.enqueue(new Boolean(val));
        }

        @Override
        public void writeByte(int val) throws IOException {
            this.beforeWriteData();
            this.enqueue(new Byte((byte)val));
        }

        @Override
        public void writeShort(int val) throws IOException {
            this.beforeWriteData();
            this.enqueue(new Short((short)val));
        }

        @Override
        public void writeChar(int val) throws IOException {
            this.beforeWriteData();
            this.enqueue(new Character((char)val));
        }

        @Override
        public void writeInt(int val) throws IOException {
            this.beforeWriteData();
            this.enqueue(new Integer(val));
        }

        @Override
        public void writeLong(long val) throws IOException {
            this.beforeWriteData();
            this.enqueue(new Long(val));
        }

        @Override
        public void writeFloat(float val) throws IOException {
            this.beforeWriteData();
            this.enqueue(new Float(val));
        }

        @Override
        public void writeDouble(double val) throws IOException {
            this.beforeWriteData();
            this.enqueue(new Double(val));
        }

        @Override
        public void writeBytes(String val) throws IOException {
            this.beforeWriteData();
            byte[] data = val.getBytes();
            this.enqueue(data);
        }

        @Override
        public void writeChars(String val) throws IOException {
            this.beforeWriteData();
            char[] data = val.toCharArray();
            this.enqueue(data);
        }

        @Override
        public void writeUTF(String val) throws IOException {
            this.beforeWriteData();
            this.enqueue(val);
        }

        @Override
        public void writeObjectOverride(java.lang.Object obj) {
            java.lang.Object copy;
            try {
                copy = CopyState.this.copy(obj);
            }
            catch (CopyRecursionException rec) {
                copy = recursionCheck;
                final int idx = this.contents.size();
                CopyState.this.registerRecursion(new CopyRecursionResolver(obj){

                    @Override
                    public void resolve(java.lang.Object newValue) {
                        Writer.this.contents.set(idx, newValue);
                    }
                });
            }
            this.enqueue(copy);
        }

        @Override
        public void writeValueObject(java.lang.Object obj) {
            this.writeObjectOverride(obj);
        }

        @Override
        public void writeCorbaObject(java.lang.Object obj) {
            this.writeObjectOverride(obj);
        }

        @Override
        public void writeRemoteObject(java.lang.Object obj) {
            this.writeObjectOverride(obj);
        }

        @Override
        public void writeAny(java.lang.Object obj) {
            this.writeObjectOverride(obj);
        }

        @Override
        protected void _startValue(String rep_id) throws IOException {
        }

        @Override
        protected void _endValue() throws IOException {
        }

        @Override
        protected void _nullValue() throws IOException {
        }
    }
}

