/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax;

import com.ibm.xml.xlxp2.api.stax.SAXStreamWriterImpl;
import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XMLStreamWriterExternalSerializer
extends SAXStreamWriterImpl {
    protected Properties fSerializerFactoryProps = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
    protected SerializationHandler fSerializationHandler;

    public XMLStreamWriterExternalSerializer() throws IOException, XMLStreamException {
        Serializer serializer = SerializerFactory.getSerializer((Properties)this.fSerializerFactoryProps);
        this.fSerializationHandler = (SerializationHandler)serializer.asContentHandler();
    }

    void setWriter(Writer writer, boolean bl) {
        this.reset(bl);
        this.fSerializationHandler.setWriter(writer);
    }

    void setOutputStream(OutputStream outputStream, boolean bl) {
        this.reset(bl);
        this.fSerializationHandler.setOutputStream(outputStream);
    }

    void setOutputStream(OutputStream outputStream, String string, boolean bl) {
        this.reset(bl);
        this.fSerializerFactoryProps.put("encoding", string);
        this.fSerializationHandler.setOutputFormat(this.fSerializerFactoryProps);
        this.fSerializationHandler.setOutputStream(outputStream);
    }

    protected void reset(boolean bl) {
        super.reset(bl);
        if (this.fSerializationHandler != null) {
            this.fSerializationHandler.reset();
            this.fSerializationHandler.setOmitXMLDeclaration(true);
            this.setHandlersNoReset((ContentHandler)this.fSerializationHandler, (LexicalHandler)this.fSerializationHandler);
        }
    }

    public void writeAsEncodedUnicode(XMLEvent xMLEvent) throws XMLStreamException {
        xMLEvent.writeAsEncodedUnicode(this.fSerializationHandler.getWriter());
    }

    public void close() throws XMLStreamException {
        this.checkFinishStartElement();
        this.fNamespaceContext.reset();
        this.fCHandler = null;
        this.fLHandler = null;
        this.fCurrentElementDepth = 0;
        this.fAttributes.clear();
        this.fSerializationHandler.close();
    }

    public void flush() throws XMLStreamException {
        super.flush();
        try {
            this.fSerializationHandler.flushPending();
            if (this.fSerializationHandler.getWriter() != null) {
                this.fSerializationHandler.getWriter().flush();
            } else {
                this.fSerializationHandler.getOutputStream().flush();
            }
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeDTD(String string) throws XMLStreamException {
        try {
            if (this.fSerializationHandler.getWriter() != null) {
                this.fSerializationHandler.getWriter().write(string);
            } else {
                this.fSerializationHandler.getOutputStream().write(string.getBytes());
            }
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument("UTF-8", "1.0");
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.fSerializationHandler.setOmitXMLDeclaration(true);
        Writer writer = this.fSerializationHandler.getWriter();
        try {
            writer.write("<?xml version=\"");
            writer.write(string != null ? string : "1.0");
            writer.write(34);
            writer.write("?>");
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
        super.writeStartDocument();
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.fSerializationHandler.setOmitXMLDeclaration(false);
        Properties properties = this.fSerializationHandler.getOutputFormat();
        if (string2 != null) {
            properties.put("version", string2);
        }
        if (string != null) {
            properties.put("encoding", string);
        }
        this.fSerializationHandler.setOutputFormat(properties);
        super.writeStartDocument();
    }
}

