/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.sax.impl.parser;

import com.ibm.xml.xlxp2.api.sax.impl.SAX2DTDScanner;
import com.ibm.xml.xlxp2.api.sax.impl.SAX2DocumentScanner;
import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParserBase;
import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParserCallbacks;
import com.ibm.xml.xlxp2.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SAX2Parser
extends SAX2ParserBase
implements SAX2ParserCallbacks {
    protected SAX2ParsedEntityFactory fEntityFactory;
    protected SAX2DTDScanner fDTDScanner;
    protected SAX2DocumentScanner fScanner;

    public SAX2Parser() {
        this(true);
    }

    protected SAX2Parser(boolean bl) {
        this.fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
        if (bl) {
            this.initialize();
        }
    }

    protected void initialize() {
        this.fScanner = this.createSAX2DocumentScanner();
        this.fDTDScanner = this.createSAX2DTDScanner();
        this.fScanner.setDTDSupport(this.fDTDScanner);
    }

    protected void reset(boolean bl) {
        this.fDTDScanner.reset(bl);
        this.fEntityFactory.reset(bl);
        this.fScanner.reset(bl);
        super.reset(bl);
    }

    protected SAX2DocumentScanner createSAX2DocumentScanner() {
        return new SAX2DocumentScanner(this.fBufferFactory, this.fSymbolTable, this);
    }

    protected SAX2DTDScanner createSAX2DTDScanner() {
        return new SAX2DTDScanner(this.fScanner, this.fSymbolTable, this.fEntityFactory, this);
    }

    protected CharConversionError parseEvents(InputSource inputSource) {
        this.fScanner.setNamespaceAwareness(this.fNamespaces);
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputSource);
        if (parsedEntity != null) {
            if (parsedEntity.error == null) {
                this.fScanner.parseDocumentEntity(parsedEntity);
                return null;
            }
            CharConversionError charConversionError = parsedEntity.error;
            parsedEntity.release();
            return charConversionError;
        }
        return null;
    }

    public void endDTD() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endDTD();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public boolean skippedExternalSubsetEntity() {
        if (this.fContentHandler != null) {
            try {
                this.fContentHandler.skippedEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        return true;
    }

    public void startDTDEntity() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endDTDEntity() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void startPE(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startEntity("%" + xMLString);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endPE(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endEntity("%" + xMLString);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void processingInstructionInDTD(XMLString xMLString, XMLString xMLString2) {
        super.processingInstruction(xMLString, xMLString2);
    }

    public void commentInDTD(XMLString xMLString) {
        super.comment(xMLString);
    }

    protected boolean isStandalone(String string) {
        return this.fDTDScanner.isStandalone();
    }

    protected boolean getScanExternalGeneralEntities(String string) {
        return this.fDTDScanner.getScanExternalGeneralEntities();
    }

    protected void setScanExternalGeneralEntities(String string, boolean bl) {
        this.fDTDScanner.setScanExternalGeneralEntities(bl);
    }

    protected boolean getScanExternalParameterEntities(String string) {
        return this.fDTDScanner.getScanExternalParameterEntities();
    }

    protected void setScanExternalParameterEntities(String string, boolean bl) {
        this.fDTDScanner.setScanExternalParameterEntities(bl);
    }

    protected boolean getResolveDTDURIs(String string) {
        return this.fDTDScanner.getResolveDTDURIs(string);
    }

    protected void setResolveDTDURIs(String string, boolean bl) {
        this.fDTDScanner.setResolveDTDURIs(string, bl);
    }

    protected DeclHandler getDeclHandler() {
        return this.fDTDScanner.getDeclHandler();
    }

    protected void setDeclHandler(DeclHandler declHandler) {
        this.fDTDScanner.setDeclHandler(declHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDScanner.getDTDHandler();
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDScanner.setDTDHandler(dTDHandler);
    }

    public EntityResolver getEntityResolver() {
        return this.fEntityFactory.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fEntityFactory.setEntityResolver(entityResolver);
    }
}

