/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fcg.bcel;

import com.ibm.xtq.bcel.generic.BranchInstruction;
import com.ibm.xtq.bcel.generic.CompoundInstruction;
import com.ibm.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xtq.bcel.generic.GOTO;
import com.ibm.xtq.bcel.generic.Instruction;
import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.InstructionFactory;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.LOOKUPSWITCH;
import com.ibm.xtq.bcel.generic.POP;
import com.ibm.xtq.bcel.generic.PUSH;
import com.ibm.xtq.bcel.generic.TABLESWITCH;
import com.ibm.xtq.bcel.generic.TargetLostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FcgSwitchBuilderBCEL {
    private final InstructionList m_il;
    private final InstructionHandle m_switchInsertionPoint;
    private InstructionHandle m_defaultCase;
    private final ConstantPoolGen _cp;
    private final ArrayList m_breaksToEnd = new ArrayList();
    private final ArrayList m_testsAndLabels = new ArrayList();

    FcgSwitchBuilderBCEL(ConstantPoolGen constantPoolGen, InstructionList instructionList) {
        this._cp = constantPoolGen;
        this.m_il = instructionList;
        this.m_defaultCase = null;
        this.m_switchInsertionPoint = this.m_il.append((BranchInstruction)new TABLESWITCH(new int[0], new InstructionHandle[0], null));
    }

    void startCase(int n) {
        this.m_testsAndLabels.add(new ValueLabelPair(new Integer(n), this.m_il.append(InstructionConstants.NOP)));
    }

    void breakCase() {
        GOTO gOTO = new GOTO(null);
        this.m_breaksToEnd.add(gOTO);
        this.m_il.append((BranchInstruction)gOTO);
    }

    void startDefaultCase() {
        this.m_defaultCase = this.m_il.append(InstructionConstants.NOP);
    }

    void startSwitch() {
    }

    void endSwitch() {
        ValueLabelPair valueLabelPair;
        int n = this.m_testsAndLabels.size();
        if (n == 0) {
            if (this.m_defaultCase == null) {
                this.removeBranchAtStartOfSwitch();
                this.m_il.append((Instruction)new POP());
                return;
            }
        } else if (n == 1 && this.m_defaultCase == null) {
            ValueLabelPair valueLabelPair2 = (ValueLabelPair)this.m_testsAndLabels.get(0);
            int n2 = valueLabelPair2.caseValue;
            PUSH pUSH = new PUSH(this._cp, n2);
            this.m_il.insert(this.m_switchInsertionPoint, (CompoundInstruction)pUSH);
            BranchInstruction branchInstruction = InstructionFactory.createBranchInstruction((short)160, null);
            this.m_il.insert(this.m_switchInsertionPoint, branchInstruction);
            this.removeBranchAtStartOfSwitch();
            InstructionHandle instructionHandle = this.m_il.getEnd();
            try {
                this.m_il.delete(instructionHandle);
            }
            catch (TargetLostException targetLostException) {
                targetLostException.printStackTrace();
            }
            InstructionHandle instructionHandle2 = this.m_il.append(InstructionConstants.NOP);
            branchInstruction.setTarget(instructionHandle2);
            return;
        }
        if (this.m_defaultCase == null) {
            this.startDefaultCase();
            this.breakCase();
        }
        Collections.sort(this.m_testsAndLabels, new Comparator(){

            public int compare(Object object, Object object2) {
                ValueLabelPair valueLabelPair = (ValueLabelPair)object;
                ValueLabelPair valueLabelPair2 = (ValueLabelPair)object2;
                return valueLabelPair.caseValue.compareTo(valueLabelPair2.caseValue);
            }
        });
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            valueLabelPair = (ValueLabelPair)this.m_testsAndLabels.get(i);
            nArray[i] = valueLabelPair.caseValue;
        }
        InstructionHandle[] instructionHandleArray = new InstructionHandle[n];
        valueLabelPair = new LOOKUPSWITCH(nArray, instructionHandleArray, null);
        for (int i = 0; i < n; ++i) {
            ValueLabelPair valueLabelPair3 = (ValueLabelPair)this.m_testsAndLabels.get(i);
            valueLabelPair.setTarget(i, valueLabelPair3.label);
        }
        this.m_switchInsertionPoint.setInstruction((Instruction)valueLabelPair);
        valueLabelPair.setTarget(this.m_defaultCase);
        InstructionHandle instructionHandle = this.m_il.append(InstructionConstants.NOP);
        int n3 = this.m_breaksToEnd.size();
        for (int i = 0; i < n3; ++i) {
            ((BranchInstruction)this.m_breaksToEnd.get(i)).setTarget(instructionHandle);
        }
    }

    private void removeBranchAtStartOfSwitch() {
        try {
            this.m_il.delete(this.m_switchInsertionPoint);
        }
        catch (TargetLostException targetLostException) {
            targetLostException.printStackTrace();
        }
    }

    private static class ValueLabelPair {
        final Integer caseValue;
        final InstructionHandle label;

        ValueLabelPair(Integer n, InstructionHandle instructionHandle) {
            this.caseValue = n;
            this.label = instructionHandle;
        }
    }
}

