/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class CertificateExtensions
implements CertAttrSet<Extension> {
    public static final String IDENT = "x509.info.extensions";
    public static final String NAME = "extensions";
    private Map<String, Extension> map = Collections.synchronizedMap(new LinkedHashMap(11, new Float(0.75).floatValue(), true));
    private boolean unsupportedCritExt = false;
    private Map<String, Extension> unparseableExtensions;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateExtensions";

    public CertificateExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateExtensions");
            debug.exit(16384L, className, "CertificateExtensions");
        }
    }

    public CertificateExtensions(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateExtensions", in);
        }
        this.init(in);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateExtensions");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    void decodeThis(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decodeThis", in);
        }
        DerValue val = new DerValue(in);
        this.init(val.getData());
        if (debug != null) {
            debug.exit(16384L, className, "decodeThis");
        }
    }

    private void init(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "init", in);
        }
        DerValue[] exts = in.getSequence(5);
        for (int i2 = 0; i2 < exts.length; ++i2) {
            Extension ext = new Extension(exts[i2]);
            this.parseExtension(ext);
        }
        if (debug != null) {
            debug.exit(8192L, className, "init");
        }
    }

    private Extension copyExtension(Extension ext) {
        try {
            Class extClass;
            if (debug != null) {
                debug.entry(8192L, (Object)className, "copyExtension", ext);
            }
            if ((extClass = OIDMap.getClass(ext.getExtensionId())) == null) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "copyExtension_1", new Extension(ext));
                }
                return new Extension(ext);
            }
            Class[] params = new Class[]{Boolean.class, Object.class};
            Constructor cons = extClass.getConstructor(params);
            byte[] extData = ext.getExtensionValue();
            int extLen = extData.length;
            Object value = Array.newInstance(Byte.TYPE, extLen);
            for (int i2 = 0; i2 < extLen; ++i2) {
                Array.setByte(value, i2, extData[i2]);
            }
            Object[] passed = new Object[]{new Boolean(ext.isCritical()), value};
            if (debug != null) {
                debug.exit(8192L, (Object)className, "copyExtension_2", (CertAttrSet)cons.newInstance(passed));
            }
            return (Extension)cons.newInstance(passed);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(8192L, className, "copyExtension", e2);
                debug.exit(8192L, (Object)className, "copyExtension_3", null);
            }
            return null;
        }
    }

    private void parseExtension(Extension ext) throws IOException {
        try {
            Class extClass;
            if (debug != null) {
                debug.entry(8192L, (Object)className, "parseExtension", ext);
            }
            if ((extClass = OIDMap.getClass(ext.getExtensionId())) == null) {
                if (ext.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(ext.getExtensionId().toString(), ext) == null) {
                    if (debug != null) {
                        debug.exit(8192L, className, "parseExtension_1");
                    }
                    return;
                }
                if (debug != null) {
                    debug.text(8192L, className, "parseExtension", "Duplicate extensions not allowed");
                }
                throw new IOException("Duplicate extensions not allowed");
            }
            Class[] params = new Class[]{Boolean.class, Object.class};
            Constructor cons = extClass.getConstructor(params);
            byte[] extData = ext.getExtensionValue();
            int extLen = extData.length;
            Object value = Array.newInstance(Byte.TYPE, extLen);
            for (int i2 = 0; i2 < extLen; ++i2) {
                Array.setByte(value, i2, extData[i2]);
            }
            Object[] passed = new Object[]{new Boolean(ext.isCritical()), value};
            CertAttrSet certExt = (CertAttrSet)cons.newInstance(passed);
            if (this.map.put(certExt.getName(), (Extension)((Object)certExt)) != null) {
                if (debug != null) {
                    debug.text(8192L, className, "parseExtension", "Duplicate extensions not allowed");
                }
                throw new IOException("Duplicate extensions not allowed");
            }
            if (debug != null) {
                debug.exit(8192L, className, "parseExtension_1");
            }
        }
        catch (InvocationTargetException invk) {
            Throwable e2 = invk.getTargetException();
            if (!ext.isCritical()) {
                if (this.unparseableExtensions == null) {
                    this.unparseableExtensions = new HashMap<String, Extension>();
                }
                this.unparseableExtensions.put(ext.getExtensionId().toString(), ext);
                if (debug != null) {
                    debug.exception(8192L, className, "parseExtension", invk);
                    e2.printStackTrace();
                    HexDumpEncoder h2 = new HexDumpEncoder();
                    System.err.println(h2.encodeBuffer(ext.getExtensionValue()));
                }
                return;
            }
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw (IOException)new IOException(e2.toString()).initCause(e2);
        }
        catch (IOException e3) {
            throw e3;
        }
        catch (Exception e4) {
            if (debug != null) {
                debug.exception(8192L, className, "parseExtension", e4);
            }
            throw (IOException)new IOException(e4.toString()).initCause(e4);
        }
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.encode(out, false);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void encode(OutputStream out, boolean isCertReq) throws CertificateException, IOException {
        DerOutputStream tmp;
        if (debug != null) {
            debug.entry(16384L, className, "encode", out, new Boolean(isCertReq));
        }
        DerOutputStream extOut = new DerOutputStream();
        Collection<Extension> allExts = this.map.values();
        Object[] objs = allExts.toArray();
        for (int i2 = 0; i2 < objs.length; ++i2) {
            if (objs[i2] instanceof CertAttrSet) {
                ((CertAttrSet)objs[i2]).encode(extOut);
                continue;
            }
            if (objs[i2] instanceof Extension) {
                ((Extension)objs[i2]).encode(extOut);
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "encode", "Illegal extension object");
            }
            throw new CertificateException("Illegal extension object");
        }
        DerOutputStream seq = new DerOutputStream();
        seq.write((byte)48, extOut);
        if (!isCertReq) {
            tmp = new DerOutputStream();
            tmp.write(DerValue.createTag((byte)-128, true, (byte)3), seq);
        } else {
            tmp = seq;
        }
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof Extension)) {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "set", "Unknown extension type.");
            }
            throw new IOException("Unknown extension type.");
        }
        this.map.put(name, (Extension)obj);
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        Extension obj;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if ((obj = this.map.get(name)) == null) {
            if (debug != null) {
                debug.text(16384L, className, "get", "No extension found with name " + name);
            }
            throw new IOException("No extension found with name " + name);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", this.copyExtension(obj));
        }
        return this.copyExtension(obj);
    }

    Extension getExt(String name) {
        Extension obj;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if ((obj = this.map.get(name)) == null) {
            if (debug != null) {
                debug.text(16384L, className, "get", "No extension found with name " + name);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", this.copyExtension(obj));
        }
        return this.copyExtension(obj);
    }

    @Override
    public void delete(String name) throws IOException {
        Extension obj;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if ((obj = this.map.get(name)) == null) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "No extension found with name " + name);
            }
            throw new IOException("No extension found with name " + name);
        }
        this.map.remove(name);
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Extension> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        Map<String, Extension> map = this.map;
        synchronized (map) {
            Enumeration<Extension> enumCount = Collections.enumeration(this.map.values());
            LinkedHashMap<String, Extension> table = new LinkedHashMap<String, Extension>(11, new Float(0.75).floatValue(), true);
            while (enumCount.hasMoreElements()) {
                Extension ext = enumCount.nextElement();
                table.put(ext.getExtensionId().toString(), this.copyExtension(ext));
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getElements", Collections.enumeration(table.values()));
            }
            return Collections.enumeration(table.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Extension> entrySet() {
        if (debug != null) {
            debug.entry(16384L, className, "entrySet");
        }
        Map<String, Extension> map = this.map;
        synchronized (map) {
            Enumeration<Extension> e2 = Collections.enumeration(this.map.values());
            LinkedHashSet<Extension> extSet = new LinkedHashSet<Extension>(11);
            while (e2.hasMoreElements()) {
                Extension ext = e2.nextElement();
                extSet.add(this.copyExtension(ext));
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "entrySet", extSet);
            }
            return extSet;
        }
    }

    public Collection<Extension> getAllExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "getAllExtensions");
        }
        Set<Extension> retVal = this.entrySet();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAllExtensions", retVal);
        }
        return retVal;
    }

    public Map<String, Extension> getUnparseableExtensions() {
        if (this.unparseableExtensions == null) {
            return Collections.emptyMap();
        }
        return this.unparseableExtensions;
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
            debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", this.unsupportedCritExt);
        }
        return this.unsupportedCritExt;
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (this == other) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof CertificateExtensions)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        Collection<Extension> otherC = ((CertificateExtensions)other).getAllExtensions();
        Object[] objs = otherC.toArray();
        int len = objs.length;
        if (len != this.map.size()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        String key = null;
        int i2 = 0;
        if (i2 < len) {
            Extension thisExt;
            if (objs[i2] instanceof CertAttrSet) {
                key = ((CertAttrSet)objs[i2]).getName();
            }
            Extension otherExt = (Extension)objs[i2];
            if (key == null) {
                key = otherExt.getExtensionId().toString();
            }
            if ((thisExt = this.map.get(key)) == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals_4", false);
                }
                return false;
            }
            if (!thisExt.equals(otherExt)) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals_5", false);
                }
                return false;
            }
            return ((Object)this.getUnparseableExtensions()).equals(((CertificateExtensions)other).getUnparseableExtensions());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_6", true);
        }
        return true;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
            debug.exit(16384L, (Object)className, "hashCode", ((Object)this.map).hashCode());
        }
        return ((Object)this.map).hashCode() + ((Object)this.getUnparseableExtensions()).hashCode();
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.map.toString());
        }
        return this.map.toString();
    }
}

