/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;
import java.io.OutputStream;

class ESSCertID {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ESSCertID";
    private static BASE64Encoder b64Encoder = new BASE64Encoder();
    private byte[] certHash;
    private GeneralNames issuer;
    private CertificateSerialNumber serialNumber;

    public ESSCertID(DerValue certId) throws IOException {
        this.certHash = certId.getData().getDerValue().getOctetString();
        if (certId.getData().available() > 0) {
            DerValue issuerSerial = certId.getData().getDerValue();
            try {
                this.issuer = new GeneralNames(issuerSerial.getData().getDerValue());
            }
            catch (GeneralNamesException e2) {
                throw new IOException(e2.getMessage());
            }
            this.serialNumber = new CertificateSerialNumber(issuerSerial.getData().getDerValue());
        }
    }

    public ESSCertID(byte[] hash, SerialNumber sn, GeneralNames names) {
        this.certHash = new byte[hash.length];
        System.arraycopy(hash, 0, this.certHash, 0, hash.length);
        if (sn != null && names != null) {
            this.serialNumber = new CertificateSerialNumber(sn.getNumber());
            this.issuer = new GeneralNames();
            this.issuer.addAll(names);
        }
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.certHash == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "certHash object not specified.");
            }
            throw new IOException("certHash object not specified.");
        }
        DerOutputStream esscertidInternal = new DerOutputStream();
        esscertidInternal.putOctetString(this.certHash);
        if (this.issuer != null && this.serialNumber != null) {
            DerOutputStream issuerSerial = new DerOutputStream();
            try {
                this.issuer.encode(issuerSerial);
            }
            catch (GeneralNamesException e2) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "encode", os);
                }
                throw new IOException(e2.getMessage());
            }
            this.serialNumber.encode(issuerSerial);
            esscertidInternal.write((byte)48, issuerSerial);
        }
        DerOutputStream essCertId = new DerOutputStream();
        essCertId.write((byte)48, esscertidInternal);
        os.write(essCertId.toByteArray());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", os);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[\n\tCertificate hash (SHA-1):\n");
        buffer.append(b64Encoder.encode(this.certHash));
        if (this.issuer != null && this.serialNumber != null) {
            buffer.append("\n\tIssuer: " + this.issuer + "\n");
            buffer.append("\t" + this.serialNumber);
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public SerialNumber getSerialNumber() throws IOException {
        return (SerialNumber)this.serialNumber.get("number");
    }
}

