/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.utility.IRepositoryConfigurationMBeanConnection;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class AddReplicaTask
extends BaseCommandTask {
    private static final String className = AddReplicaTask.class.getName();
    private final IRepositoryConfigurationMBeanConnection repositoryMBean;

    public AddReplicaTask(String scriptName, IRepositoryConfigurationMBeanConnection repositoryMBean) {
        super(scriptName, null);
        this.repositoryMBean = repositoryMBean;
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "addReplica";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("addReplica.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept");
        return this.getTaskHelp("addReplica.desc", "addReplica.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("addReplica.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        Trlog.debug(className, methodName, "Validating command arguments...");
        this.validateArgumentList(args, false);
        Trlog.debug(className, methodName, "Parsing command arguments...");
        String endpoint = this.getTaskTarget(args);
        String controllerHost = this.getControllerHost(args);
        int controllerPort = Integer.valueOf(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String password = this.getControllerPassword(args);
        this.handleAutoAcceptArgument(args);
        this.addReplica(endpoint, controllerHost, controllerPort, user, password);
        Trlog.exit(className, methodName);
    }

    private void addReplica(String endpoint, String controllerHost, int controllerPort, String user, String password) throws TaskErrorException {
        String methodName = "addReplica";
        Trlog.enter(className, methodName, new Object[]{endpoint, controllerHost, controllerPort, user, password.replaceAll(".", "*")});
        this.stdout.println(this.getMessage("addReplica.attempt", new Object[0]));
        Trlog.debug(className, methodName, "Attempting to add replica to the collective with the endpoint: " + endpoint);
        try {
            boolean successful = this.repositoryMBean.addReplica(controllerHost, controllerPort, user, password, endpoint);
            if (successful) {
                this.stdout.println(this.getMessage("addReplica.success", endpoint));
                Trlog.debug(className, methodName, "Successfully added replica to the collective. endpoint: " + endpoint);
            } else {
                this.stdout.println(this.getMessage("addReplica.alreadyAdded", endpoint));
                Trlog.debug(className, methodName, "Failed to add replica, perhaps it is already part of a collective. endpoint: " + endpoint);
            }
        }
        catch (UnknownHostException e) {
            this.abort(this.getMessage("common.hostError", controllerHost), methodName);
        }
        catch (ConnectException e) {
            this.abort(this.getMessage("common.portError", String.valueOf(controllerPort)), methodName);
        }
        catch (IOException e) {
            this.abort(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), methodName);
        }
        catch (KeyManagementException e) {
            this.abort(this.getMessage("addReplica.error", endpoint), methodName);
        }
        catch (InstanceNotFoundException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("addReplica.error", endpoint), methodName);
        }
        catch (NoSuchAlgorithmException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("addReplica.error", endpoint), methodName);
        }
        catch (ReflectionException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("addReplica.error", endpoint), methodName);
        }
        catch (MBeanException e) {
            Trlog.debug(className, methodName, "Caught MBeanException, this happens if a declared exception is thrown.");
            if (e.getCause() instanceof UnknownHostException) {
                this.abort(this.getMessage("common.hostError", this.getEndpointHost(endpoint)), methodName);
            } else {
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("addReplica.error", endpoint), methodName);
            }
        }
        catch (RuntimeMBeanException e) {
            Trlog.debug(className, methodName, "Caught MBeanException, this happens if a runtime exception is thrown." + e.getMessage());
            if (e.getCause() instanceof IllegalArgumentException) {
                this.abort(this.getMessage("common.invalidEndpoint", endpoint), methodName);
            }
            if (e.getCause() instanceof IllegalStateException) {
                this.abort(this.getMessage("addReplica.invalidEndpoint", endpoint), methodName);
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("addReplica.error", endpoint), methodName);
        }
    }
}

