/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.validator.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.validator.Validator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={Validator.class}, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/validation", "com.ibm.wsspi.rest.handler.config.pid=com.ibm.ws.jdbc.dataSource"})
public class DataSourceValidator
implements Validator {
    private static final TraceComponent tc = Tr.register(DataSourceValidator.class, (String)"rest.validation", null);
    @Reference
    private ResourceConfigFactory resourceConfigFactory;
    static final long serialVersionUID = 4499712097050536979L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    public LinkedHashMap<String, ?> validate(Object instance, @Sensitive Map<String, Object> props, Locale locale) {
        String methodName = "validate";
        String user = (String)props.get("user");
        String pass = (String)props.get("password");
        String auth = (String)props.get("auth");
        String authAlias = (String)props.get("authAlias");
        String loginConfig = (String)props.get("loginConfig");
        Map loginConfigProps = (Map)props.get("loginConfigProps");
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"validate", (Object[])new Object[]{user, pass == null ? null : "******", auth, authAlias, loginConfig, loginConfigProps == null ? null : loginConfigProps.keySet()});
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            int authType;
            ResourceConfig config = null;
            int n = "container".equals(auth) ? 0 : (authType = "application".equals(auth) ? 1 : -1);
            if (authType >= 0) {
                config = this.resourceConfigFactory.createResourceConfig(DataSource.class.getName());
                config.setResAuthType(authType);
                if (authAlias != null) {
                    config.addLoginProperty("DefaultPrincipalMapping", authAlias);
                }
                if (loginConfig != null) {
                    config.setLoginConfigurationName(loginConfig);
                }
                if (loginConfigProps != null) {
                    for (Map.Entry entry : loginConfigProps.entrySet()) {
                        Object value = entry.getValue();
                        config.addLoginProperty((String)entry.getKey(), value == null ? null : value.toString());
                    }
                }
            }
            DataSource ds = (DataSource)((ResourceFactory)instance).createResource(config);
            try (Connection con = user == null ? ds.getConnection() : ds.getConnection(user, pass);){
                DatabaseMetaData metadata = con.getMetaData();
                result.put("databaseProductName", metadata.getDatabaseProductName());
                result.put("databaseProductVersion", metadata.getDatabaseProductVersion());
                result.put("jdbcDriverName", metadata.getDriverName());
                result.put("jdbcDriverVersion", metadata.getDriverVersion());
                try {
                    String catalog = con.getCatalog();
                    if (catalog != null && catalog.length() > 0) {
                        result.put("catalog", catalog);
                    }
                }
                catch (SQLFeatureNotSupportedException catalog) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = instance;
                    objectArray[1] = "<sensitive java.util.Map>";
                    objectArray[2] = locale;
                    FFDCFilter.processException((Throwable)catalog, (String)"com.ibm.ws.rest.handler.validator.jdbc.DataSourceValidator", (String)"102", (Object)this, (Object[])objectArray);
                }
                try {
                    String schema = con.getSchema();
                    if (schema != null && schema.length() > 0) {
                        result.put("schema", schema);
                    }
                }
                catch (SQLFeatureNotSupportedException schema) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = instance;
                    objectArray[1] = "<sensitive java.util.Map>";
                    objectArray[2] = locale;
                    FFDCFilter.processException((Throwable)schema, (String)"com.ibm.ws.rest.handler.validator.jdbc.DataSourceValidator", (String)"109", (Object)this, (Object[])objectArray);
                }
                String userName = metadata.getUserName();
                if (userName != null && userName.length() > 0) {
                    result.put("user", userName);
                }
                try {
                    boolean isValid = con.isValid(120);
                    if (!isValid) {
                        result.put("failure", "java.sql.Connection.isValid: false");
                    }
                }
                catch (SQLFeatureNotSupportedException isValid) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = instance;
                    objectArray[1] = "<sensitive java.util.Map>";
                    objectArray[2] = locale;
                    FFDCFilter.processException((Throwable)isValid, (String)"com.ibm.ws.rest.handler.validator.jdbc.DataSourceValidator", (String)"120", (Object)this, (Object[])objectArray);
                }
            }
        }
        catch (Throwable config) {
            void x;
            Object[] objectArray = new Object[3];
            objectArray[0] = instance;
            objectArray[1] = "<sensitive java.util.Map>";
            objectArray[2] = locale;
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.rest.handler.validator.jdbc.DataSourceValidator", (String)"125", (Object)this, (Object[])objectArray);
            ArrayList<String> sqlStates = new ArrayList<String>();
            ArrayList<String> errorCodes = new ArrayList<String>();
            HashSet<void> causes = new HashSet<void>();
            for (Throwable cause = x; cause != null && causes.add((void)cause); cause = cause.getCause()) {
                String sqlState = cause instanceof SQLException ? ((SQLException)cause).getSQLState() : null;
                String errorCode = null;
                if (cause instanceof SQLException) {
                    int ec = ((SQLException)cause).getErrorCode();
                    errorCode = sqlState == null && ec == 0 ? null : Integer.toString(ec);
                }
                sqlStates.add(sqlState);
                errorCodes.add(errorCode);
            }
            result.put("sqlState", sqlStates);
            result.put("errorCode", errorCodes);
            result.put("failure", x);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"validate", result);
        }
        return result;
    }
}

