/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.repository.client.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.RepositoryClient;
import com.ibm.wsspi.collective.repository.RepositoryMember;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RepositoryClient.class, RepositoryMember.class}, property={"service.vendor=IBM", "clientType=RepositoryClientDelegate", "memberType=RepositoryMemberDelegate"})
public class RepositoryConnectionDelegate
implements RepositoryClient,
RepositoryMember {
    private static final TraceComponent tc = Tr.register(RepositoryConnectionDelegate.class, (String)"Collective", (String)"com.ibm.ws.collective.repository.client.internal.resources.RepositoryClientMessages");
    static final String KEY_REPOSITORY_CLIENT = "repositoryClient";
    static final String KEY_REPOSITORY_MEMBER = "repositoryMember";
    private final AtomicServiceReference<RepositoryClient> clientDelegate = new AtomicServiceReference("repositoryClient");
    private final AtomicServiceReference<RepositoryMember> memberDelegate = new AtomicServiceReference("repositoryMember");
    private volatile boolean isDeactivated = false;
    static final long serialVersionUID = 3297807035607676751L;

    @Reference(name="repositoryClient", service=RepositoryClient.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(!(clientType=RepositoryClientDelegate))")
    protected void setRepositoryClient(ServiceReference<RepositoryClient> ref) {
        if (this.clientDelegate.getReference() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Updating RepositoryClient reference. Current reference: " + this.clientDelegate.getReference() + ". Incoming reference: " + ref), (Object[])new Object[0]);
            }
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Using RepositoryClient reference: " + ref), (Object[])new Object[0]);
        }
        this.clientDelegate.setReference(ref);
    }

    protected void unsetRepositoryClient(ServiceReference<RepositoryClient> ref) {
        this.clientDelegate.unsetReference(ref);
    }

    @Reference(name="repositoryMember", service=RepositoryMember.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(!(memberType=RepositoryMemberDelegate))")
    protected void setRepositoryMember(ServiceReference<RepositoryMember> ref) {
        if (this.memberDelegate.getReference() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Updating RepositoryMember reference. Current reference: " + this.memberDelegate.getReference() + ". Incoming reference: " + ref), (Object[])new Object[0]);
            }
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Using RepositoryMember reference: " + ref), (Object[])new Object[0]);
        }
        this.memberDelegate.setReference(ref);
    }

    protected void unsetRepositoryMember(ServiceReference<RepositoryMember> ref) {
        this.memberDelegate.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.clientDelegate.activate(cc);
        this.memberDelegate.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.isDeactivated = true;
        this.clientDelegate.deactivate(cc);
        this.memberDelegate.deactivate(cc);
    }

    private RepositoryClient getCurrentDelegate() {
        RepositoryClient delegate = (RepositoryClient)this.clientDelegate.getService();
        if (delegate == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that RepositoryClient service is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getCurrentDelegate service is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The RepositoryClient service is unavailable - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return delegate;
    }

    public boolean create(String nodeName, @Sensitive Object data) throws IOException, IllegalArgumentException {
        if (tc.isDebugEnabled() && (nodeName.endsWith("sys.status") || nodeName.endsWith("State") || nodeName.endsWith("state"))) {
            Tr.debug((TraceComponent)tc, (String)("NodeName=" + nodeName + ", Value=" + data), (Object[])new Object[0]);
        }
        boolean result = false;
        RepositoryClient delegate = this.getCurrentDelegate();
        if (delegate != null) {
            result = delegate.create(nodeName, data);
        }
        return result;
    }

    public boolean delete(String nodeName) throws IOException, IllegalArgumentException {
        boolean result = false;
        RepositoryClient delegate = this.getCurrentDelegate();
        if (delegate != null) {
            result = delegate.delete(nodeName);
        }
        return result;
    }

    public boolean exists(String nodeName) throws IOException, IllegalArgumentException {
        boolean result = false;
        RepositoryClient delegate = this.getCurrentDelegate();
        if (delegate != null) {
            result = delegate.exists(nodeName);
        }
        return result;
    }

    public Collection<String> getChildren(String nodeName, boolean absolutePath) throws IOException, IllegalArgumentException {
        Collection result = null;
        RepositoryClient delegate = this.getCurrentDelegate();
        if (delegate != null) {
            result = delegate.getChildren(nodeName, absolutePath);
        }
        return result;
    }

    public Object getData(String nodeName) throws IOException, IllegalArgumentException, NoSuchElementException {
        Object result = null;
        RepositoryClient delegate = this.getCurrentDelegate();
        if (delegate != null) {
            result = delegate.getData(nodeName);
        }
        return result;
    }

    public Map<String, Object> getDescendantData(String nodeName) throws IOException, IllegalArgumentException, NoSuchElementException {
        Map result = null;
        RepositoryClient delegate = this.getCurrentDelegate();
        if (delegate != null) {
            result = delegate.getDescendantData(nodeName);
        }
        return result;
    }

    public boolean setData(String nodeName, @Sensitive Object data) throws IOException, IllegalArgumentException {
        if (tc.isDebugEnabled() && (nodeName.endsWith("sys.status") || nodeName.endsWith("State") || nodeName.endsWith("state"))) {
            Tr.debug((TraceComponent)tc, (String)("NodeName=" + nodeName + ", Value=" + data), (Object[])new Object[0]);
        }
        boolean result = false;
        RepositoryClient delegate = this.getCurrentDelegate();
        if (delegate != null) {
            result = delegate.setData(nodeName, data);
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append(", ClientDelegate:");
        RepositoryClient cDelegate = (RepositoryClient)this.clientDelegate.getService();
        if (cDelegate == null) {
            buf.append("(No Delegate)");
        } else {
            buf.append(cDelegate.getClass().getName());
        }
        buf.append(", MemberDelegate:");
        RepositoryMember mDelegate = (RepositoryMember)this.memberDelegate.getService();
        if (mDelegate == null) {
            buf.append("(No Delegate)");
        } else {
            buf.append(mDelegate.getClass().getName());
        }
        return buf.toString();
    }
}

