/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.websphere.security.jwt.KeyException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JwKRetriever;
import com.ibm.ws.security.common.jwk.impl.JwkKidBuilder;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.config.MpConfigProperties;
import com.ibm.ws.security.jwt.internal.BuilderImpl;
import com.ibm.ws.security.jwt.internal.JwtTokenException;
import com.ibm.ws.security.jwt.utils.JwtData;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import org.jose4j.base64url.Base64;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JweHelper {
    private static final TraceComponent tc = Tr.register(JweHelper.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    static final long serialVersionUID = 6410108854260984998L;

    @FFDCIgnore(value={Exception.class})
    public static String createJweString(String jws, JwtData jwtData) throws Exception {
        JweHelper helper = new JweHelper();
        JwtConfig jwtConfig = jwtData.getConfig();
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            BuilderImpl builder = jwtData.getBuilder();
            helper.setJweKeyData(jwe, builder, jwtConfig);
            helper.setJweHeaders(jwe, builder, jwtConfig);
            jwe.setPayload(jws);
            return helper.getJwtString(jwe);
        }
        catch (Exception e) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_BUILDING_SIGNED_JWE", (Object[])new Object[]{jwtConfig.getId(), e});
            throw new Exception(errorMsg, e);
        }
    }

    public static boolean isJws(String jwtString) {
        if (jwtString == null || jwtString.isEmpty()) {
            return false;
        }
        String notPeriod = "[^\\.]";
        return jwtString.matches("^(" + notPeriod + "*\\.){2}" + notPeriod + "*$");
    }

    public static boolean isJwe(String jwtString) {
        if (jwtString == null || jwtString.isEmpty()) {
            return false;
        }
        String notPeriod = "[^\\.]";
        return jwtString.matches("^(" + notPeriod + "*\\.){4}" + notPeriod + "*$");
    }

    public static boolean isJwsRequired(JwtConsumerConfig config, MpConfigProperties mpConfigProps) {
        return !JweHelper.isJweRequired(config, mpConfigProps);
    }

    public static boolean isJweRequired(JwtConsumerConfig config, MpConfigProperties mpConfigProps) {
        String keyAlias = config.getKeyManagementKeyAlias();
        String keyLocation = (String)mpConfigProps.get("mp.jwt.decrypt.key.location");
        return keyAlias != null || keyLocation != null;
    }

    @FFDCIgnore(value={Exception.class})
    public static String extractJwsFromJweToken(String jweString, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws InvalidTokenException {
        JweHelper helper = new JweHelper();
        String payload = null;
        try {
            payload = helper.getJwePayload(jweString, config, mpConfigProps);
        }
        catch (Exception e) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_EXTRACTING_JWS_PAYLOAD_FROM_JWE", (Object[])new Object[]{config.getId(), e});
            throw new InvalidTokenException(errorMsg, e);
        }
        if (!JweHelper.isJws(payload)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"NESTED_JWS_REQUIRED_BUT_NOT_FOUND", (Object[])new Object[0]);
            throw new InvalidTokenException(errorMsg);
        }
        return payload;
    }

    String getJwePayload(String jweString, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws JoseException, Exception, InvalidTokenException {
        JweHelper helper = new JweHelper();
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setCompactSerialization(jweString);
        PrivateKey decryptionKey = helper.getJweDecryptionKey(config, mpConfigProps, helper.getKidFromJweString(jweString));
        jwe.setKey((Key)decryptionKey);
        String payload = jwe.getPayload();
        if (JweHelper.isJws(payload)) {
            helper.verifyContentType(jwe);
        }
        return payload;
    }

    void verifyContentType(JsonWebEncryption jwe) throws InvalidTokenException {
        String requiredContentType = "JWT";
        String cty = jwe.getContentTypeHeaderValue();
        if (cty == null || !requiredContentType.equalsIgnoreCase(cty)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"CTY_NOT_JWT_FOR_NESTED_JWS", (Object[])new Object[]{"\"cty\"", cty, "\"" + requiredContentType + "\""});
            throw new InvalidTokenException(errorMsg);
        }
    }

    @FFDCIgnore(value={Exception.class})
    String getKidFromJweString(String jweString) {
        String kid;
        block2: {
            kid = null;
            try {
                String headerString = jweString.substring(0, jweString.indexOf("."));
                headerString = new String(Base64.decode((String)headerString));
                kid = (String)JwtUtils.claimFromJsonObject(headerString, "kid");
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting kid from JWE string: " + e), (Object[])new Object[0]);
            }
        }
        return kid;
    }

    void setJweKeyData(JsonWebEncryption jwe, BuilderImpl builder, JwtConfig jwtConfig) throws KeyStoreException, CertificateException, InvalidTokenException {
        Key keyManagementKey = this.getKeyManagementKey(builder, jwtConfig);
        if (keyManagementKey == null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"KEY_MANAGEMENT_KEY_NOT_FOUND", (Object[])new Object[]{jwtConfig.getId(), jwtConfig.getKeyManagementKeyAlias(), jwtConfig.getTrustStoreRef()});
            throw new KeyStoreException(errorMsg);
        }
        jwe.setKey(keyManagementKey);
        this.setJweKidHeader(jwe, keyManagementKey);
    }

    Key getKeyManagementKey(BuilderImpl builder, JwtConfig jwtConfig) throws KeyStoreException, CertificateException, InvalidTokenException {
        Key keyManagementKey = builder.getKeyManagementKey();
        if (keyManagementKey == null) {
            keyManagementKey = this.getKeyManagementKeyFromTrustStore(jwtConfig);
        }
        return keyManagementKey;
    }

    PublicKey getKeyManagementKeyFromTrustStore(JwtConfig jwtConfig) throws KeyStoreException, CertificateException, InvalidTokenException {
        String keyAlias = jwtConfig.getKeyManagementKeyAlias();
        String trustStoreRef = jwtConfig.getTrustStoreRef();
        return JwtUtils.getPublicKey(keyAlias, trustStoreRef);
    }

    @Sensitive
    PrivateKey getJweDecryptionKey(JwtConsumerConfig config, MpConfigProperties mpConfigProps, String kid) throws Exception {
        String keyAlias = config.getKeyManagementKeyAlias();
        if (keyAlias != null) {
            String keyStoreRef = config.getKeyStoreRef();
            return JwtUtils.getPrivateKey(keyAlias, keyStoreRef);
        }
        return this.getJweDecryptionKeyFromMpConfigProps(config, mpConfigProps, kid);
    }

    @Sensitive
    private PrivateKey getJweDecryptionKeyFromMpConfigProps(JwtConsumerConfig config, MpConfigProperties mpConfigProps, String kid) throws Exception {
        String keyLocation = (String)mpConfigProps.get("mp.jwt.decrypt.key.location");
        this.checkDecryptKeyLocationForInlineKey(keyLocation);
        JwKRetriever jwkRetriever = new JwKRetriever(config.getJwkSet());
        jwkRetriever.setSignatureAlgorithm(mpConfigProps.getConfiguredSignatureAlgorithm(config));
        jwkRetriever.setKeyLocation(keyLocation);
        return jwkRetriever.getPrivateKeyFromJwk(kid, config.getUseSystemPropertiesForHttpClientConnections());
    }

    void checkDecryptKeyLocationForInlineKey(@Sensitive String location) throws KeyException {
        if (location == null || location.isEmpty()) {
            return;
        }
        if (location.contains("BEGIN ")) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"DECRYPT_KEY_LOCATION_INLINE_KEY", (Object[])new Object[]{"mp.jwt.decrypt.key.location"});
            throw new KeyException(errorMsg);
        }
    }

    void setJweKidHeader(JsonWebEncryption jwe, Key keyManagementKey) {
        JwkKidBuilder kidbuilder = new JwkKidBuilder();
        String keyId = kidbuilder.buildKeyId(keyManagementKey);
        if (keyId != null) {
            jwe.setKeyIdHeaderValue(keyId);
        }
    }

    void setJweHeaders(JsonWebEncryption jwe, BuilderImpl builder, JwtConfig jwtConfig) {
        jwe.setAlgorithmHeaderValue(this.getKeyManagementKeyAlgorithm(builder, jwtConfig));
        jwe.setEncryptionMethodHeaderParameter(this.getContentEncryptionAlgorithm(builder, jwtConfig));
        jwe.setHeader("typ", "JOSE");
        jwe.setHeader("cty", "jwt");
    }

    String getKeyManagementKeyAlgorithm(BuilderImpl builder, JwtConfig jwtConfig) {
        String keyManagementAlg = builder.getKeyManagementAlg();
        if (keyManagementAlg == null) {
            keyManagementAlg = this.getKeyManagementKeyAlgFromConfig(jwtConfig);
        }
        return keyManagementAlg;
    }

    String getKeyManagementKeyAlgFromConfig(JwtConfig jwtConfig) {
        String configuredKeyManagementAlg = jwtConfig.getKeyManagementKeyAlgorithm();
        if (configuredKeyManagementAlg == null) {
            configuredKeyManagementAlg = "RSA-OAEP";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Key management algorithm not specified in server config. Defaulting to [" + configuredKeyManagementAlg + "]"), (Object[])new Object[0]);
            }
        }
        return configuredKeyManagementAlg;
    }

    String getContentEncryptionAlgorithm(BuilderImpl builder, JwtConfig jwtConfig) {
        String contentEncryptionAlg = builder.getContentEncryptionAlg();
        if (contentEncryptionAlg == null) {
            contentEncryptionAlg = this.getContentEncryptionAlgorithmFromConfig(jwtConfig);
        }
        return contentEncryptionAlg;
    }

    String getContentEncryptionAlgorithmFromConfig(JwtConfig jwtConfig) {
        String configuredContentEncryptionAlg = jwtConfig.getContentEncryptionAlgorithm();
        if (configuredContentEncryptionAlg == null) {
            configuredContentEncryptionAlg = "A256GCM";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Content encryption algorithm not specified in server config. Defaulting to [" + configuredContentEncryptionAlg + "]"), (Object[])new Object[0]);
            }
        }
        return configuredContentEncryptionAlg;
    }

    /*
     * WARNING - void declaration
     */
    String getJwtString(JsonWebEncryption jwe) throws JwtTokenException {
        String jwt = null;
        try {
            jwt = jwe.getCompactSerialization();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.utils.JweHelper", (String)"268", (Object)this, (Object[])new Object[]{jwe});
            throw new JwtTokenException(e.getLocalizedMessage(), (Exception)e);
        }
        return jwt;
    }
}

