/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspShim;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.inputsource.JspInputSourceFactoryImpl;
import com.ibm.ws.jsp.taglib.JspInputSourceFromInputStreamImpl;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.TagLibraryInfoProxy;
import com.ibm.ws.jsp.taglib.TldParser;
import com.ibm.ws.jsp.taglib.config.AvailabilityCondition;
import com.ibm.ws.jsp.taglib.config.AvailabilityConditionType;
import com.ibm.ws.jsp.taglib.config.ImplicitTagLibConfig;
import com.ibm.ws.jsp.taglib.config.TagLibCacheConfigParser;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.JspInputSourceFactory;
import com.ibm.wsspi.jsp.taglib.config.GlobalTagLibConfig;
import com.ibm.wsspi.jsp.taglib.config.TldPathConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagLibraryInfo;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class GlobalTagLibraryCache
extends Hashtable
implements JspCoreContext,
JspClassloaderContext {
    private static final long serialVersionUID = 3257286933104505909L;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.GlobalTagLibraryCache";
    private URL contextURL;
    private String root;
    private JspInputSourceFactory inputSourceFactory;
    private Map implicitTagLibPrefixMap;
    private Map optimizedTagConfigMap;
    private List<String> eventListenerList;
    private List globalTagLibConfigList;
    private ClassLoader loader;
    private JspConfigurationManager configManager;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public GlobalTagLibraryCache() {
        this((ClassLoader)null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public GlobalTagLibraryCache(ClassLoader loader) {
        boolean isAnyTraceEnabled;
        block32: {
            this.contextURL = null;
            this.root = "";
            this.inputSourceFactory = null;
            this.implicitTagLibPrefixMap = new HashMap();
            this.optimizedTagConfigMap = new HashMap();
            this.eventListenerList = new ArrayList<String>();
            this.globalTagLibConfigList = null;
            this.loader = null;
            this.configManager = null;
            isAnyTraceEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTraceEnabled && logger.isLoggable(Level.FINE)) {
                logger.entering(CLASS_NAME, "GlobalTagLibraryCache", " loader: [" + loader + "]");
            }
            this.loader = loader;
            try {
                this.contextURL = JspShim.getGlobalTagLibraryCacheContextURL();
                if (this.contextURL != null) {
                    this.root = this.contextURL.getPath();
                }
            }
            catch (MalformedURLException e) {
                logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "Failed to create context URL for docRoot: " + this.root, e);
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "contextURL: [" + this.contextURL + "]");
            }
            this.inputSourceFactory = new JspInputSourceFactoryImpl(null, this.contextURL, null, false, null, this.getClassLoader());
            TldParser tldParser = null;
            try {
                boolean JCDIEnabledForRuntime = false;
                this.configManager = new JspConfigurationManager(Collections.EMPTY_LIST, false, true, Collections.EMPTY_LIST, false);
                tldParser = new TldParser(this, this.configManager, false);
                TagLibCacheConfigParser tagLibCacheConfigParser = new TagLibCacheConfigParser();
                tagLibCacheConfigParser.parse(this.getClass().getResourceAsStream("/com/ibm/ws/jsp/resources/taglibcacheconfig.xml"));
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "tagLibCacheConfigParser.getImplicitTagLibList(): [" + tagLibCacheConfigParser.getImplicitTagLibList() + "]");
                }
                for (ImplicitTagLibConfig implicitTagLibConfig : tagLibCacheConfigParser.getImplicitTagLibList()) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "implicitTagLibConfig: [" + implicitTagLibConfig + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "implicitTagLibConfig.getUri(): [" + implicitTagLibConfig.getUri() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "contains(implicitTagLibConfig.getUri(): [" + this.contains(implicitTagLibConfig.getUri()) + "]");
                    }
                    if (this.contains(implicitTagLibConfig.getUri())) continue;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "implicitTagLibConfig.getLocation(): [" + implicitTagLibConfig.getLocation() + "]");
                    }
                    JspInputSource inputSource = this.inputSourceFactory.createJspInputSource(implicitTagLibConfig.getLocation());
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "inputSource.getRelativeURL(): [" + inputSource.getRelativeURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "inputSource.getAbsoluteURL(): [" + inputSource.getAbsoluteURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "inputSource.getContextURL(): [" + inputSource.getContextURL() + "]");
                    }
                    try {
                        TagLibraryInfoImpl tli = tldParser.parseTLD(inputSource, "webinf");
                        this.put(implicitTagLibConfig.getUri(), tli);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "putting into implicitTagLibPrefixMap, prefix: [" + implicitTagLibConfig.getPrefix() + "]  uri: [" + implicitTagLibConfig.getUri() + "]");
                        }
                        this.implicitTagLibPrefixMap.put(implicitTagLibConfig.getPrefix(), implicitTagLibConfig.getUri());
                    }
                    catch (JspCoreException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to load tld in jar. uri = [" + inputSource.getAbsoluteURL() + "]", e);
                    }
                }
                this.globalTagLibConfigList = tagLibCacheConfigParser.getGlobalTagLibList();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "globalTagLibConfigList: [" + this.globalTagLibConfigList + "]");
                }
                Iterator itr = this.globalTagLibConfigList.listIterator();
                while (itr.hasNext()) {
                    GlobalTagLibConfig globalTagLibConfig = (GlobalTagLibConfig)itr.next();
                    if (this.loadImplicitTldFromJar(globalTagLibConfig, tldParser)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to find jar [" + globalTagLibConfig.getJarName() + "]. Removing from list of available global tag libraries");
                    }
                    itr.remove();
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", " about to search for META-INF/taglibcacheconfig.xml");
                }
                Enumeration<URL> e = this.getClassLoader().getResources("META-INF/taglibcacheconfig.xml");
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "META-INF/taglibcacheconfig.xml found in {0} ", url.toExternalForm());
                    }
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "about to open:[" + url.toExternalForm() + "]");
                        }
                        InputStream is = url.openStream();
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "about to parse inputstream:[" + is + "]");
                        }
                        tagLibCacheConfigParser.parse(is);
                        List configList = tagLibCacheConfigParser.getGlobalTagLibList();
                        ListIterator itr2 = configList.listIterator();
                        while (itr2.hasNext()) {
                            GlobalTagLibConfig globalTagLibConfig = (GlobalTagLibConfig)itr2.next();
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "globalTagLibConfig: [" + globalTagLibConfig + "]");
                                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "globalTagLibConfig.getTldPathList() [" + globalTagLibConfig.getTldPathList() + "]");
                                for (TldPathConfig tldPathConfig : globalTagLibConfig.getTldPathList()) {
                                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "tldPathConfig.getTldPath() [" + tldPathConfig.getTldPath() + "]");
                                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "tldPathConfig.getUri() [" + tldPathConfig.getUri() + "]");
                                }
                            }
                            if (this.loadImplicitTldFromJar(globalTagLibConfig, tldParser)) continue;
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                                logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to find jar [" + globalTagLibConfig.getJarName() + "]. Removing from list of available global tag libraries");
                            }
                            itr2.remove();
                        }
                        this.globalTagLibConfigList.addAll(configList);
                    }
                    catch (IOException exc) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to load META-INF/taglibcacheconfig.xml in jar. url = [" + url + "]", e);
                    }
                }
            }
            catch (JspCoreException e) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.SEVERE)) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "GlobalTagLibraryCache", "implicittaglibs failed to load ", e);
                }
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.SEVERE)) break block32;
                logger.logp(Level.SEVERE, CLASS_NAME, "GlobalTagLibraryCache", "implicittaglibs failed to load ", e);
            }
        }
        if (isAnyTraceEnabled && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "GlobalTagLibraryCache", "loader: [" + loader + "]");
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean loadImplicitTldFromJar(GlobalTagLibConfig globalTagLibConfig, TldParser tldParser) {
        boolean isAnyTraceEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTraceEnabled && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "loadImplicitTldFromJar", "globalTagLibConfig.getJarName(): [" + globalTagLibConfig.getJarName() + "]");
        }
        boolean jarFound = false;
        URL jarUrl = this.getClassLoader().getResource(globalTagLibConfig.getJarName());
        if (jarUrl != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "jarUrl: [" + jarUrl.toExternalForm() + "]");
            }
            jarFound = true;
            for (TldPathConfig tldPathConfig : globalTagLibConfig.getTldPathList()) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldPathConfig.getUri(): [" + tldPathConfig.getUri() + "]");
                }
                if (tldPathConfig.getUri() != null) {
                    TagLibraryInfoProxy proxy = new TagLibraryInfoProxy(globalTagLibConfig.getJarName(), tldPathConfig.getTldPath(), tldPathConfig.containsListenerDefs(), this);
                    this.put(tldPathConfig.getUri(), proxy);
                    continue;
                }
                JspInputSource tldInputSource = null;
                try {
                    TagLibraryInfoImpl tli;
                    URL url = new URL("jar:" + jarUrl.toString() + "!/");
                    tldInputSource = this.inputSourceFactory.createJspInputSource(url, tldPathConfig.getTldPath());
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldInputSource.getRelativeURL(): [" + tldInputSource.getRelativeURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldInputSource.getAbsoluteURL(): [" + tldInputSource.getAbsoluteURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldInputSource.getContextURL(): [" + tldInputSource.getContextURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "url: [" + url + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldPathConfig.getTldPath(): [" + tldPathConfig.getTldPath() + "]");
                    }
                    if ((tli = tldParser.parseTLD(tldInputSource, globalTagLibConfig.getJarName())).getReliableURN() != null) {
                        if (this.containsKey(tli.getReliableURN())) continue;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "Global jar tld loaded for {0}", tli.getReliableURN());
                        }
                        tli.setURI(tli.getReliableURN());
                        this.put(tli.getReliableURN(), tli);
                        tldPathConfig.setUri(tli.getReliableURN());
                        this.eventListenerList.addAll(tldParser.getEventListenerList());
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadImplicitTldFromJar", "jsp warning failed to find a uri tag in [" + tldInputSource.getAbsoluteURL() + "]");
                }
                catch (JspCoreException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadImplicitTldFromJar", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                }
                catch (IOException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadImplicitTldFromJar", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                }
            }
        }
        if (isAnyTraceEnabled && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "loadImplicitTldFromJar", jarFound);
        }
        return jarFound;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspClassloaderContext getJspClassloaderContext() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspClassloaderContext", new Object[0]);
        }
        GlobalTagLibraryCache globalTagLibraryCache = this;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            globalTagLibraryCache = globalTagLibraryCache;
            logger.exiting(CLASS_NAME, "getJspClassloaderContext", globalTagLibraryCache);
        }
        return globalTagLibraryCache;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspInputSourceFactory getJspInputSourceFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspInputSourceFactory", new Object[0]);
        }
        JspInputSourceFactory jspInputSourceFactory = this.inputSourceFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspInputSourceFactory = jspInputSourceFactory;
            logger.exiting(CLASS_NAME, "getJspInputSourceFactory", jspInputSourceFactory);
        }
        return jspInputSourceFactory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getRealTimeStamp(String path) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRealTimeStamp", new Object[]{path});
        }
        JspInputSource inputSource = this.getJspInputSourceFactory().createJspInputSource(path);
        long l = inputSource.getLastModified();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting(CLASS_NAME, "getRealTimeStamp", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRealPath(String path) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRealPath", new Object[]{path});
        }
        String realPath = "";
        realPath = path.startsWith("/") ? this.root + path : this.root + "/" + path;
        String string = realPath;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getRealPath", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set getResourcePaths(String path, boolean searchMetsInfResources) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResourcePaths", new Object[]{path, searchMetsInfResources});
        }
        Set set = this.getResourcePaths(path);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting(CLASS_NAME, "getResourcePaths", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set getResourcePaths(String paths) {
        File[] fileList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResourcePaths", new Object[]{paths});
        }
        HashSet<String> set = new HashSet<String>();
        File rootPath = new File(this.root + paths);
        if (rootPath.exists() && (fileList = rootPath.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                String resourcePath = fileList[i].getPath();
                resourcePath = resourcePath.substring(this.root.length());
                resourcePath = resourcePath.replace('\\', '/');
                if (fileList[i].isDirectory() && !resourcePath.endsWith("/")) {
                    resourcePath = resourcePath + "/";
                }
                set.add(resourcePath);
            }
        }
        HashSet<String> hashSet = set;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            logger.exiting(CLASS_NAME, "getResourcePaths", hashSet);
        }
        return hashSet;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassLoader getClassLoader() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getClassLoader", new Object[0]);
        }
        if (this.loader != null) {
            ClassLoader classLoader = this.loader;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                classLoader = classLoader;
                logger.exiting(CLASS_NAME, "getClassLoader", classLoader);
            }
            return classLoader;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classLoader = classLoader;
            logger.exiting(CLASS_NAME, "getClassLoader", classLoader);
        }
        return classLoader;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getClassPath() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getClassPath", new Object[0]);
        }
        String string = "";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getClassPath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map getImplicitTagLibPrefixMap() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getImplicitTagLibPrefixMap", new Object[0]);
        }
        Map map = this.implicitTagLibPrefixMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting(CLASS_NAME, "getImplicitTagLibPrefixMap", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map getOptimizedTagConfigMap() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getOptimizedTagConfigMap", new Object[0]);
        }
        Map map = this.optimizedTagConfigMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting(CLASS_NAME, "getOptimizedTagConfigMap", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getEventListenerList() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getEventListenerList", new Object[0]);
        }
        List<String> list = this.eventListenerList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting(CLASS_NAME, "getEventListenerList", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map getGlobalTagLibMapForWebApp(JspCoreContext ctxt, JspXmlExtConfig jspConfig) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getGlobalTagLibMapForWebApp", new Object[]{ctxt, jspConfig});
        }
        Map map = this.getGlobalTagLibMapForWebApp(null, ctxt, jspConfig);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting(CLASS_NAME, "getGlobalTagLibMapForWebApp", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map getGlobalTagLibMapForWebApp(Container container, JspXmlExtConfig jspConfig) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getGlobalTagLibMapForWebApp", new Object[]{container, jspConfig});
        }
        Map map = this.getGlobalTagLibMapForWebApp(container, null, jspConfig);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting(CLASS_NAME, "getGlobalTagLibMapForWebApp", map);
        }
        return map;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map getGlobalTagLibMapForWebApp(Container container, JspCoreContext ctxt, JspXmlExtConfig jspConfig) {
        boolean isAnyTraceEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTraceEnabled && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getGlobalTagLibMapForWebApp", "context: []  jspConfig: [" + jspConfig + "]");
        }
        HashMap<String, Object> globalTabLibMap = new HashMap<String, Object>();
        for (String uri : this.implicitTagLibPrefixMap.values()) {
            TagLibraryInfo tli = (TagLibraryInfo)this.get(uri);
            globalTabLibMap.put(uri, tli);
        }
        for (GlobalTagLibConfig globalTagLibConfig : this.globalTagLibConfigList) {
            Iterator itr2 = globalTagLibConfig.getTldPathList().iterator();
            while (itr2.hasNext()) {
                boolean tldAvailable = false;
                TldPathConfig tldPathConfig = (TldPathConfig)itr2.next();
                if (tldPathConfig.getAvailabilityConditionList().size() > 0) {
                    for (AvailabilityCondition availabilityCondition : tldPathConfig.getAvailabilityConditionList()) {
                        if (availabilityCondition.getType().equals(AvailabilityConditionType.webinfFileType)) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "WEB-INF File Availability Condition found for {0}", availabilityCondition.getValue());
                            }
                            if ((container == null || null == container.getEntry(availabilityCondition.getValue())) && (ctxt == null || !new File(ctxt.getRealPath(availabilityCondition.getValue())).exists())) continue;
                            tldAvailable = true;
                        } else {
                            if (!availabilityCondition.getType().equals(AvailabilityConditionType.servletClassNameType)) continue;
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "Servlet Class Name Availability Condition found for {0}", availabilityCondition.getValue());
                            }
                            if (!jspConfig.containsServletClassName(availabilityCondition.getValue())) continue;
                            tldAvailable = true;
                        }
                        break;
                    }
                } else {
                    tldAvailable = true;
                }
                if (!tldAvailable) continue;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "global tld {0} is available", tldPathConfig.getUri());
                }
                globalTabLibMap.put(tldPathConfig.getUri(), this.get(tldPathConfig.getUri()));
            }
        }
        if (isAnyTraceEnabled && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getGlobalTagLibMapForWebApp");
        }
        return globalTabLibMap;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getOptimizedClassPath() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getOptimizedClassPath", new Object[0]);
        }
        String string = this.getClassPath();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getOptimizedClassPath", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isPredefineClassEnabled() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPredefineClassEnabled", new Object[0]);
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isPredefineClassEnabled", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public byte[] predefineClass(String className, byte[] classData) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "predefineClass", new Object[]{className, classData});
        }
        byte[] byArray = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            byArray = byArray;
            logger.exiting(CLASS_NAME, "predefineClass", byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void loadTldFromJarInputStream(GlobalTagLibConfig globalTagLibConfig, TldParser tldParser) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "loadTldFromJarInputStream", new Object[]{globalTagLibConfig, tldParser});
        }
        HashMap<String, TldPathConfig> entryMap = new HashMap<String, TldPathConfig>();
        for (TldPathConfig tldPathConfig : globalTagLibConfig.getTldPathList()) {
            entryMap.put(tldPathConfig.getTldPath(), tldPathConfig);
        }
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(globalTagLibConfig.getJarURL().openStream());
            JarEntry je = null;
            byte[] buf = new byte[1024];
            while ((je = jis.getNextJarEntry()) != null) {
                TldPathConfig tldPathConfig = (TldPathConfig)entryMap.get(je.getName());
                if (tldPathConfig == null) continue;
                JspInputSource tldInputSource = null;
                try {
                    TagLibraryInfoImpl tli;
                    int read;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((read = jis.read(buf)) != -1) {
                        baos.write(buf, 0, read);
                    }
                    tldInputSource = this.inputSourceFactory.createJspInputSource(globalTagLibConfig.getJarURL(), tldPathConfig.getTldPath());
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldInputSource.getRelativeURL(): [" + tldInputSource.getRelativeURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldInputSource.getAbsoluteURL(): [" + tldInputSource.getAbsoluteURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldInputSource.getContextURL(): [" + tldInputSource.getContextURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "globalTagLibConfig.getJarURL(): [" + globalTagLibConfig.getJarURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldPathConfig.getTldPath(): [" + tldPathConfig.getTldPath() + "]");
                    }
                    if ((tli = tldParser.parseTLD(tldInputSource, new ByteArrayInputStream(baos.toByteArray()), globalTagLibConfig.getJarURL().toExternalForm())).getReliableURN() != null) {
                        if (this.containsKey(tli.getReliableURN())) continue;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "Global jar tld loaded for {0}", tli.getReliableURN());
                        }
                        tli.setURI(tli.getReliableURN());
                        this.put(tli.getReliableURN(), tli);
                        tldPathConfig.setUri(tli.getReliableURN());
                        this.eventListenerList.addAll(tldParser.getEventListenerList());
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromJarInputStream", "jsp warning failed to find a uri tag in [" + tldInputSource.getAbsoluteURL() + "]");
                }
                catch (JspCoreException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromJarInputStream", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                }
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromJarInputStream", "jsp warning failed to load jar. url = [" + globalTagLibConfig.getJarURL() + "]", ioe);
            }
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "loadTldFromJarInputStream");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void loadTldFromClassloader(GlobalTagLibConfig globalTagLibConfig, TldParser tldParser) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "loadTldFromClassloader", new Object[]{globalTagLibConfig, tldParser});
        }
        for (TldPathConfig tldPathConfig : globalTagLibConfig.getTldPathList()) {
            InputStream is = globalTagLibConfig.getClassloader().getResourceAsStream(tldPathConfig.getTldPath());
            JspInputSourceFromInputStreamImpl tldInputSource = new JspInputSourceFromInputStreamImpl(is);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "loadTldFromClassloader", "tldInputSource.getRelativeURL(): [" + tldInputSource.getRelativeURL() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "loadTldFromClassloader", "tldInputSource.getAbsoluteURL(): [" + tldInputSource.getAbsoluteURL() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "loadTldFromClassloader", "tldInputSource.getContextURL(): [" + tldInputSource.getContextURL() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "loadTldFromClassloader", "globalTagLibConfig.getJarURL(): [" + globalTagLibConfig.getJarURL() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "loadTldFromClassloader", "tldPathConfig.getTldPath(): [" + tldPathConfig.getTldPath() + "]");
            }
            try {
                TagLibraryInfoImpl tli = tldParser.parseTLD(tldInputSource, is, globalTagLibConfig.getJarURL().toExternalForm());
                if (tli.getReliableURN() != null) {
                    if (this.containsKey(tli.getReliableURN())) continue;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromClassloader", "Global jar tld loaded for {0}", tli.getReliableURN());
                    }
                    tli.setURI(tli.getReliableURN());
                    this.put(tli.getReliableURN(), tli);
                    tldPathConfig.setUri(tli.getReliableURN());
                    this.eventListenerList.addAll(tldParser.getEventListenerList());
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromClassloader", "jsp warning failed to find a uri tag in [" + tldInputSource.getAbsoluteURL() + "]");
            }
            catch (JspCoreException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromClassloader", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "loadTldFromClassloader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addGlobalTagLibConfig(GlobalTagLibConfig globalTagLibConfig) {
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "addGlobalTagLibConfig", new Object[]{globalTagLibConfig});
            }
            try {
                TldParser tldParser = new TldParser(this, this.configManager, false, globalTagLibConfig.getClassloader());
                if (globalTagLibConfig.getClassloader() == null) {
                    this.loadTldFromJarInputStream(globalTagLibConfig, tldParser);
                } else {
                    this.loadTldFromClassloader(globalTagLibConfig, tldParser);
                }
                this.globalTagLibConfigList.add(globalTagLibConfig);
            }
            catch (JspCoreException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.SEVERE)) break block6;
                logger.logp(Level.SEVERE, CLASS_NAME, "addGlobalTagLibConfig", "failed to create TldParser ", e);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "addGlobalTagLibConfig");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IServletContext getServletContext() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getServletContext", new Object[0]);
        }
        IServletContext iServletContext = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iServletContext = iServletContext;
            logger.exiting(CLASS_NAME, "getServletContext", iServletContext);
        }
        return iServletContext;
    }
}

