/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inputsource;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.inputsource.JspURLConnection;
import com.ibm.ws.webcontainer.util.DocumentRootUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspURLStreamHandler
extends URLStreamHandler {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.inputsource.JspUrlStreamHandler";
    private String relativeUrl;
    private DocumentRootUtils dru;
    private boolean searchOnClasspath;
    private ClassLoader classloader;
    private String docRoot;
    private ServletContext servletContext;
    private static Map ENCODED_CHARACTER_MAP = new HashMap();
    private static Pattern CHARS_REQUIRING_ENCODING = null;
    static final long serialVersionUID = -235073866056225267L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspURLStreamHandler(String docRoot, String relativeUrl, DocumentRootUtils dru, boolean searchOnClasspath, ClassLoader classloader, ServletContext servletContext) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspURLStreamHandler", "<init>", new Object[]{docRoot, relativeUrl, dru, searchOnClasspath, classloader, servletContext});
        }
        this.relativeUrl = null;
        this.dru = null;
        this.searchOnClasspath = false;
        this.classloader = null;
        this.docRoot = docRoot;
        this.relativeUrl = relativeUrl;
        this.dru = dru;
        this.searchOnClasspath = searchOnClasspath;
        this.classloader = classloader;
        this.servletContext = servletContext;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.inputsource.JspURLStreamHandler", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected URLConnection openConnection(URL url) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspURLStreamHandler", "openConnection", new Object[]{url});
        }
        JspURLConnection jspURLConnection = new JspURLConnection(this.docRoot, url, this.relativeUrl, this.dru, this.searchOnClasspath, this.classloader, this.servletContext);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspURLConnection = jspURLConnection;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspURLStreamHandler", "openConnection", jspURLConnection);
        }
        return jspURLConnection;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void parseURL(URL u, String spec, int start, int limit) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspURLStreamHandler", "parseURL", new Object[]{u, spec, start, limit});
        }
        String encodedChars = JspURLStreamHandler.replaceEncodedChars(spec);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST) && !spec.equals(encodedChars)) {
            logger.logp(Level.FINEST, CLASS_NAME, "parseURL", "parseURL spec [" + spec + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "parseURL", "parseURL spec encoded [" + encodedChars + "]");
        }
        int length = encodedChars.length();
        super.parseURL(u, encodedChars, start, start + length);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.inputsource.JspURLStreamHandler", "parseURL");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String replaceEncodedChars(String replaceString) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.inputsource.JspURLStreamHandler", "replaceEncodedChars", new Object[]{replaceString});
        }
        Matcher m = CHARS_REQUIRING_ENCODING.matcher(replaceString);
        StringBuffer sb = new StringBuffer();
        boolean matchFound = false;
        while (m.find()) {
            matchFound = true;
            m.appendReplacement(sb, (String)ENCODED_CHARACTER_MAP.get(m.group()));
        }
        if (matchFound) {
            sb = m.appendTail(sb);
            String string = sb.toString();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.jsp.inputsource.JspURLStreamHandler", "replaceEncodedChars", string);
            }
            return string;
        }
        String string = replaceString;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jsp.inputsource.JspURLStreamHandler", "replaceEncodedChars", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        StringBuffer tmpBuffer = new StringBuffer();
        String reservedCharacterString = "!\"#$%&'()*+,:;<=>?@[]^`{|}~";
        char[] reservedCharacters = reservedCharacterString.toCharArray();
        for (int i = 0; i < reservedCharacters.length; ++i) {
            String reservedChar = String.valueOf(reservedCharacters[i]);
            tmpBuffer.append("(\\" + reservedChar + ")");
            if (i != reservedCharacters.length - 1) {
                tmpBuffer.append("|");
            }
            try {
                String encoded = URLEncoder.encode(reservedChar, "UTF-8");
                ENCODED_CHARACTER_MAP.put(reservedChar, encoded);
                continue;
            }
            catch (Exception e) {
                logger.logp(Level.FINER, CLASS_NAME, "staticInit", "failed\tto add encoding " + reservedChar, e);
            }
        }
        CHARS_REQUIRING_ENCODING = Pattern.compile(tmpBuffer.toString());
    }
}

