/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.internal.util.Factory;
import com.ibm.ws.classloading.internal.util.Keyed;
import com.ibm.ws.classloading.internal.util.KeyedRef;
import com.ibm.ws.classloading.internal.util.Ref;
import com.ibm.ws.classloading.internal.util.RefQueue;
import com.ibm.ws.classloading.internal.util.WeakKeyedRef;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CanonicalStore<K, V extends Keyed<K>> {
    final ConcurrentMap<K, Ref<V>> map = new ConcurrentHashMap<K, Ref<V>>();
    final RefQueue<V, ? extends KeyedRef<K, V>> q = new RefQueue();
    static final long serialVersionUID = 6715157558227169968L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void store(K key, V loader) {
        this.cleanUpStaleEntries();
        this.map.put(key, new WeakKeyedRef<K, V>(key, loader, this.q));
    }

    public V retrieve(K key) {
        Ref ref = (Ref)this.map.get(key);
        return (V)(ref == null ? null : (Keyed)ref.get());
    }

    public boolean remove(V value) {
        Object key = value.getKey();
        Ref ref = (Ref)this.map.get(key);
        return ref != null && ref.get() == value ? this.map.remove(key, ref) : false;
    }

    public V retrieveOrCreate(K key, Factory<V> factory) {
        this.cleanUpStaleEntries();
        return this.retrieveOrCreate(key, factory, new FutureRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V retrieveOrCreate(K key, Factory<V> factory, FutureRef<V> futureRef) {
        Keyed<Object> value;
        Ref canonicalRef = this.map.putIfAbsent(key, futureRef);
        if (canonicalRef == null) {
            try {
                value = (Keyed)factory.createInstance();
                futureRef.result = value;
            }
            finally {
                futureRef.latch.countDown();
            }
            WeakKeyedRef<K, Keyed> weakRef = new WeakKeyedRef<K, Keyed>(key, value, this.q);
            this.map.replace(key, futureRef, weakRef);
        } else {
            value = (Keyed)canonicalRef.get();
            if (value == null) {
                this.map.remove(key, canonicalRef);
                value = this.retrieveOrCreate(key, factory, futureRef);
            }
        }
        return (V)value;
    }

    void cleanUpStaleEntries() {
        KeyedRef<K, V> ref = this.q.poll();
        while (ref != null) {
            this.map.remove(ref.getKey(), ref);
            ref = this.q.poll();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.util.CanonicalStore", CanonicalStore.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class FutureRef<V>
    implements Ref<V> {
        final CountDownLatch latch = new CountDownLatch(1);
        V result;
        static final long serialVersionUID = -8246465641203515474L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private FutureRef() {
        }

        @Override
        public V get() {
            while (true) {
                try {
                    this.latch.await();
                    return this.result;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.classloading.internal.util.CanonicalStore$FutureRef", (String)"124", (Object)this, (Object[])new Object[0]);
                    continue;
                }
                break;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.util.CanonicalStore$FutureRef", FutureRef.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }
}

