/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import io.openliberty.microprofile.openapi20.utils.CloudUtils;
import io.openliberty.microprofile.openapi20.utils.LoggingUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIUIBundlesUpdater {
    private static final TraceComponent tc = Tr.register(OpenAPIUIBundlesUpdater.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final Set<String> openAPIUIBundleNames = new HashSet<String>(Arrays.asList("com.ibm.ws.microprofile.openapi.ui"));
    private static boolean stopping = false;
    static final long serialVersionUID = -720879739245304059L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void updateResources(Map<String, Object> resourcesToUpdate, boolean isRestoreDefaults) throws IOException, BundleException {
        if (resourcesToUpdate == null || resourcesToUpdate.isEmpty()) {
            return;
        }
        Set<Bundle> allOpenAPIUIBundles = OpenAPIUIBundlesUpdater.getOpenAPIUIBundles();
        boolean result = OpenAPIUIBundlesUpdater.waitForBundlesToStart(allOpenAPIUIBundles);
        if (!result) {
            return;
        }
        Iterator<Bundle> itr = allOpenAPIUIBundles.iterator();
        InputStream updatedBundleStream = null;
        while (itr.hasNext()) {
            Bundle openAPIUIBundle = itr.next();
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("About to process bundle : " + OpenAPIUIBundlesUpdater.getBundleDescription(openAPIUIBundle)), (Object[])new Object[0]);
            }
            if (isRestoreDefaults) {
                String customHeader = OpenAPIUIBundlesUpdater.getResource(openAPIUIBundle, "css/custom-header.css");
                String defaultHeader = OpenAPIUIBundlesUpdater.getResource(openAPIUIBundle, "css/default-header.css");
                if (defaultHeader != null && defaultHeader.equals(customHeader)) {
                    if (!LoggingUtils.isEventEnabled(tc)) continue;
                    Tr.event((TraceComponent)tc, (String)("Not updating the bundle as it is already in default state : " + OpenAPIUIBundlesUpdater.getBundleDescription(openAPIUIBundle)), (Object[])new Object[0]);
                    continue;
                }
            }
            try {
                updatedBundleStream = OpenAPIUIBundlesUpdater.getUpdatedBundleStream(openAPIUIBundle, resourcesToUpdate);
                if (updatedBundleStream == null) continue;
                openAPIUIBundle.update(updatedBundleStream);
                if (!LoggingUtils.isEventEnabled(tc)) continue;
                Tr.event((TraceComponent)tc, (String)("Updated bundle : " + OpenAPIUIBundlesUpdater.getBundleDescription(openAPIUIBundle)), (Object[])new Object[0]);
            }
            finally {
                FileUtils.tryToClose((Closeable)updatedBundleStream);
                if (openAPIUIBundle.getState() == 32 || openAPIUIBundle.getState() == 8) continue;
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Bundle is not active: " + OpenAPIUIBundlesUpdater.getBundleDescription(openAPIUIBundle)), (Object[])new Object[0]);
                }
                openAPIUIBundle.start();
            }
        }
    }

    private static boolean verifyRefs(ServiceReference<Bundle>[] refs, Set<String> expectedBundles) {
        if (refs == null) {
            return false;
        }
        int foundBundles = 0;
        for (ServiceReference<Bundle> ref : refs) {
            String bundleKey = (String)ref.getProperty("web.module.key");
            String bundleName = bundleKey.substring(0, bundleKey.indexOf(35));
            if (!expectedBundles.contains(bundleName)) continue;
            ++foundBundles;
        }
        return foundBundles == expectedBundles.size();
    }

    private static Set<Bundle> getOpenAPIUIBundles() {
        HashSet<Bundle> openAPIUIBundles = new HashSet<Bundle>();
        BundleContext bundleContext = FrameworkUtil.getBundle(OpenAPIUIBundlesUpdater.class).getBundleContext();
        if (bundleContext != null) {
            for (Bundle aBundle : bundleContext.getBundles()) {
                String bundleName = aBundle.getSymbolicName();
                if (!openAPIUIBundleNames.contains(bundleName)) continue;
                openAPIUIBundles.add(aBundle);
                if (!LoggingUtils.isEventEnabled(tc)) continue;
                Tr.event((TraceComponent)tc, (String)("Found a OpenAPI-UI bundle: " + bundleName), (Object[])new Object[0]);
            }
        }
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Found " + openAPIUIBundles.size() + " OpenAPI-UI bundles in bundleContext=" + bundleContext), (Object[])new Object[0]);
        }
        return openAPIUIBundles;
    }

    @Trivial
    private static String getBundleDescription(Bundle bundle) {
        return bundle == null ? "NULL" : "Bundle Name=" + bundle.getSymbolicName() + " : ID=" + bundle.getBundleId() + " : State=" + bundle.getState();
    }

    private static InputStream getUpdatedBundleStream(Bundle bundle, Map<String, Object> resourcesToUpdate) throws IOException {
        if (bundle == null || resourcesToUpdate == null || resourcesToUpdate.isEmpty()) {
            return null;
        }
        Set<String> resourceKeys = resourcesToUpdate.keySet();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(bytesOut);
        int totalEntries = 0;
        int nonDirEntries = 0;
        Enumeration enumer = bundle.findEntries("/", "*", true);
        while (enumer.hasMoreElements()) {
            URL aURL = (URL)enumer.nextElement();
            String path = aURL.getPath();
            if (path.startsWith("/") && !path.equals("/")) {
                path = path.substring(1);
            }
            if (!resourceKeys.contains(path)) {
                ++totalEntries;
                ZipEntry anEntry = new ZipEntry(path);
                zipOut.putNextEntry(anEntry);
                if (!anEntry.isDirectory()) {
                    ++nonDirEntries;
                    OpenAPIUIBundlesUpdater.writeStreamToZip(aURL.openStream(), zipOut);
                }
                zipOut.closeEntry();
                continue;
            }
            if (!LoggingUtils.isDumpEnabled(tc)) continue;
            Tr.dump((TraceComponent)tc, (String)("Not processing resource as it'll be overwritten later : " + path), (Object[])new Object[0]);
        }
        for (String path : resourceKeys) {
            ++totalEntries;
            ZipEntry entry = new ZipEntry(path);
            zipOut.putNextEntry(entry);
            if (!entry.isDirectory()) {
                Object resourceValue;
                ++nonDirEntries;
                if (path.equals("css/custom-header.css") && (resourceValue = resourcesToUpdate.get(path)) instanceof String && ((String)resourceValue).equals("css/default-header.css")) {
                    String contents = OpenAPIUIBundlesUpdater.getResource(bundle, "css/default-header.css");
                    resourcesToUpdate.put(path, contents);
                }
                OpenAPIUIBundlesUpdater.processResource(path, resourcesToUpdate.get(path), zipOut);
            }
            zipOut.closeEntry();
        }
        if (LoggingUtils.isDebugEnabled(tc)) {
            Tr.debug((TraceComponent)tc, (String)("Zip total Entries = " + totalEntries + " : Non-dir entries " + nonDirEntries), (Object[])new Object[0]);
        }
        zipOut.close();
        bytesOut.close();
        return new ByteArrayInputStream(bytesOut.toByteArray());
    }

    private static void processResource(String resourcePath, Object resourceContents, ZipOutputStream zos) throws UnsupportedEncodingException, IOException {
        if (resourceContents != null) {
            if (resourceContents instanceof String) {
                zos.write(((String)resourceContents).getBytes(StandardCharsets.UTF_8.name()));
                if (LoggingUtils.isDebugEnabled(tc)) {
                    Tr.debug((TraceComponent)tc, (String)("Processed (String) resource at " + resourcePath), (Object[])new Object[0]);
                }
                return;
            }
            if (resourceContents instanceof File) {
                File aFile = (File)resourceContents;
                if (FileUtils.fileExists((File)aFile) && FileUtils.fileIsFile((File)aFile)) {
                    OpenAPIUIBundlesUpdater.writeStreamToZip(FileUtils.getInputStream((File)aFile), zos);
                    if (LoggingUtils.isDebugEnabled(tc)) {
                        Tr.debug((TraceComponent)tc, (String)("Processed (File) resource at " + resourcePath), (Object[])new Object[0]);
                    }
                    return;
                }
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("File is not valid : " + aFile.getAbsolutePath()), (Object[])new Object[0]);
                }
            } else if (resourceContents instanceof URL) {
                OpenAPIUIBundlesUpdater.writeStreamToZip(CloudUtils.getUrlAsStream((URL)resourceContents, null), zos);
                if (LoggingUtils.isDebugEnabled(tc)) {
                    Tr.debug((TraceComponent)tc, (String)("Processed (URL) resource at " + resourcePath), (Object[])new Object[0]);
                }
                return;
            }
        }
        if (LoggingUtils.isDebugEnabled(tc)) {
            if (tc.isDumpEnabled()) {
                Tr.dump((TraceComponent)tc, (String)("Resource not processed  : resourcePath=" + resourcePath + " : resourceContents=" + resourceContents), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("Resource not processed  : resourcePath=" + resourcePath), (Object[])new Object[0]);
            }
        }
    }

    private static String getResource(Bundle myBundle, String resourcePath) {
        if (myBundle == null) {
            return null;
        }
        String bundleShortDescription = OpenAPIUIBundlesUpdater.getBundleDescription(myBundle);
        StringBuilder responseString = new StringBuilder();
        URL bundleResource = myBundle.getResource(resourcePath);
        if (bundleResource != null) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(bundleResource.openConnection().getInputStream(), StandardCharsets.UTF_8.name()));
                while (br.ready()) {
                    responseString.append(br.readLine());
                }
                br.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.openapi20.css.OpenAPIUIBundlesUpdater", (String)"282", null, (Object[])new Object[]{myBundle, resourcePath});
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Exception trying to read resource at " + resourcePath + " from bundle " + bundleShortDescription), (Object[])new Object[0]);
                }
            }
        } else if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)"Unexpected error getting resource from WAB bundle.", (Object[])new Object[0]);
        }
        return responseString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private static void writeStreamToZip(InputStream stream, ZipOutputStream zos) throws IOException {
        if (stream == null || zos == null) {
            return;
        }
        try {
            int length;
            byte[] buf = new byte[8192];
            while ((length = stream.read(buf)) != -1) {
                zos.write(buf, 0, length);
            }
        }
        finally {
            FileUtils.tryToClose((Closeable)stream);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean waitForBundlesToStart(Set<Bundle> openAPIUIBundles) {
        boolean waitComplete;
        block6: {
            waitComplete = false;
            HashSet<String> expectedBundleNames = new HashSet<String>();
            for (Bundle bundle : openAPIUIBundles) {
                expectedBundleNames.add(bundle.getSymbolicName());
            }
            try {
                BundleContext bundleContext = FrameworkUtil.getBundle(OpenAPIUIBundlesUpdater.class).getBundleContext();
                ServiceReference[] refs = bundleContext.getServiceReferences(Bundle.class.getName(), "(installed.wab.contextRoot=*)");
                waitComplete = OpenAPIUIBundlesUpdater.verifyRefs(refs, expectedBundleNames);
                while (!waitComplete) {
                    if (stopping) {
                        if (LoggingUtils.isDebugEnabled(tc)) {
                            Tr.debug((TraceComponent)tc, (String)"Stopped waiting for OpenAPI bundles because the server is shutting down", (Object[])new Object[0]);
                        }
                        return false;
                    }
                    refs = bundleContext.getServiceReferences(Bundle.class.getName(), "(installed.wab.contextRoot=*)");
                    waitComplete = OpenAPIUIBundlesUpdater.verifyRefs(refs, expectedBundleNames);
                    if (waitComplete) continue;
                    Thread.sleep(500L);
                }
            }
            catch (Exception bundleContext) {
                void e;
                FFDCFilter.processException((Throwable)bundleContext, (String)"io.openliberty.microprofile.openapi20.css.OpenAPIUIBundlesUpdater", (String)"339", null, (Object[])new Object[]{openAPIUIBundles});
                waitComplete = false;
                if (!LoggingUtils.isEventEnabled(tc)) break block6;
                Tr.event((TraceComponent)tc, (String)"Failed waiting for OpenAPI bundles before update failed with :", (Object[])new Object[]{e.getMessage()});
            }
        }
        return waitComplete;
    }

    public static void serverStopping() {
        stopping = true;
    }
}

