/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.OpenAPIProvider;
import io.openliberty.microprofile.openapi20.utils.OpenAPIUtils;
import io.smallrye.openapi.runtime.io.Format;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.servers.Server;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebModuleOpenAPIProvider
implements OpenAPIProvider {
    private final WebModuleInfo webModuleInfo;
    private final OpenAPI openAPIModel;
    private boolean serversDefined = false;
    private Map<Format, String> openAPIDocuments = new HashMap<Format, String>();
    static final long serialVersionUID = -7343696574960210296L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebModuleOpenAPIProvider(WebModuleInfo webModuleInfo, OpenAPI openAPIModel, boolean serversDefined) {
        this.webModuleInfo = webModuleInfo;
        this.openAPIModel = openAPIModel;
        this.serversDefined = serversDefined;
        if (this.serversDefined) {
            this.openAPIDocuments.put(Format.YAML, OpenAPIUtils.getOpenAPIDocument(openAPIModel, Format.YAML));
            this.openAPIDocuments.put(Format.JSON, OpenAPIUtils.getOpenAPIDocument(openAPIModel, Format.JSON));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOpenAPIDocument(Format format) {
        String document = null;
        if (this.openAPIModel != null) {
            if (this.serversDefined) {
                document = this.openAPIDocuments.get(format);
            } else {
                OpenAPI openAPI = this.openAPIModel;
                synchronized (openAPI) {
                    document = OpenAPIUtils.getOpenAPIDocument(this.openAPIModel, format);
                }
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOpenAPIDocument(List<Server> servers, Format format) {
        String document = null;
        if (servers != null && !servers.isEmpty()) {
            OpenAPI openAPI = this.openAPIModel;
            synchronized (openAPI) {
                this.openAPIModel.setServers(servers);
                document = OpenAPIUtils.getOpenAPIDocument(this.openAPIModel, format);
                this.openAPIModel.setServers(null);
            }
        }
        return document;
    }

    @Override
    public String getContextRoot() {
        return this.webModuleInfo.getContextRoot();
    }

    @Override
    public String getApplicationPath() {
        String applicationPath = null;
        String contextRoot = this.webModuleInfo.getContextRoot();
        Paths paths = this.openAPIModel.getPaths();
        if (paths == null || paths.getPathItems() == null || paths.getPathItems().isEmpty() || !((String)paths.getPathItems().keySet().iterator().next()).startsWith(contextRoot)) {
            applicationPath = contextRoot;
        }
        return applicationPath;
    }

    @Override
    public boolean getServersDefined() {
        return this.serversDefined;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.WebModuleOpenAPIProvider", WebModuleOpenAPIProvider.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

