/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal.chains;

import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.endpoint.EndPointInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.StandardEmitterMBean;

public class EndPointInfoImpl
extends StandardEmitterMBean
implements EndPointInfo {
    private static final TraceComponent tc = Tr.register(EndPointInfoImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private final String name;
    private String host;
    private int port;
    private final AtomicLong sequenceNum = new AtomicLong();

    private void validateHostName(String host) {
        if (null == host || host.isEmpty()) {
            throw new IllegalArgumentException("Invalid host: " + host);
        }
    }

    EndPointInfoImpl(String name, String host, int port) throws NotCompliantMBeanException {
        super(EndPointInfoMBean.class, true, (NotificationEmitter)new NotificationBroadcasterSupport((Executor)null, new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "")));
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        this.validateHostName(host);
        this.name = name;
        this.host = host;
        this.port = port;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created: " + this), (Object[])new Object[0]);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public String updateHost(String newHost) {
        this.validateHostName(newHost);
        String oldHost = this.host;
        this.host = newHost;
        if (!oldHost.equals(newHost)) {
            this.sendNotification(new AttributeChangeNotification(this, this.sequenceNum.incrementAndGet(), System.currentTimeMillis(), this.toString() + " host value changed", "Host", "java.lang.String", oldHost, newHost));
        }
        return oldHost;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public int updatePort(int newPort) {
        int oldPort = this.port;
        this.port = newPort;
        if (oldPort != newPort) {
            this.sendNotification(new AttributeChangeNotification(this, this.sequenceNum.incrementAndGet(), System.currentTimeMillis(), this.toString() + " port value changed", "Port", "java.lang.Integer", oldPort, newPort));
        }
        return oldPort;
    }

    @Override
    protected final String getDescription(MBeanInfo info) {
        return "Informational MBean representing an active endpoint.";
    }

    @Override
    protected final String getDescription(MBeanAttributeInfo info) {
        String operationName;
        String description = "Unknown attribute";
        if (info != null && (operationName = info.getName()) != null) {
            if (operationName.equals("Name")) {
                description = "Return the name of the endpoint.";
            } else if (operationName.equals("Host")) {
                description = "Return the listening host name of the endpoint. A value of '*' means it is listening on all available host names.";
            } else if (operationName.equals("Port")) {
                description = "Return the listening port of the endpoint.";
            }
        }
        return description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EndPoint ").append(this.getName()).append('=');
        sb.append(this.getHost()).append(':').append(this.getPort());
        return sb.toString();
    }
}

