/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.command;

import com.ibm.websphere.cache.EntryInfo;
import com.ibm.websphere.cache.Sizeable;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CommandCaller;
import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetableCommandImpl;
import com.ibm.websphere.command.UnsetInputPropertiesException;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.command.CommandCacheProcessor;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.servlet.CacheHook;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.cache.web.config.ConfigManager;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;

public abstract class CacheableCommandImpl
extends TargetableCommandImpl
implements CacheableCommand,
Sizeable {
    private transient CommandCache commandCache = (CommandCache)ServerCache.commandCache;
    private transient boolean delayInvalidations = false;
    private transient boolean doNotCache = false;
    private transient CommandCacheProcessor commandCacheProcessor = null;
    private transient long objectSize = -1L;
    private com.ibm.ws.cache.EntryInfo entryInfo = new com.ibm.ws.cache.EntryInfo();
    private transient CommandCaller caller = null;

    @Override
    public final String getId() {
        return this.entryInfo.getId();
    }

    @Override
    public final int getSharingPolicy() {
        return this.entryInfo.getSharingPolicy();
    }

    @Override
    public boolean preExecute() {
        return false;
    }

    @Override
    public void postExecute() {
    }

    @Override
    public void execute() throws CommandException {
        if (this.commandCache == null || !this.commandCache.getCache().getCacheConfig().alwaysTriggerCommandInvalidations() && CacheHook.isSkipCache()) {
            super.execute();
            return;
        }
        if (!this.isReadyToCallExecute()) {
            throw new UnsetInputPropertiesException();
        }
        if (this.entryInfo.getId() != null) {
            throw new IllegalStateException("EntryInfo id is non-null: Command " + this.toString() + " has already been executed.");
        }
        try {
            if (targetPolicy == null) {
                throw new IllegalStateException("TargetPolicy is not set");
            }
            CommandTarget target = targetPolicy.getCommandTarget(this);
            CacheableCommand returnedCommand = null;
            this.prepareMetadata();
            if (this.doNotCache) {
                super.execute();
                return;
            }
            returnedCommand = this.getId() == null ? this.commandCache.executeCommand(this, target) : this.commandCache.getCommand(this, true);
            CommandCaller commandCaller = this.getCaller();
            if (commandCaller != null) {
                EntryInfo entryInfo = returnedCommand.getEntryInfo();
                commandCaller.unionDependencies(entryInfo);
            }
            if (this.hasOutputProperties() && this != returnedCommand) {
                if (returnedCommand == null) {
                    throw new CommandException("Command returned from CommandTarget was null and this command has output properties.");
                }
                try {
                    this.setOutputProperties(returnedCommand);
                }
                catch (RuntimeException ex) {
                    byte[] b = SerializationUtility.serialize((Serializable)returnedCommand);
                    returnedCommand = (CacheableCommand)SerializationUtility.deserialize((byte[])b, (String)this.commandCache.getCache().getCacheName());
                    this.setOutputProperties(returnedCommand);
                    this.commandCache.setCommand(this);
                }
            }
            if (this.delayInvalidations) {
                this.invalidateEntries();
            }
        }
        catch (CommandException ex) {
            FFDCFilter.processException((Throwable)((Object)ex), (String)"com.ibm.websphere.command.CacheableCommandImpl.execute", (String)"203", (Object)this.getClass().getName());
            throw ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.websphere.command.CacheableCommandImpl.execute", (String)"207", (Object)this.getClass().getName());
            if (ex instanceof RemoteException) {
                RemoteException remoteException = (RemoteException)ex;
                if (remoteException.detail != null) {
                    throw new CommandException(remoteException.detail);
                }
            }
            throw new CommandException(ex);
        }
    }

    @Override
    public void setCaller(CommandCaller caller) {
        this.caller = caller;
    }

    @Override
    public CommandCaller getCaller() {
        return this.caller;
    }

    @Override
    public void unionDependencies(EntryInfo entryInfo) {
        if (this.entryInfo == null) {
            return;
        }
        if (entryInfo == null) {
            throw new IllegalArgumentException("entryInfo is null");
        }
        this.entryInfo.unionDependencies(entryInfo);
    }

    @Override
    public EntryInfo getEntryInfo() {
        if (this.entryInfo.getTemplate() == null) {
            this.entryInfo.addTemplate(this.getClass().getName());
        }
        return this.entryInfo;
    }

    @Override
    public void reset() {
        this.entryInfo = new com.ibm.ws.cache.EntryInfo();
        this.caller = null;
        this.commandCacheProcessor = null;
        this.delayInvalidations = false;
        this.doNotCache = false;
    }

    @Override
    public boolean executeFromCache() throws CommandException {
        if (this.commandCache == null) {
            return false;
        }
        if (!this.isReadyToCallExecute()) {
            this.entryInfo = new com.ibm.ws.cache.EntryInfo();
            throw new UnsetInputPropertiesException();
        }
        CacheableCommand returnedCommand = null;
        this.prepareMetadata();
        if (this.getId() == null) {
            this.entryInfo = new com.ibm.ws.cache.EntryInfo();
            return false;
        }
        returnedCommand = this.commandCache.getCommand(this, false);
        if (returnedCommand == null) {
            this.entryInfo = new com.ibm.ws.cache.EntryInfo();
            return false;
        }
        if (this.hasOutputProperties() && this != returnedCommand) {
            this.setOutputProperties(returnedCommand);
        }
        if (this.delayInvalidations) {
            this.invalidateEntries();
        }
        return true;
    }

    @Override
    public void updateCache() {
        if (this.commandCache == null) {
            return;
        }
        if (!this.isReadyToCallExecute()) {
            throw new IllegalStateException("cannot call updateCache() on commands that are not ready for execution");
        }
        if (this.getId() == null) {
            this.prepareMetadata();
        }
        if (this.entryInfo.getId() == null) {
            throw new IllegalStateException("cannot call updateCache() on commands that are not cacheable");
        }
        this.commandCache.setCommand(this);
        if (this.delayInvalidations) {
            this.invalidateEntries();
        }
    }

    protected void prepareMetadata() {
        ConfigEntry cacheEntry = ConfigManager.getInstance().getConfigEntry(this, null);
        if (cacheEntry != null) {
            this.commandCache = (CommandCache)ServerCache.getCommandCache((String)cacheEntry.instanceName);
            this.commandCacheProcessor = (CommandCacheProcessor)ConfigManager.getInstance().getCacheProcessor(cacheEntry);
            this.commandCacheProcessor.setCacheableCommand(this);
            this.commandCacheProcessor.execute();
            this.delayInvalidations = this.commandCacheProcessor.isDelayInvalidations();
            this.doNotCache = this.commandCacheProcessor.getDoNotCache();
            this.commandCacheProcessor.setEntryInfo(this.getEntryInfo());
            if (!this.delayInvalidations) {
                this.invalidateEntries();
            }
        }
    }

    protected void invalidateEntries() {
        if (this.commandCacheProcessor != null) {
            this.commandCacheProcessor.setInvalidationIds();
            ArrayList invalidations = this.commandCacheProcessor.getInvalidationIds();
            if (invalidations != null) {
                int sz = invalidations.size();
                for (int i = 0; i < sz; ++i) {
                    this.commandCache.invalidateById((String)invalidations.get(i), i == sz - 1);
                }
            }
            ConfigManager.getInstance().returnCacheProcessor(this.commandCacheProcessor);
        }
    }

    public long getObjectSize() {
        return this.objectSize;
    }

    public void setObjectSize(long objectSize) {
        this.objectSize = objectSize;
    }
}

