/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.BluemixUtility;
import com.ibm.ws.bluemix.utility.BluemixUtilityAction;
import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;

public class HelpAction
extends BaseAction {
    private final BluemixUtility utility;

    public HelpAction(BluemixUtility utility) {
        this.utility = utility;
    }

    public String getScriptUsage() {
        StringBuilder scriptUsage = new StringBuilder();
        scriptUsage.append(NL);
        scriptUsage.append(NLS.getOption("global.usage", new Object[0]));
        scriptUsage.append(' ');
        scriptUsage.append("bluemixUtility");
        scriptUsage.append(' ');
        scriptUsage.append(NLS.getOption("global.action.lower", new Object[0]));
        scriptUsage.append(" [");
        scriptUsage.append(NLS.getOption("global.options.lower", new Object[0]));
        scriptUsage.append(']');
        scriptUsage.append(NL);
        return scriptUsage.toString();
    }

    public StringBuilder getHelpOptions() {
        StringBuilder verboseHelp = new StringBuilder(this.getScriptUsage());
        verboseHelp.append(NL);
        verboseHelp.append(NLS.getOption("global.actions", new Object[0]));
        verboseHelp.append(NL);
        for (BluemixUtilityAction action : this.utility.getActions()) {
            verboseHelp.append(NL);
            verboseHelp.append("    ");
            verboseHelp.append(action.getActionName());
            verboseHelp.append(NL);
            verboseHelp.append(action.getActionDescription());
            verboseHelp.append(NL);
        }
        verboseHelp.append(NL);
        verboseHelp.append(NLS.getOption("global.options", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append(NLS.getOption("global.options.statement", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append(NL);
        return verboseHelp;
    }

    @Override
    public String getActionName() {
        return "help";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        if (arguments.getPositionalArguments().size() == 0) {
            this.stdout.println(this.getHelpOptions());
        } else {
            String actionName = arguments.getPositionalArguments().get(0);
            BluemixUtilityAction action = this.utility.getAction(actionName);
            if (action == null) {
                this.stderr.println(NLS.getOption("task.unknown", actionName));
                this.stderr.println(this.getScriptUsage());
                return ReturnCode.BAD_ARGUMENT;
            }
            this.stdout.println(action.getActionHelp());
        }
        return ReturnCode.OK;
    }
}

