/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.web.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.common.PolicyContextHandlerImpl;
import com.ibm.ws.security.authorization.jacc.web.WebSecurityValidator;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebSecurityValidatorImpl
implements WebSecurityValidator {
    private static final TraceComponent tc = Tr.register(WebSecurityValidatorImpl.class);
    private static String[] jaccHandlerKeyArray = new String[]{"javax.security.auth.Subject.container", "javax.servlet.http.HttpServletRequest"};
    private static ProtectionDomain nullPd = new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, null, null);
    private static CodeSource nullCs = new CodeSource(null, (Certificate[])null);
    private static PolicyContextHandlerImpl pch = PolicyContextHandlerImpl.getInstance();
    static final long serialVersionUID = -6992136892718851748L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean checkDataConstraints(String contextId, Object httpServletRequest, WebUserDataPermission webUDPermission) {
        HttpServletRequest req = null;
        if (httpServletRequest != null) {
            try {
                req = (HttpServletRequest)httpServletRequest;
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl", (String)"51", (Object)this, (Object[])new Object[]{contextId, httpServletRequest, webUDPermission});
                Tr.error((TraceComponent)tc, (String)"JACC_WEB_SPI_PARAMETER_ERROR", (Object[])new Object[]{httpServletRequest.getClass().getName(), "checkDataConstraints", "HttpServletRequest"});
                return false;
            }
        }
        Boolean result = Boolean.FALSE;
        try {
            final WebUserDataPermission wudp = webUDPermission;
            final String fci = contextId;
            final HashMap handlerObjects = new HashMap();
            final HttpServletRequest hsr = req;
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = 5506202845143740964L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws PolicyContextException {
                    PolicyContext.setContextID((String)fci);
                    for (String jaccHandlerKey : jaccHandlerKeyArray) {
                        PolicyContext.registerHandler((String)jaccHandlerKey, (PolicyContextHandler)pch, (boolean)true);
                    }
                    handlerObjects.put(jaccHandlerKeyArray[1], hsr);
                    PolicyContext.setHandlerData((Object)handlerObjects);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Calling JACC implies", (Object[])new Object[0]);
                    }
                    return Policy.getPolicy().implies(nullPd, (Permission)wudp);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException wudp) {
            void e;
            FFDCFilter.processException((Throwable)wudp, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl", (String)"80", (Object)this, (Object[])new Object[]{contextId, httpServletRequest, webUDPermission});
            Tr.error((TraceComponent)tc, (String)"JACC_WEB_IMPLIES_FAILURE", (Object[])new Object[]{contextId, e.getException()});
            result = Boolean.FALSE;
        }
        finally {
            this.resetHandlerInfo();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean checkResourceConstraints(String contextId, Object httpServletRequest, Permission webPerm, Subject subject) {
        HttpServletRequest req = null;
        if (httpServletRequest != null) {
            try {
                req = (HttpServletRequest)httpServletRequest;
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl", (String)"97", (Object)this, (Object[])new Object[]{contextId, httpServletRequest, webPerm, subject});
                Tr.error((TraceComponent)tc, (String)"JACC_WEB_SPI_PARAMETER_ERROR", (Object[])new Object[]{httpServletRequest.getClass().getName(), "checkDataConstraints", "HttpServletRequest"});
                return false;
            }
        }
        boolean result = false;
        try {
            HashMap<String, Object> ho = new HashMap<String, Object>();
            Subject s = subject;
            String cid = contextId;
            Permission p = webPerm;
            HttpServletRequest r = req;
            result = this.checkResourceConstraints(cid, r, p, s, ho);
        }
        catch (PrivilegedActionException ho) {
            void e;
            FFDCFilter.processException((Throwable)ho, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl", (String)"110", (Object)this, (Object[])new Object[]{contextId, httpServletRequest, webPerm, subject});
            Tr.error((TraceComponent)tc, (String)"JACC_WEB_IMPLIES_FAILURE", (Object[])new Object[]{contextId, e.getException()});
        }
        finally {
            this.resetHandlerInfo();
        }
        return result;
    }

    private boolean checkResourceConstraints(final String contextId, final HttpServletRequest req, final Permission permission, final Subject subject, final HashMap<String, Object> handlerObjects) throws PrivilegedActionException {
        Boolean result = Boolean.FALSE;
        result = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
            static final long serialVersionUID = -2021383360035354984L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() throws PolicyContextException {
                PolicyContext.setContextID((String)contextId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Registering JACC context handlers", (Object[])new Object[0]);
                }
                for (String key : jaccHandlerKeyArray) {
                    PolicyContext.registerHandler((String)key, (PolicyContextHandler)pch, (boolean)true);
                }
                handlerObjects.put(jaccHandlerKeyArray[0], subject);
                handlerObjects.put(jaccHandlerKeyArray[1], req);
                ProtectionDomain pd = null;
                if (subject != null && subject.getPrincipals().size() > 0) {
                    Principal[] principalArray = subject.getPrincipals().toArray(new Principal[subject.getPrincipals().size()]);
                    pd = new ProtectionDomain(nullCs, null, null, principalArray);
                } else {
                    pd = nullPd;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Setting JACC handler data", (Object[])new Object[0]);
                }
                PolicyContext.setHandlerData((Object)handlerObjects);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling JACC implies. PD : " + pd), (Object[])new Object[0]);
                }
                return Policy.getPolicy().implies(pd, permission);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void resetHandlerInfo() {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = 6327173231917360992L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(3.class);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.authorization.jacc.web.impl.WebSecurityValidatorImpl", (String)"169", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Exception when resetting setHandler data. Ignoring.. " + e.getException()), (Object[])new Object[0]);
            }
        }
    }
}

