/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

class BooleanArrayDescriptor
extends ArrayDescriptor {
    BooleanArrayDescriptor(Class type, Class elemType, TypeRepository rep) {
        super(type, elemType, rep);
    }

    public Serializable readValue(InputStream in, Map offsetMap, Integer key) {
        boolean[] arr = new boolean[in.read_long()];
        offsetMap.put(key, arr);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = in.read_boolean();
        }
        return arr;
    }

    @Override
    public void writeValue(OutputStream out, Serializable value) {
        boolean[] arr = (boolean[])value;
        out.write_long(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            out.write_boolean(arr[i]);
        }
    }

    @Override
    Object copyObject(Object value, CopyState state) {
        if (((boolean[])value).length == 0) {
            return value;
        }
        Object copy = ((boolean[])value).clone();
        state.put(value, copy);
        return copy;
    }

    @Override
    void printFields(PrintWriter pw, Map recurse, Object val) {
        boolean[] arr = (boolean[])val;
        pw.print("length=" + arr.length + "; ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            pw.print(arr[i]);
        }
    }
}

