/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.overlay.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.ExtractableArtifactEntry;
import com.ibm.ws.artifact.overlay.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayNotifier;
import com.ibm.ws.artifact.overlay.internal.OverlayCache;
import com.ibm.ws.artifact.overlay.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.artifact.DefaultArtifactNotification;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DirectoryBasedOverlayContainerImpl
implements OverlayContainer {
    private final ArtifactContainer base;
    private final Set<String> maskSet;
    private final ContainerFactoryHolder cfHolder;
    private ArtifactContainer fileOverlayContainer;
    private File overlayDirectory;
    private File cacheDirForOverlay;
    private DirectoryBasedOverlayNotifier overlayNotifier;
    private final ArtifactContainer enclosingContainer;
    private final ArtifactEntry entryInEnclosingContainer;
    private final Map<String, OverlayContainer> nestedOverlays = new ConcurrentHashMap<String, OverlayContainer>();
    private final OverlayCache cacheStore = new OverlayCache();
    private final DirectoryBasedOverlayContainerImpl parentOverlay;
    private volatile boolean isPassThroughMode = true;
    static final long serialVersionUID = -1690795617118238166L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DirectoryBasedOverlayContainerImpl(ArtifactContainer base, ContainerFactoryHolder cfHolder) {
        this(base, cfHolder, null, null, null);
    }

    public DirectoryBasedOverlayContainerImpl(ArtifactContainer base, ContainerFactoryHolder cfHolder, ArtifactContainer parent, ArtifactEntry entryInParent, DirectoryBasedOverlayContainerImpl parentOverlay) {
        if (!base.isRoot()) {
            throw new IllegalArgumentException();
        }
        this.base = base;
        this.maskSet = new HashSet<String>();
        this.cfHolder = cfHolder;
        this.enclosingContainer = parent;
        this.entryInEnclosingContainer = entryInParent;
        this.parentOverlay = parentOverlay;
    }

    @Override
    public OverlayContainer getOverlayForEntryPath(String path) {
        ArtifactContainer test;
        OverlayContainer result = null;
        ArtifactEntry testEntry = this.getEntry(path);
        if (testEntry != null && (test = testEntry.convertToContainer()).isRoot()) {
            result = this.internalGetOverlayForEntryPath(test, testEntry, path);
        }
        return result;
    }

    @Override
    public OverlayContainer getParentOverlay() {
        return this.parentOverlay;
    }

    private synchronized OverlayContainer internalGetOverlayForEntryPath(ArtifactContainer containerBeingOverlaid, ArtifactEntry entryRepresentingContainerInOverlay, String pathToEntryInOverlay) {
        DirectoryBasedOverlayContainerImpl result = null;
        if (this.nestedOverlays.containsKey(pathToEntryInOverlay)) {
            return this.nestedOverlays.get(pathToEntryInOverlay);
        }
        DirectoryBasedOverlayContainerImpl d = new DirectoryBasedOverlayContainerImpl(containerBeingOverlaid, this.cfHolder, entryRepresentingContainerInOverlay.getEnclosingContainer(), entryRepresentingContainerInOverlay, this);
        String name = entryRepresentingContainerInOverlay.getName();
        File originalOverlayDir = this.overlayDirectory.getParentFile();
        File originalCacheDir = this.cacheDirForOverlay;
        String parentPath = PathUtils.getParent((String)pathToEntryInOverlay);
        File newOverlayDir = new File(originalOverlayDir, pathToEntryInOverlay);
        File newCacheDir = null;
        if (entryRepresentingContainerInOverlay.getEnclosingContainer() != null && !entryRepresentingContainerInOverlay.getEnclosingContainer().isRoot()) {
            newCacheDir = new File(originalCacheDir, parentPath);
            newCacheDir = new File(newCacheDir, ".cache");
            newCacheDir = new File(newCacheDir, name);
        } else {
            newCacheDir = new File(originalCacheDir, ".cache");
            newCacheDir = new File(newCacheDir, name);
        }
        boolean createOk = true;
        if (!FileUtils.fileExists((File)newOverlayDir)) {
            createOk &= FileUtils.fileMkDirs((File)newOverlayDir);
        }
        if (!FileUtils.fileExists((File)newCacheDir)) {
            createOk &= FileUtils.fileMkDirs((File)newCacheDir);
        }
        if (!createOk) {
            throw new IllegalStateException();
        }
        d.setOverlayDirectory(newCacheDir, newOverlayDir);
        this.nestedOverlays.put(pathToEntryInOverlay, d);
        result = d;
        return result;
    }

    public void useFastMode() {
        this.base.useFastMode();
    }

    public void stopUsingFastMode() {
        this.base.stopUsingFastMode();
    }

    public boolean isRoot() {
        return true;
    }

    public ArtifactEntry getEntry(String pathAndName) {
        if (this.isPassThroughMode) {
            ArtifactEntry baseEntry = this.base.getEntry(pathAndName);
            if (baseEntry != null) {
                return new OverlayDelegatingEntry(this, baseEntry, baseEntry.getName(), baseEntry.getPath(), this.fileOverlayContainer);
            }
            return null;
        }
        if (!PathUtils.isNormalizedPathAbsolute((String)(pathAndName = PathUtils.normalizeUnixStylePath((String)pathAndName)))) {
            return null;
        }
        if (!pathAndName.startsWith("/")) {
            pathAndName = "/" + pathAndName;
        }
        if (pathAndName.equals("/") || pathAndName.equals("")) {
            return null;
        }
        if (!this.maskSet.contains(pathAndName)) {
            ArtifactEntry target = null;
            if (this.fileOverlayContainer != null) {
                target = this.fileOverlayContainer.getEntry(pathAndName);
            }
            if (target == null) {
                target = this.base.getEntry(pathAndName);
            }
            if (target != null) {
                return new OverlayDelegatingEntry(this, target, target.getName(), target.getPath(), this.fileOverlayContainer);
            }
            return null;
        }
        return null;
    }

    public Iterator<ArtifactEntry> iterator() {
        return new EnhancedEntryIterator(this, this.base.getPath(), this.fileOverlayContainer);
    }

    public ArtifactContainer getEnclosingContainer() {
        return this.enclosingContainer;
    }

    public ArtifactEntry getEntryInEnclosingContainer() {
        return this.entryInEnclosingContainer;
    }

    public String getPath() {
        return this.base.getPath();
    }

    public String getName() {
        return "/";
    }

    @Override
    public ArtifactContainer getContainerBeingOverlaid() {
        return this.base;
    }

    @Override
    public void mask(String path) {
        this.isPassThroughMode = false;
        if (this.overlayNotifier == null) {
            throw new IllegalStateException();
        }
        if (this.getEntry(path) != null) {
            HashSet<String> paths = new HashSet<String>();
            paths.add(path);
            ArtifactContainer entryAsContainer = this.getEntry(path).convertToContainer(true);
            if (entryAsContainer != null) {
                this.collectPaths(entryAsContainer, paths);
            }
            this.overlayNotifier.notifyEntryChange((ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification((ArtifactContainer)this, Collections.emptySet()), (ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification((ArtifactContainer)this, paths), (ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification((ArtifactContainer)this, Collections.emptySet()));
        }
        this.maskSet.add(path);
    }

    @Override
    public void unMask(String path) {
        if (this.overlayNotifier == null) {
            throw new IllegalStateException();
        }
        this.maskSet.remove(path);
        this.isPassThroughMode = this.maskSet.isEmpty();
        if (this.getEntry(path) != null) {
            HashSet<String> paths = new HashSet<String>();
            paths.add(path);
            ArtifactContainer entryAsContainer = this.getEntry(path).convertToContainer(true);
            if (entryAsContainer != null) {
                this.collectPaths(entryAsContainer, paths);
            }
            this.overlayNotifier.notifyEntryChange((ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification((ArtifactContainer)this, paths), (ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification((ArtifactContainer)this, Collections.emptySet()), (ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification((ArtifactContainer)this, Collections.emptySet()));
        }
    }

    @Override
    public boolean isMasked(String path) {
        return this.maskSet.contains(path);
    }

    @Override
    public Set<String> getMaskedPaths() {
        return this.maskSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized boolean cloneEntryToOverlay(ArtifactEntry e, String path, Boolean addAsRoot) throws IOException {
        block28: {
            block29: {
                block26: {
                    block27: {
                        block24: {
                            block25: {
                                i = null;
                                c = null;
                                i = e.getInputStream();
                                c = e.convertToContainer();
                                if (i != null || c != null) break block24;
                                var6_6 = false;
                                if (i == null) break block25;
                                try {
                                    i.close();
                                }
                                catch (IOException var7_11) {
                                    FFDCFilter.processException((Throwable)var7_11, (String)"com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerImpl", (String)"1057", (Object)this, (Object[])new Object[]{e, path, addAsRoot});
                                }
                            }
                            return var6_6;
                        }
                        if (i != null || c == null) break block26;
                        v0 = root = addAsRoot != null ? addAsRoot.booleanValue() : c.isRoot();
                        if (!root) break block26;
                        var7_12 = false;
                        if (i == null) break block27;
                        try {
                            i.close();
                        }
                        catch (IOException var8_15) {
                            FFDCFilter.processException((Throwable)var8_15, (String)"com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerImpl", (String)"1057", (Object)this, (Object[])new Object[]{e, path, addAsRoot});
                        }
                    }
                    return var7_12;
                }
                if (i == null) ** GOTO lbl61
                f = new File(this.overlayDirectory, path);
                parent = f.getParentFile();
                if (FileUtils.fileExists((File)parent) || FileUtils.fileMkDirs((File)parent)) break block28;
                var8_16 = false;
                if (i == null) break block29;
                try {
                    i.close();
                }
                catch (IOException var9_18) {
                    FFDCFilter.processException((Throwable)var9_18, (String)"com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerImpl", (String)"1057", (Object)this, (Object[])new Object[]{e, path, addAsRoot});
                }
            }
            return var8_16;
        }
        try {
            fos = null;
            try {
                fos = Utils.getOutputStream(f, false);
                i = new BufferedInputStream(i);
                buf = new byte[1024];
                while ((len = i.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
                fos.close();
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
lbl61:
            // 1 sources

            if (c != null) {
                for (ArtifactEntry nested : c) {
                    this.cloneEntryToOverlay(nested, path + "/" + nested.getName(), c.isRoot());
                }
            }
            ** if (i == null) goto lbl-1000
        }
        catch (Throwable var12_22) {
            if (i != null) {
                try {
                    i.close();
                }
                catch (IOException var13_23) {
                    FFDCFilter.processException((Throwable)var13_23, (String)"com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerImpl", (String)"1057", (Object)this, (Object[])new Object[]{e, path, addAsRoot});
                }
            }
            throw var12_22;
        }
lbl-1000:
        // 1 sources

        {
            try {
                i.close();
            }
            catch (IOException var6_10) {
                FFDCFilter.processException((Throwable)var6_10, (String)"com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerImpl", (String)"1057", (Object)this, (Object[])new Object[]{e, path, addAsRoot});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        return true;
    }

    @Override
    public boolean addToOverlay(ArtifactEntry e) {
        if (this.fileOverlayContainer == null) {
            throw new IllegalStateException();
        }
        this.isPassThroughMode = false;
        try {
            return this.cloneEntryToOverlay(e, e.getPath(), null);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerImpl", (String)"1074", (Object)this, (Object[])new Object[]{e});
            return false;
        }
    }

    @Override
    public boolean addToOverlay(ArtifactEntry e, String path, boolean addAsRoot) {
        if (this.fileOverlayContainer == null) {
            throw new IllegalStateException();
        }
        this.isPassThroughMode = false;
        try {
            return this.cloneEntryToOverlay(e, path, addAsRoot);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerImpl", (String)"1089", (Object)this, (Object[])new Object[]{e, path, addAsRoot});
            return false;
        }
    }

    private boolean removeFile(File f) {
        if (Utils.fileIsFile(f)) {
            return Utils.deleteFile(f);
        }
        boolean ok = true;
        File[] children = Utils.listFiles(f);
        if (children != null) {
            for (File child : children) {
                ok &= this.removeFile(child);
            }
        }
        if (ok) {
            ok &= Utils.deleteFile(f);
        }
        return ok;
    }

    @Override
    public synchronized boolean removeFromOverlay(String path) {
        if (this.fileOverlayContainer == null) {
            throw new IllegalStateException();
        }
        File f = new File(this.overlayDirectory, path);
        if (FileUtils.fileExists((File)f)) {
            return this.removeFile(f);
        }
        return false;
    }

    @Override
    public boolean isOverlaid(String path) {
        if ("/".equals(path)) {
            return false;
        }
        if (this.fileOverlayContainer != null) {
            return this.fileOverlayContainer.getEntry(path) != null;
        }
        return false;
    }

    private void collectPaths(ArtifactContainer c, Set<String> s) {
        if (!"/".equals(c.getPath())) {
            s.add(c.getPath());
        }
        for (ArtifactEntry e : c) {
            s.add(e.getPath());
            ArtifactContainer n = e.convertToContainer();
            if (n == null || n.isRoot()) continue;
            this.collectPaths(n, s);
        }
    }

    @Override
    public Set<String> getOverlaidPaths() {
        HashSet<String> s = new HashSet<String>();
        this.collectPaths(this.fileOverlayContainer, s);
        return s;
    }

    @Override
    public synchronized void setOverlayDirectory(File cacheDirForOverlayContent, File f) {
        if (!FileUtils.fileExists((File)f) || !Utils.fileIsDirectory(f)) {
            throw new IllegalArgumentException();
        }
        if (!FileUtils.fileExists((File)cacheDirForOverlayContent) || !Utils.fileIsDirectory(cacheDirForOverlayContent)) {
            throw new IllegalArgumentException();
        }
        File overlay = new File(f, ".overlay");
        if (!(FileUtils.listFiles((File)f).length == 0 || FileUtils.fileExists((File)overlay) && FileUtils.fileIsDirectory((File)overlay))) {
            throw new IllegalArgumentException();
        }
        if (!FileUtils.fileExists((File)overlay)) {
            FileUtils.fileMkDirs((File)overlay);
        }
        this.overlayDirectory = overlay;
        this.cacheDirForOverlay = cacheDirForOverlayContent;
        this.fileOverlayContainer = this.cfHolder.getContainerFactory().getContainer(cacheDirForOverlayContent, (Object)overlay);
        if (this.fileOverlayContainer == null) {
            throw new IllegalStateException();
        }
        DirectoryBasedOverlayNotifier parentN = this.parentOverlay == null ? null : this.parentOverlay.overlayNotifier;
        this.overlayNotifier = new DirectoryBasedOverlayNotifier(this, this.fileOverlayContainer, parentN, this.entryInEnclosingContainer);
        Set<String> overlaid = this.getOverlaidPaths();
        this.isPassThroughMode = overlaid.size() == 0;
    }

    public ArtifactContainer getRoot() {
        return this;
    }

    public Collection<URL> getURLs() {
        Collection overlay;
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        Collection base = this.base.getURLs();
        if (base != null) {
            set.addAll(base);
        }
        if ((overlay = this.fileOverlayContainer.getURLs()) != null) {
            set.addAll(overlay);
        }
        return set;
    }

    public String getPhysicalPath() {
        return this.base.getPhysicalPath();
    }

    @Override
    public void addToNonPersistentCache(String path, Class owner, Object data) {
        this.cacheStore.addToCache(path, owner, data);
    }

    @Override
    public void removeFromNonPersistentCache(String path, Class owner) {
        this.cacheStore.removeFromCache(path, owner);
    }

    @Override
    public Object getFromNonPersistentCache(String path, Class owner) {
        return this.cacheStore.getFromCache(path, owner);
    }

    public ArtifactNotifier getArtifactNotifier() {
        if (this.overlayNotifier == null) {
            throw new IllegalStateException();
        }
        return this.overlayNotifier;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DirectoryBasedOverlayContainerImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class StubContainer
    implements ArtifactContainer {
        private final DirectoryBasedOverlayContainerImpl owner;
        private final String name;
        private final String path;
        static final long serialVersionUID = -5612806089679965953L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StubContainer(DirectoryBasedOverlayContainerImpl owner, String path, String name, ArtifactEntry e) {
            this.owner = owner;
            this.name = name;
            this.path = path;
        }

        public Iterator<ArtifactEntry> iterator() {
            throw new IllegalStateException();
        }

        public ArtifactContainer getEnclosingContainer() {
            throw new IllegalStateException();
        }

        public ArtifactEntry getEntryInEnclosingContainer() {
            throw new IllegalStateException();
        }

        public String getPath() {
            throw new IllegalStateException();
        }

        public String getName() {
            return this.name;
        }

        public void useFastMode() {
        }

        public void stopUsingFastMode() {
        }

        public boolean isRoot() {
            return false;
        }

        public ArtifactEntry getEntry(String pathAndName) {
            if (pathAndName.startsWith("/")) {
                return this.owner.getEntry(pathAndName);
            }
            return this.owner.getEntry(this.path + "/" + pathAndName);
        }

        public ArtifactContainer getRoot() {
            return null;
        }

        public Collection<URL> getURLs() {
            throw new UnsupportedOperationException();
        }

        public String getPhysicalPath() {
            return null;
        }

        public ArtifactNotifier getArtifactNotifier() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StubContainer.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class StubEntry
    implements ArtifactEntry {
        private final String name;
        private final ArtifactContainer convertTo;
        static final long serialVersionUID = -1641575474073667568L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StubEntry(String name, ArtifactContainer convertTo) {
            this.name = name;
            this.convertTo = convertTo;
        }

        public ArtifactContainer getEnclosingContainer() {
            throw new IllegalStateException();
        }

        public String getPath() {
            throw new IllegalStateException();
        }

        public String getName() {
            return this.name;
        }

        public ArtifactContainer convertToContainer() {
            return this.convertTo;
        }

        public ArtifactContainer convertToContainer(boolean localOnly) {
            if (localOnly && this.convertTo.isRoot()) {
                return null;
            }
            return this.convertTo;
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }

        public long getSize() {
            return 0L;
        }

        public ArtifactContainer getRoot() {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public URL getResource() {
            return null;
        }

        public String getPhysicalPath() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StubEntry.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class OverlayDelegatingEntry
    implements ExtractableArtifactEntry {
        private final ArtifactEntry delegate;
        private final DirectoryBasedOverlayContainerImpl root;
        private final String name;
        private final String path;
        private final ArtifactContainer fileContainer;
        static final long serialVersionUID = 8024630399631050688L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OverlayDelegatingEntry(DirectoryBasedOverlayContainerImpl co, ArtifactEntry e, String name, String path, ArtifactContainer f) {
            this.root = co;
            this.delegate = e;
            this.name = name;
            this.path = path;
            this.fileContainer = f;
            if (e == null) {
                throw new IllegalArgumentException();
            }
        }

        public ArtifactContainer getEnclosingContainer() {
            String parent = PathUtils.getParent((String)this.path);
            DirectoryBasedOverlayContainerImpl c = null;
            if (parent != null) {
                if ("/".equals(parent)) {
                    c = this.root;
                } else {
                    ArtifactEntry e = this.root.getEntry(parent);
                    c = e.convertToContainer();
                }
            }
            return c;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public ArtifactContainer convertToContainer() {
            return this.convertToContainer(false);
        }

        public ArtifactContainer convertToContainer(boolean localOnly) {
            Object converted = null;
            ArtifactContainer test = this.delegate.convertToContainer(localOnly);
            if (test != null) {
                boolean isRoot = test.isRoot();
                converted = isRoot && !localOnly ? this.root.internalGetOverlayForEntryPath(test, (ArtifactEntry)this, this.path) : new OverlayDelegatingContainer(this.root, test, this.path, this.name, this.fileContainer);
            }
            return converted;
        }

        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        public long getSize() {
            return this.delegate.getSize();
        }

        public String toString() {
            return "Overlay ArtifactEntry at " + this.path + " name " + this.name + " Wrapping " + this.delegate.toString();
        }

        public ArtifactContainer getRoot() {
            return this.root;
        }

        public long getLastModified() {
            long clastmod;
            long lastmod = this.delegate.getLastModified();
            ArtifactEntry e = this.fileContainer.getEntry(this.getPath());
            if (e != null && (clastmod = e.getLastModified()) != 0L) {
                lastmod = clastmod;
            }
            return lastmod;
        }

        public URL getResource() {
            URL cresource;
            URL resource = this.delegate.getResource();
            ArtifactEntry e = this.fileContainer.getEntry(this.getPath());
            if (e != null && (cresource = e.getResource()) != null) {
                resource = cresource;
            }
            return resource;
        }

        public String getPhysicalPath() {
            String cpath;
            String path = this.delegate.getPhysicalPath();
            ArtifactEntry e = this.fileContainer.getEntry(this.getPath());
            if (e != null && (cpath = e.getPhysicalPath()) != null) {
                path = cpath;
            }
            return path;
        }

        public File extract() throws IOException {
            if (this.delegate instanceof ExtractableArtifactEntry) {
                return ((ExtractableArtifactEntry)this.delegate).extract();
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(OverlayDelegatingEntry.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class OverlayDelegatingContainer
    implements ArtifactContainer {
        private final DirectoryBasedOverlayContainerImpl owner;
        private final ArtifactContainer delegate;
        private final String path;
        private final String name;
        private final ArtifactContainer fileContainer;
        static final long serialVersionUID = 4238962217055258374L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OverlayDelegatingContainer(DirectoryBasedOverlayContainerImpl owner, ArtifactContainer delegate, String path, String name, ArtifactContainer f) {
            this.owner = owner;
            this.delegate = delegate;
            this.path = path;
            this.name = name;
            this.fileContainer = f;
        }

        public Iterator<ArtifactEntry> iterator() {
            return new EnhancedEntryIterator(this.owner, this.path, this.fileContainer);
        }

        public ArtifactContainer getEnclosingContainer() {
            String parent = PathUtils.getParent((String)this.path);
            DirectoryBasedOverlayContainerImpl c = null;
            if (parent != null) {
                if ("/".equals(parent)) {
                    c = this.owner;
                } else {
                    ArtifactEntry e = this.owner.getEntry(parent);
                    c = e.convertToContainer();
                }
            }
            return c;
        }

        public ArtifactEntry getEntryInEnclosingContainer() {
            ArtifactEntry e = null;
            if (this.path != null) {
                e = "/".equals(this.path) ? this.owner.entryInEnclosingContainer : this.owner.getEntry(this.path);
            }
            return e;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public void useFastMode() {
            this.delegate.useFastMode();
        }

        public void stopUsingFastMode() {
            this.delegate.stopUsingFastMode();
        }

        public boolean isRoot() {
            return this.delegate.isRoot();
        }

        public ArtifactContainer getRoot() {
            return this.owner;
        }

        public ArtifactEntry getEntry(String pathAndName) {
            if (pathAndName.startsWith("/")) {
                return this.owner.getEntry(pathAndName);
            }
            return this.owner.getEntry(this.getPath() + "/" + pathAndName);
        }

        public String toString() {
            return "Overlay ArtifactContainer at virtual location " + this.path + " for " + this.delegate;
        }

        public Collection<URL> getURLs() {
            Collection fset;
            ArtifactContainer correspondingFileContainer;
            ArtifactEntry e;
            Collection base = this.delegate.getURLs();
            HashSet<URL> set = new HashSet<URL>();
            if (base != null) {
                set.addAll(base);
            }
            if ((e = this.fileContainer.getEntry(this.getPath())) != null && (correspondingFileContainer = e.convertToContainer()) != null && (fset = correspondingFileContainer.getURLs()) != null) {
                set.addAll(fset);
            }
            return set;
        }

        public String getPhysicalPath() {
            String cpath;
            ArtifactContainer correspondingFileContainer;
            String path = this.delegate.getPhysicalPath();
            ArtifactEntry e = this.fileContainer.getEntry(this.getPath());
            if (e != null && (correspondingFileContainer = e.convertToContainer()) != null && (cpath = correspondingFileContainer.getPhysicalPath()) != null) {
                path = cpath;
            }
            return path;
        }

        public ArtifactNotifier getArtifactNotifier() {
            return this.owner.getArtifactNotifier();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(OverlayDelegatingContainer.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class EnhancedEntryIterator
    implements Iterator<ArtifactEntry> {
        private final Iterator<ArtifactEntry> baseIter;
        private final Iterator<ArtifactEntry> overlaidEntries;
        private final DirectoryBasedOverlayContainerImpl overlay;
        private final ArtifactContainer fileOverlayContainer;
        private final Set<String> processedPaths;
        private final String path;
        private static final Set<ArtifactEntry> s;
        private ArtifactEntry internalNext;
        static final long serialVersionUID = 6913174334737396915L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EnhancedEntryIterator(DirectoryBasedOverlayContainerImpl overlay, String path, ArtifactContainer c) {
            this.overlay = overlay;
            this.fileOverlayContainer = c;
            ArtifactContainer fileContainer = null;
            if (path.equals("/")) {
                this.path = "";
                fileContainer = this.fileOverlayContainer;
            } else {
                this.path = path;
                ArtifactEntry e = null;
                if (this.fileOverlayContainer != null) {
                    e = this.fileOverlayContainer.getEntry(path);
                }
                if (e != null) {
                    fileContainer = e.convertToContainer();
                }
            }
            this.overlaidEntries = fileContainer == null ? s.iterator() : fileContainer.iterator();
            this.processedPaths = new HashSet<String>();
            Iterator iterForBase = null;
            ArtifactContainer overlaidContainer = overlay.getContainerBeingOverlaid();
            if ("/".equals(path)) {
                iterForBase = overlaidContainer.iterator();
            } else {
                ArtifactContainer baseCon;
                ArtifactEntry baseEntry = overlaidContainer.getEntry(path);
                if (baseEntry != null && (baseCon = baseEntry.convertToContainer()) != null) {
                    iterForBase = baseCon.iterator();
                }
            }
            this.baseIter = iterForBase;
            this.internalNext = this.internalNext();
        }

        private ArtifactEntry internalNext() {
            ArtifactEntry n = null;
            while (n == null) {
                String possiblePath;
                if (this.baseIter != null && this.baseIter.hasNext()) {
                    ArtifactEntry possible = this.baseIter.next();
                    possiblePath = this.path + "/" + possible.getName();
                    if (this.overlay.getMaskedPaths().contains(possiblePath)) continue;
                    n = this.overlay.getEntry(possiblePath);
                    this.processedPaths.add(possiblePath);
                    continue;
                }
                if (!this.overlaidEntries.hasNext()) break;
                ArtifactEntry possibleEntry = this.overlaidEntries.next();
                possiblePath = possibleEntry.getPath();
                if (this.processedPaths.contains(possiblePath) || this.overlay.getMaskedPaths().contains(possiblePath)) continue;
                n = this.overlay.getEntry(possiblePath);
                this.processedPaths.add(possiblePath);
            }
            return n;
        }

        @Override
        public boolean hasNext() {
            return this.internalNext != null;
        }

        @Override
        public ArtifactEntry next() {
            ArtifactEntry toBeReturned = this.internalNext;
            if (toBeReturned != null) {
                this.internalNext = this.internalNext();
                return toBeReturned;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EnhancedEntryIterator.class);
            s = Collections.emptySet();
        }
    }
}

