/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import com.ibm.wsspi.rest.handler.helper.RESTRoutingHelper;
import java.io.IOException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/router", "com.ibm.wsspi.rest.handler.root=/router/{uri}"})
public class MBeanRouterHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(MBeanRouterHandler.class);
    private final String KEY_ROUTING_HELPER = "routingHelper";
    private final AtomicServiceReference<RESTRoutingHelper> routingHelperRef = new AtomicServiceReference("routingHelper");
    static final long serialVersionUID = -1888720844554160922L;

    @Activate
    protected void activate(ComponentContext context) {
        this.routingHelperRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.routingHelperRef.deactivate(context);
    }

    @Reference(service=RESTRoutingHelper.class, name="routingHelper", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRoutingHelper(ServiceReference<RESTRoutingHelper> routingHelper) {
        this.routingHelperRef.setReference(routingHelper);
    }

    protected void unsetRoutingHelper(ServiceReference<RESTRoutingHelper> routingHelper) {
        this.routingHelperRef.unsetReference(routingHelper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (request.getPathVariable("uri") != null) {
            if (RESTHelper.isGetMethod(method)) {
                this.getProxy(request, response);
                return;
            } else if (RESTHelper.isPostMethod(method)) {
                this.postProxy(request, response);
                return;
            } else if (RESTHelper.isPutMethod(method)) {
                this.putProxy(request, response);
                return;
            } else {
                if (!RESTHelper.isDeleteMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,POST,PUT,DELETE");
                this.deleteProxy(request, response);
            }
            return;
        } else {
            if (!RESTHelper.isGetMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET");
            this.getProxyRoot(request, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getProxyRoot(RESTRequest request, RESTResponse response) {
        try {
            this.getRoutingHelper().routeRequest(request, response, true);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.MBeanRouterHandler", (String)"112", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
        }
        response.setContentType("application/json");
    }

    /*
     * WARNING - void declaration
     */
    private void getProxy(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "uri");
        try {
            this.getRoutingHelper().routeRequest(request, response, true);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.MBeanRouterHandler", (String)"127", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
        }
        response.setContentType("application/json");
    }

    /*
     * WARNING - void declaration
     */
    private void putProxy(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "uri");
        try {
            this.getRoutingHelper().routeRequest(request, response, true);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.MBeanRouterHandler", (String)"142", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
        }
        response.setContentType("application/json");
    }

    /*
     * WARNING - void declaration
     */
    private void postProxy(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "uri");
        try {
            this.getRoutingHelper().routeRequest(request, response, true);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.MBeanRouterHandler", (String)"157", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
        }
        response.setContentType("application/json");
    }

    /*
     * WARNING - void declaration
     */
    private void deleteProxy(RESTRequest request, RESTResponse response) {
        RESTHelper.getRequiredParam(request, "uri");
        try {
            this.getRoutingHelper().routeRequest(request, response, true);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.MBeanRouterHandler", (String)"172", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
        }
        response.setContentType("application/json");
    }

    private RESTRoutingHelper getRoutingHelper() throws IOException {
        RESTRoutingHelper routingHelper = (RESTRoutingHelper)this.routingHelperRef.getService();
        if (routingHelper == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"RESTRoutingHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return routingHelper;
    }
}

