/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.linkedlist2;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.utils.linkedlist2.LinkedList;
import com.ibm.ws.sib.utils.ras.SibTr;

public class Entry {
    protected LinkedList parentList = null;
    protected Entry previous = null;
    protected Entry next = null;
    private static final TraceComponent tc = SibTr.register(Entry.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public Entry getPrevious() {
        this.checkEntryParent();
        Entry entry = null;
        if (!this.isFirst()) {
            entry = this.previous;
        }
        return entry;
    }

    public Entry getNext() {
        this.checkEntryParent();
        Entry entry = null;
        if (!this.isLast()) {
            entry = this.next;
        }
        return entry;
    }

    Entry insertAfter(Entry newEntry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insertAfter", (Object)new Object[]{newEntry});
        }
        this.checkEntryParent();
        if (newEntry.parentList == null) {
            Entry nextEntry = this.getNext();
            newEntry.previous = this;
            newEntry.next = nextEntry;
            newEntry.parentList = this.parentList;
            if (nextEntry != null) {
                nextEntry.previous = newEntry;
            }
            this.next = newEntry;
            if (this.isLast()) {
                this.parentList.last = newEntry;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"insertAfter", (Object)newEntry);
            }
            return newEntry;
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:154:1.3"}, null));
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Entry.insertAfter", (String)"1:160:1.3", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:167:1.3"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insertAfter", (Object)((Object)e));
        }
        throw e;
    }

    Entry remove() {
        Entry nextEntry;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove");
        }
        this.checkEntryParent();
        Entry removedEntry = null;
        Entry prevEntry = this.getPrevious();
        if (prevEntry != null) {
            prevEntry.next = this.next;
        }
        if ((nextEntry = this.getNext()) != null) {
            nextEntry.previous = prevEntry;
        }
        if (this.isFirst()) {
            this.parentList.first = nextEntry;
        }
        if (this.isLast()) {
            this.parentList.last = prevEntry;
        }
        this.next = null;
        this.previous = null;
        this.parentList = null;
        removedEntry = this;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove", (Object)removedEntry);
        }
        return removedEntry;
    }

    void checkEntryParent() {
        if (this.parentList == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:239:1.3"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Entry.checkEntryParent", (String)"1:246:1.3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:253:1.3"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkEntryParent", (Object)((Object)e));
            }
            throw e;
        }
    }

    boolean isFirst() {
        return this.parentList.first == this;
    }

    boolean isLast() {
        return this.parentList.last == this;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer buffer = new StringBuffer();
        if (this.parentList == null) {
            buffer.append("Entry not in list - ");
            buffer.append(super.toString());
        } else {
            buffer.append(indent);
            buffer.append(super.toString());
        }
        return buffer.toString();
    }
}

