/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Hashtable;

public final class CustomProperties {
    private static final TraceComponent tc = SibTr.register(CustomProperties.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private int _searchResultsPoolSize = 20;
    private long _anycast_batch_timeout = 0L;
    private int _anycast_batch_size = 0;
    private long _anycast_lock_batch_timeout = 0L;
    private int _anycast_lock_batch_size = 0;
    private int _max_consumer_threadpool_size = 100;
    private int _max_system_threadpool_size = 5;
    private int _max_reconstitute_threadpool_size = Runtime.getRuntime().availableProcessors();
    private long _browse_expiry_timeout = 10000L;
    private long _browse_liveness_timeout = 9000L;
    private long _browse_get_timeout = 4000L;
    private long _init_repetition_interval = 3000L;
    private long _reset_repetition_interval = 3000L;
    private long _decision_expected_repetition_interval = 5000L;
    private long _sender_inactivity_timeout = 5000L;
    private long _eager_get_request_interval = 5000L;
    private long _accept_initial_threshold = 500L;
    private long _accept_repetition_interval = 5000L;
    private long _reject_repetition_interval = 5000L;
    private long _create_stream_repetition_interval = 5000L;
    private long _init_round_trip_time = 2000L;
    private long _unlocked_reject_interval = 3000L;
    private int _max_prefetch_window = 20;
    private long _ck_idle_timeout = 5000L;
    private long _message_wait_time_granularity = 500L;
    private boolean _multicastEnabled = false;
    private String _multicastGroupAddress = "234.6.17.92";
    private String _multicastInterfaceAddress = "none";
    private int _multicastPort = 34343;
    private int _multicastPacketSize = 7000;
    private int _multicastTTL = 1;
    private boolean _multicastUseReliableRMM = true;
    private long _target_batch_timeout = 100L;
    private int _target_batch_size = 10;
    private long _source_batch_timeout = 100L;
    private int _source_batch_size = 10;
    private long _round_trip_time_low_limit = 50L;
    private long _remote_consumer_cardinality_inactivity_interval = 20000L;
    private long _blocked_retry_timeout = 5000L;
    private long _pending_retry_timeout = 5000L;
    private int _definedSendWindow = 50;
    private double _remote_queue_high_percentage_excess = 0.1;
    private double _dest_low_unset_percentage_decrease = 0.1;
    private long _message_reference_expiry_value = 10000L;
    private Boolean _force_pev = null;
    private long _unknown_prev_tick = -1L;
    private long _infinite_timeout = -1L;
    private long _slowed_get_request_interval = 10L * this._eager_get_request_interval;
    private long _round_trip_time_high_limit = 30000L;
    private int _max_interval_for_prefetch = (int)(0.75 * (double)this._unlocked_reject_interval);
    private double _min_prefetch_size = 0.25;
    private int _max_frp_depth = 20;
    private long _restore_repetition_interval = 1000L;
    private volatile long _request_flush_repetition_interval = 5000L;
    private volatile long _request_flush_slow_repetition_interval = 120000L;
    private int _gathering_local_weighting = 80;
    private long _gathering_reattach_interval = 5000L;
    private int BLOCKED_STREAM_INTERVAL = 60000;
    private int BLOCKED_STREAM_CHECK_INTERVAL = 10000;
    private int BLOCKED_STREAM_RATIO = this.BLOCKED_STREAM_INTERVAL / this.BLOCKED_STREAM_CHECK_INTERVAL;
    private boolean OUTPUT_LINK_THRESHOLD_EVENTS_TO_LOG = true;
    private boolean OUTPUT_DESTINATION_THRESHOLD_EVENTS_TO_LOG = true;
    private int LOG_ALL_MESSAGE_DEPTH_INTERVALS = 0;
    private Hashtable<String, Long> _logMessageDepthIntervals = new Hashtable();
    private long NACK_LOG_INTERVAL = 0L;
    private int REPEATED_VALUE_PERCENTAGE = 0;
    private int REPEATED_VALUE_INTERVAL = 2000;
    private int GD_GAP_CURIOSITY_THRESHOLD = 200;
    public int MSG_BLOCK_WARNING_REPEAT_INTERVAL = 300;

    public void setProperty(String key, String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setProperty", (Object)("key=" + key + ",value=" + value));
        }
        try {
            if (key.equals("sib.processor.searchResultsPoolSize")) {
                this._searchResultsPoolSize = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.anycastLockBatchTimeout")) {
                this._anycast_lock_batch_timeout = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.anycastLockBatchSize")) {
                this._anycast_lock_batch_size = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.anycastBatchTimeout")) {
                this._anycast_batch_timeout = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.anycastBatchSize")) {
                this._anycast_batch_size = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.maxThreadPoolSize")) {
                this._max_consumer_threadpool_size = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.maxSystemThreadPoolSize")) {
                this._max_system_threadpool_size = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.maxReconstituteThreadpoolSize")) {
                this._max_reconstitute_threadpool_size = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.browseExpiryTimeout")) {
                this._browse_expiry_timeout = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.browseLivenessTimeout")) {
                this._browse_liveness_timeout = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.browseGetTimeout")) {
                this._browse_get_timeout = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.initRepetitionInterval")) {
                this._init_repetition_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.resetRepetitionInterval")) {
                this._reset_repetition_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.decisionExpectedRepetitionInterval")) {
                this._decision_expected_repetition_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.senderInactivityTimeout")) {
                this._sender_inactivity_timeout = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.eagerGetRequestInterval")) {
                this._eager_get_request_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.slowed_get_request_interval")) {
                this._slowed_get_request_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.acceptInitialThreshold")) {
                this._accept_initial_threshold = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.acceptRepetitionInterval")) {
                this._accept_repetition_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.rejectRepetitionInterval")) {
                this._reject_repetition_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.createStreamRepetitionInterval")) {
                this._create_stream_repetition_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.initRoundTripTime")) {
                this._init_round_trip_time = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.unlockedRejectInterval")) {
                this._unlocked_reject_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.maxPrefetchWindow")) {
                this._max_prefetch_window = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.idleTimeout")) {
                this._ck_idle_timeout = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.messageWaitTimeGranularity")) {
                this._message_wait_time_granularity = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("multicastEnabled")) {
                this._multicastEnabled = Boolean.valueOf(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("multicastInterface")) {
                this._multicastInterfaceAddress = value;
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("multicastPort")) {
                this._multicastPort = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("multicastPacketSize")) {
                this._multicastPacketSize = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("multicastTTL")) {
                this._multicastTTL = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("multicastGroupAddress")) {
                this._multicastGroupAddress = value;
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("multicastUseReliableRMM")) {
                this._multicastUseReliableRMM = Boolean.valueOf(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.targetBatchTimeout")) {
                this._target_batch_timeout = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.targetBatchSize")) {
                this._target_batch_size = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.sourceBatchTimeout")) {
                this._source_batch_timeout = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.sourceBatchSize")) {
                this._source_batch_size = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.roundTripTimeLowLimit")) {
                this._round_trip_time_low_limit = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.remoteConsumerInactivityTimeout")) {
                this._remote_consumer_cardinality_inactivity_interval = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.remoteConsumerTransmitterInactivityTimeout")) {
                this._sender_inactivity_timeout = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.blockedRetryTimeout")) {
                this._blocked_retry_timeout = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.pendingRetryTimeout")) {
                long pendingRetryTimeout = Long.parseLong(value);
                if (pendingRetryTimeout > 0L) {
                    this._pending_retry_timeout = pendingRetryTimeout;
                    com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
                }
            } else if (key.equals("sib.processor.protocolSendWindow")) {
                this._definedSendWindow = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.remoteTopicSpaceHighExcess")) {
                double remoteQueueHighExcess = Double.parseDouble(value);
                if (remoteQueueHighExcess >= 0.0) {
                    this._remote_queue_high_percentage_excess = remoteQueueHighExcess;
                    com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
                }
            } else if (key.equals("sib.processor.destLowUnsetPercentageDecrease")) {
                double destQueueLowDecrease = Double.parseDouble(value);
                if (destQueueLowDecrease >= 0.0 && destQueueLowDecrease < 1.0) {
                    this._dest_low_unset_percentage_decrease = destQueueLowDecrease;
                    com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
                }
            } else if (key.equals("sib.processor.maxForwardRoutingPathDepth")) {
                this._max_frp_depth = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.messageCacheTimeout")) {
                this._message_reference_expiry_value = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.forcePEV")) {
                this._force_pev = Boolean.parseBoolean(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.minPrefetchSsize")) {
                this._min_prefetch_size = Double.parseDouble(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.maxIntervalForPrefetch")) {
                this._max_interval_for_prefetch = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.roundTripTimeHighLimit")) {
                this._round_trip_time_high_limit = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.infiniteTimeout")) {
                this._infinite_timeout = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.unknownPrevTick")) {
                this._unknown_prev_tick = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.anycastRequestFlushRepetitionInterval")) {
                this._request_flush_repetition_interval = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.anycastRequestFlushSlowRepetitionInterval")) {
                this._request_flush_slow_repetition_interval = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.gatheringLocalPercentage")) {
                this._gathering_local_weighting = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.gatheringReattachInterval")) {
                this._gathering_reattach_interval = Long.parseLong(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.blockedCommittingMessageInterval")) {
                this.BLOCKED_STREAM_INTERVAL = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
                if (this.BLOCKED_STREAM_INTERVAL > 10000) {
                    this.BLOCKED_STREAM_RATIO = Math.round((float)this.BLOCKED_STREAM_INTERVAL / 10000.0f);
                    this.BLOCKED_STREAM_CHECK_INTERVAL = this.BLOCKED_STREAM_INTERVAL / this.BLOCKED_STREAM_RATIO;
                } else {
                    this.BLOCKED_STREAM_CHECK_INTERVAL = this.BLOCKED_STREAM_INTERVAL;
                    this.BLOCKED_STREAM_RATIO = 1;
                }
            } else if (key.equals("sib.processor.logDepthThresholdEvents")) {
                if (value.compareToIgnoreCase("links") == 0) {
                    this.OUTPUT_LINK_THRESHOLD_EVENTS_TO_LOG = true;
                    this.OUTPUT_DESTINATION_THRESHOLD_EVENTS_TO_LOG = false;
                    com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
                } else if (value.compareToIgnoreCase("on") == 0) {
                    this.OUTPUT_LINK_THRESHOLD_EVENTS_TO_LOG = true;
                    this.OUTPUT_DESTINATION_THRESHOLD_EVENTS_TO_LOG = true;
                    com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
                } else if (value.compareToIgnoreCase("off") == 0) {
                    this.OUTPUT_LINK_THRESHOLD_EVENTS_TO_LOG = false;
                    this.OUTPUT_DESTINATION_THRESHOLD_EVENTS_TO_LOG = false;
                    com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
                }
            } else if (key.equals("sib.processor.logAllMessageDepthIntervals")) {
                this.LOG_ALL_MESSAGE_DEPTH_INTERVALS = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.startsWith("sib.processor.logMessageDepthIntervals.")) {
                String destName = key.substring("sib.processor.logMessageDepthIntervals.".length());
                this._logMessageDepthIntervals.put(destName, new Long(value));
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.logUnresolvedGapsInTransmissionStreams")) {
                this.NACK_LOG_INTERVAL = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.repeatedMessagePercentage")) {
                this.REPEATED_VALUE_PERCENTAGE = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.repeatedMessageInterval")) {
                this.REPEATED_VALUE_INTERVAL = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.transmissionStreamGapEagerness")) {
                this.GD_GAP_CURIOSITY_THRESHOLD = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            } else if (key.equals("sib.processor.msgBlockWarningRepeatInterval")) {
                this.MSG_BLOCK_WARNING_REPEAT_INTERVAL = Integer.parseInt(value);
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)key, (String)value);
            }
        }
        catch (Exception e) {
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0008", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.CustomProperties.setProperty", "1:944:1.8.1.16", "(Key: " + key + " Value: " + value + ")", e});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setProperty");
        }
    }

    public int get_searchResultsPoolSize() {
        return this._searchResultsPoolSize;
    }

    public int get_anycast_lock_batch_size() {
        return this._anycast_lock_batch_size;
    }

    public long get_anycast_lock_batch_timeout() {
        return this._anycast_lock_batch_timeout;
    }

    public int get_anycast_batch_size() {
        return this._anycast_batch_size;
    }

    public long get_anycast_batch_timeout() {
        return this._anycast_batch_timeout;
    }

    public long get_blocked_retry_timeout() {
        return this._blocked_retry_timeout;
    }

    public long get_pending_retry_timeout() {
        return this._pending_retry_timeout;
    }

    public long get_infinite_timeout() {
        return this._infinite_timeout;
    }

    public long get_unlocked_reject_interval() {
        return this._unlocked_reject_interval;
    }

    public double get_dest_low_unset_percentage_decrease() {
        return this._dest_low_unset_percentage_decrease;
    }

    public double get_remote_queue_high_percentage_excess() {
        return this._remote_queue_high_percentage_excess;
    }

    public long get_create_stream_repetition_interval() {
        return this._create_stream_repetition_interval;
    }

    public long get_init_round_trip_time() {
        return this._init_round_trip_time;
    }

    public long get_sender_inactivity_timeout() {
        return this._sender_inactivity_timeout;
    }

    public long get_round_trip_time_low_limit() {
        return this._round_trip_time_low_limit;
    }

    public long get_round_trip_time_high_limit() {
        return this._round_trip_time_high_limit;
    }

    public long get_unknown_prev_tick() {
        return this._unknown_prev_tick;
    }

    public long get_eager_get_request_interval() {
        return this._eager_get_request_interval;
    }

    public long get_slowed_get_request_interval() {
        return this._slowed_get_request_interval;
    }

    public long get_accept_initial_threshold() {
        return this._accept_initial_threshold;
    }

    public long get_accept_repetition_interval() {
        return this._accept_repetition_interval;
    }

    public long get_reject_repetition_interval() {
        return this._reject_repetition_interval;
    }

    public long get_decision_expected_repetition_interval() {
        return this._decision_expected_repetition_interval;
    }

    public long get_init_repetition_interval() {
        return this._init_repetition_interval;
    }

    public long get_reset_repetition_interval() {
        return this._reset_repetition_interval;
    }

    public int get_max_interval_for_prefetch() {
        return this._max_interval_for_prefetch;
    }

    public int get_max_prefetch_window() {
        return this._max_prefetch_window;
    }

    public long get_remote_consumer_cardinality_inactivity_interval() {
        return this._remote_consumer_cardinality_inactivity_interval;
    }

    public long get_ck_idle_timeout() {
        return this._ck_idle_timeout;
    }

    public long get_message_wait_time_granularity() {
        return this._message_wait_time_granularity;
    }

    public long get_message_reference_expiry_value() {
        return this._message_reference_expiry_value;
    }

    public int get_max_frp_depth() {
        return this._max_frp_depth;
    }

    public long get_target_batch_timeout() {
        return this._target_batch_timeout;
    }

    public int get_target_batch_size() {
        return this._target_batch_size;
    }

    public long get_source_batch_timeout() {
        return this._source_batch_timeout;
    }

    public int get_source_batch_size() {
        return this._source_batch_size;
    }

    public int get_max_consumer_threadpool_size() {
        return this._max_consumer_threadpool_size;
    }

    public int get_max_system_threadpool_size() {
        return this._max_system_threadpool_size;
    }

    public int get_max_reconstitute_threadpool_size() {
        return this._max_reconstitute_threadpool_size;
    }

    public long get_browse_expiry_timeout() {
        return this._browse_expiry_timeout;
    }

    public long get_browse_liveness_timeout() {
        return this._browse_liveness_timeout;
    }

    public long get_browse_get_timeout() {
        return this._browse_get_timeout;
    }

    public boolean get_multicastEnabled() {
        return this._multicastEnabled;
    }

    public String get_multicastGroupAddress() {
        return this._multicastGroupAddress;
    }

    public String get_multicastInterfaceAddress() {
        return this._multicastInterfaceAddress;
    }

    public int get_multicastPort() {
        return this._multicastPort;
    }

    public int get_multicastPacketSize() {
        return this._multicastPacketSize;
    }

    public int get_multicastTTL() {
        return this._multicastTTL;
    }

    public boolean get_multicastUseReliableRMM() {
        return this._multicastUseReliableRMM;
    }

    public int get_definedSendWindow() {
        return this._definedSendWindow;
    }

    public Boolean get_force_pev() {
        return this._force_pev;
    }

    public double get_min_prefetch_size() {
        return this._min_prefetch_size;
    }

    public long get_restore_repetition_interval() {
        return this._restore_repetition_interval;
    }

    public long get_request_flush_repetition_interval() {
        return this._request_flush_repetition_interval;
    }

    public long get_request_flush_slow_repetition_interval() {
        return this._request_flush_slow_repetition_interval;
    }

    public int get_gathering_local_weighting() {
        return this._gathering_local_weighting;
    }

    public long get_gathering_reattach_interval() {
        return this._gathering_reattach_interval;
    }

    public int getBlockedStreamFirstReportInterval() {
        return this.BLOCKED_STREAM_INTERVAL;
    }

    public int getBlockedStreamHealthCheckInterval() {
        return this.BLOCKED_STREAM_CHECK_INTERVAL;
    }

    public int getBlockedStreamRatio() {
        return this.BLOCKED_STREAM_RATIO;
    }

    public boolean getOutputLinkThresholdEventsToLog() {
        return this.OUTPUT_LINK_THRESHOLD_EVENTS_TO_LOG;
    }

    public boolean getOutputDestinationThresholdEventsToLog() {
        return this.OUTPUT_DESTINATION_THRESHOLD_EVENTS_TO_LOG;
    }

    public int getLogAllMessageDepthIntervals() {
        return this.LOG_ALL_MESSAGE_DEPTH_INTERVALS;
    }

    public Hashtable<String, Long> getLogMessageDepthIntervalsTable() {
        return this._logMessageDepthIntervals;
    }

    public long getNackLogInterval() {
        return this.NACK_LOG_INTERVAL;
    }

    public int getRepeatedValuePercentage() {
        return this.REPEATED_VALUE_PERCENTAGE;
    }

    public int getRepeatedValueInterval() {
        return this.REPEATED_VALUE_INTERVAL;
    }

    public int getGapCuriosityThreshold() {
        return this.GD_GAP_CURIOSITY_THRESHOLD;
    }

    public int getMsgBlockWarningRepeat() {
        return this.MSG_BLOCK_WARNING_REPEAT_INTERVAL;
    }
}

