/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.pmi.server.data.SpdDataImpl;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.DoubleStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.wsspi.pmi.factory.StatisticActions;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class SpdStatisticExternal
extends SpdDataImpl {
    private static final long serialVersionUID = -7029239686912201805L;
    protected StatisticActions proxy;
    protected StatisticImpl onReqStatistic;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SpdStatisticExternal(PmiDataInfo dataInfo, StatisticActions proxy) {
        super(dataInfo.getId());
        this.proxy = proxy;
        int type = dataInfo.getType();
        switch (type) {
            case 2: {
                this.onReqStatistic = new CountStatisticImpl(this.dataId);
                break;
            }
            case 3: {
                this.onReqStatistic = new DoubleStatisticImpl(this.dataId);
                break;
            }
            case 4: {
                this.onReqStatistic = new TimeStatisticImpl(this.dataId);
                break;
            }
            case 6: {
                this.onReqStatistic = new AverageStatisticImpl(this.dataId);
                break;
            }
            case 7: {
                this.onReqStatistic = new RangeStatisticImpl(this.dataId);
                break;
            }
            case 5: {
                this.onReqStatistic = new BoundedRangeStatisticImpl(this.dataId);
                break;
            }
            default: {
                System.out.println("[SpdStatisticExternal] Invalid statistic type");
            }
        }
    }

    @Override
    public StatisticImpl getStatistic() {
        if (this.enabled) {
            if (this.proxy == null) {
                System.out.println("[SpdStatisticExternal] null proxy");
                return null;
            }
            this.proxy.updateStatisticOnRequest(this.dataId);
            return this.onReqStatistic;
        }
        return null;
    }

    @Override
    public void reset(boolean resetAll) {
    }

    public StatisticImpl getStatisticRef() {
        return this.onReqStatistic;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public void updateExternal() {
        this.proxy.updateStatisticOnRequest(this.dataId);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SpdStatisticExternal.class);
    }
}

