/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.csi;

import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.yoko.orb.csi.AuthenticationInfo;
import org.apache.yoko.orb.csi.CSIInterceptorBase;
import org.apache.yoko.orb.csi.SecurityContext;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.GSSUP.InitialContextToken;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public class CSIClientRequestInterceptor
extends CSIInterceptorBase
implements ClientRequestInterceptor {
    private static final Logger log = Logger.getLogger(CSIClientRequestInterceptor.class.getName());

    CSIClientRequestInterceptor(Codec codec) {
        super(codec);
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        Object target = ri.effective_target();
        if (target instanceof ObjectImpl) {
            boolean isLocal = ((ObjectImpl)target)._is_local();
            if (ri.response_expected()) {
                CSIInterceptorBase.CallStatus.pushIsLocal(isLocal);
            }
            if (isLocal) {
                return;
            }
        }
        boolean target_supports_gssup = false;
        boolean target_requires_gssup = false;
        CompoundSecMech mech = null;
        try {
            TaggedComponent tc = ri.get_effective_component(33);
            byte[] data = tc.component_data;
            Any sl_any = this.codec.decode_value(data, CompoundSecMechListHelper.type());
            CompoundSecMechList sl = CompoundSecMechListHelper.extract((Any)sl_any);
            if (sl.mechanism_list.length == 0) {
                log.fine("empty sec mech list");
                return;
            }
            mech = sl.mechanism_list[0];
        }
        catch (BAD_PARAM ex) {
            log.fine("no security mechanism");
            return;
        }
        catch (UserException e) {
            MARSHAL me = new MARSHAL("cannot decode local security descriptor", 0, CompletionStatus.COMPLETED_NO);
            me.initCause((Throwable)e);
            throw me;
        }
        log.fine("transport_mech tag = " + mech.transport_mech.tag);
        String target_name = null;
        AS_ContextSec as = mech.as_context_mech;
        if (as != null && Arrays.equals(GSSUP_OID, as.client_authentication_mech)) {
            target_requires_gssup = (as.target_requires & 0x40) != 0;
            target_supports_gssup = (as.target_supports & 0x40) != 0;
            target_name = this.decodeGSSExportedName(as.target_name);
            log.fine("decoded target name = " + target_name);
        }
        boolean support_gssup_delegation = false;
        boolean support_x500_delegation = false;
        if (!target_supports_gssup) {
            SAS_ContextSec sas = mech.sas_context_mech;
            for (int i = 0; i < sas.supported_naming_mechanisms.length; ++i) {
                if (!Arrays.equals(GSSUP_OID, sas.supported_naming_mechanisms[i]) || (sas.supported_identity_types & 2) == 0) continue;
                support_gssup_delegation = true;
                log.fine("target supports GSSUP identity delegation");
                break;
            }
            if ((sas.supported_identity_types & 8) != 0) {
                support_x500_delegation = true;
            }
            if (!support_gssup_delegation && !support_x500_delegation) {
                log.fine("target supports security, but not GSSUP/X500");
                return;
            }
        } else {
            log.fine("AS SPEC: target_supports=" + target_supports_gssup + " target_requires=" + target_requires_gssup);
        }
        AuthenticationInfo authInfo = SecurityContext.getAuthenticationInfo();
        if (authInfo == null) {
            log.fine("no auth info");
            return;
        }
        String name = authInfo.getPrincipalName();
        String realm = authInfo.getRealm();
        String password = authInfo.getPassword();
        SASContextBody sasBody = new SASContextBody();
        EstablishContext establishMsg = new EstablishContext();
        establishMsg.client_context_id = 0L;
        establishMsg.authorization_token = EMPTY_AUTH_ELEMENT;
        String scopedUserName = name + "@" + realm;
        if (support_gssup_delegation) {
            establishMsg.client_authentication_token = EMPTY_BARR;
            IdentityToken identityToken = new IdentityToken();
            identityToken.principal_name(this.encapsulateByteArray(this.encodeGSSExportedName(scopedUserName)));
            establishMsg.identity_token = identityToken;
            log.fine("send_request, name: \"" + scopedUserName + "\"");
        } else {
            InitialContextToken gssupToken = new InitialContextToken();
            gssupToken.username = this.utf8encode(scopedUserName);
            gssupToken.target_name = this.encodeGSSExportedName(realm);
            gssupToken.password = this.utf8encode(password);
            establishMsg.client_authentication_token = this.encodeGSSUPToken(gssupToken);
            IdentityToken identityToken = new IdentityToken();
            identityToken.absent(true);
            establishMsg.identity_token = identityToken;
            log.fine("send_request, name: \"" + scopedUserName + "\", pw: \"" + password + "\"");
        }
        sasBody.establish_msg(establishMsg);
        ri.add_request_service_context(this.encodeSASContextBody(sasBody), true);
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
        ServiceContext serviceContext;
        if (CSIInterceptorBase.CallStatus.popIsLocal()) {
            return;
        }
        try {
            serviceContext = ri.get_reply_service_context(15);
        }
        catch (BAD_PARAM ex) {
            serviceContext = null;
        }
        SASContextBody sasBody = null;
        if (serviceContext != null) {
            sasBody = this.decodeSASContextBody(serviceContext);
            switch (sasBody.discriminator()) {
                case 0: 
                case 5: {
                    log.severe("Unexpected message of type " + sasBody.discriminator());
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        log.fine("receive_exception");
        this.receive_reply(ri);
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
        log.fine("receive_other");
        this.receive_reply(ri);
    }

    public String name() {
        return "CSI Client Interceptor";
    }

    public void destroy() {
    }
}

