/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.net.Socket;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Net;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.IIOP.ConnectorInfo_impl;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.TransportInfo;
import org.apache.yoko.orb.OCI.IIOP.Transport_impl;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.BiDirPolicy.BidirectionalPolicyHelper;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.ServiceContext;

public final class TransportInfo_impl
extends LocalObject
implements TransportInfo {
    private final Socket socket;
    private final Origin origin;
    private final ListenerMap listenMap_;
    private volatile ListenPoint[] listenPoints_ = null;

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public short origin() {
        return this.origin.value;
    }

    @Override
    public synchronized String describe() {
        String desc = "id: iiop";
        String localAddr = this.addr();
        int localPort = this.port();
        desc = desc + "\nlocal address: ";
        desc = desc + localAddr;
        desc = desc + ":";
        desc = desc + (localPort < 0 ? 65535 + localPort + 1 : localPort);
        String remoteAddr = this.remote_addr();
        int remotePort = this.remote_port();
        desc = desc + "\nremote address: ";
        desc = desc + remoteAddr;
        desc = desc + ":";
        desc = desc + (remotePort < 0 ? 65535 + remotePort + 1 : remotePort);
        return desc;
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public String addr() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    @Override
    public short port() {
        return (short)this.socket.getLocalPort();
    }

    @Override
    public String remote_addr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    @Override
    public short remote_port() {
        return (short)this.socket.getPort();
    }

    @Override
    public ServiceContext[] get_service_contexts(Policy[] policies) {
        boolean bHaveBidir = false;
        for (Policy policy : policies) {
            if (policy.policy_type() != 37) continue;
            BidirectionalPolicy p = BidirectionalPolicyHelper.narrow((Object)policy);
            if (p.value() != 1) break;
            bHaveBidir = true;
            break;
        }
        if (bHaveBidir) {
            BiDirIIOPServiceContext biDirCtxt = new BiDirIIOPServiceContext();
            biDirCtxt.listen_points = this.listenMap_.getListenPoints();
            Buffer buf = new Buffer();
            OutputStream out = new OutputStream(buf);
            out._OB_writeEndian();
            BiDirIIOPServiceContextHelper.write((org.omg.CORBA.portable.OutputStream)out, (BiDirIIOPServiceContext)biDirCtxt);
            ServiceContext context = new ServiceContext();
            context.context_id = 5;
            context.context_data = buf.data();
            ServiceContext[] scl = new ServiceContext[]{context};
            return scl;
        }
        ServiceContext[] scl = new ServiceContext[]{};
        return scl;
    }

    @Override
    public void handle_service_contexts(ServiceContext[] contexts) {
        for (ServiceContext context : contexts) {
            if (context.context_id != 5) continue;
            byte[] pOct = context.context_data;
            int len = context.context_data.length;
            Buffer buf = new Buffer(pOct, len);
            InputStream in = new InputStream(buf, 0, false);
            in._OB_readEndian();
            BiDirIIOPServiceContext biDirCtxt = BiDirIIOPServiceContextHelper.read((org.omg.CORBA.portable.InputStream)in);
            this._OB_setListenPoints(biDirCtxt.listen_points);
            break;
        }
    }

    @Override
    public synchronized boolean received_bidir_SCL() {
        return this.listenPoints_ != null && this.listenPoints_.length > 0;
    }

    @Override
    public synchronized boolean endpoint_alias_match(ConnectorInfo connInfo) {
        ConnectorInfo_impl infoImpl;
        try {
            infoImpl = (ConnectorInfo_impl)connInfo;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (this.listenPoints_ == null) {
            return false;
        }
        short port = infoImpl.remote_port();
        String host = infoImpl.remote_addr();
        for (ListenPoint aListenPoints_ : this.listenPoints_) {
            if (aListenPoints_.port != port || !Net.CompareHosts(aListenPoints_.host, host)) continue;
            return true;
        }
        return false;
    }

    public synchronized ListenPoint[] _OB_getListenPoints() {
        return this.listenPoints_;
    }

    public synchronized void _OB_setListenPoints(ListenPoint[] lp) {
        this.listenPoints_ = lp;
    }

    private TransportInfo_impl(Socket socket, Origin origin, ListenerMap lm) {
        this.socket = socket;
        this.origin = origin;
        this.listenMap_ = lm;
    }

    TransportInfo_impl(Transport_impl transport, ListenerMap lm) {
        this(transport.socket_, Origin.CLIENT, lm);
    }

    TransportInfo_impl(Transport_impl transport, Acceptor acceptor, ListenerMap lm) {
        this(transport.socket_, Origin.SERVER, lm);
    }

    private static enum Origin {
        CLIENT(0),
        SERVER(1);

        final short value;

        private Origin(int v) {
            this.value = (short)v;
        }
    }
}

