/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.unbound;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.context.DependentContext;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.injection.producer.AbstractMemberProducer;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.serialization.spi.ContextualStore;

public class DependentContextImpl
implements DependentContext {
    private final ContextualStore contextualStore;

    public DependentContextImpl(ContextualStore contextualStore) {
        this.contextualStore = contextualStore;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (creationalContext != null) {
            Object instance = contextual.create(creationalContext);
            if (creationalContext instanceof WeldCreationalContext) {
                this.addDependentInstance(instance, contextual, (WeldCreationalContext)creationalContext);
            }
            return (T)instance;
        }
        return null;
    }

    protected <T> void addDependentInstance(T instance, Contextual<T> contextual, WeldCreationalContext<T> creationalContext) {
        if (creationalContext.getDependentInstances().isEmpty()) {
            AbstractMemberProducer producer;
            AbstractProducerBean producerBean;
            BasicInjectionTarget injectionTarget;
            ManagedBean managedBean;
            if (contextual instanceof ManagedBean && !this.isInterceptorOrDecorator(contextual) && (managedBean = (ManagedBean)contextual).getProducer() instanceof BasicInjectionTarget && !(injectionTarget = (BasicInjectionTarget)managedBean.getProducer()).getLifecycleCallbackInvoker().hasPreDestroyMethods() && !injectionTarget.hasInterceptors()) {
                return;
            }
            if (contextual instanceof AbstractProducerBean && (producerBean = (AbstractProducerBean)contextual).getProducer() instanceof AbstractMemberProducer && (producer = (AbstractMemberProducer)producerBean.getProducer()).getDisposalMethod() == null) {
                return;
            }
            if (this.isOptimizableBuiltInBean(contextual)) {
                return;
            }
        }
        SerializableContextualInstanceImpl<Contextual<T>, T> beanInstance = new SerializableContextualInstanceImpl<Contextual<T>, T>(contextual, instance, creationalContext, this.contextualStore);
        creationalContext.addDependentInstance(beanInstance);
    }

    private boolean isInterceptorOrDecorator(Contextual<?> contextual) {
        return contextual instanceof Interceptor || contextual instanceof Decorator;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return true;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public void destroy(Contextual<?> contextual) {
        throw new UnsupportedOperationException();
    }

    private boolean isOptimizableBuiltInBean(Contextual<?> contextual) {
        if (contextual instanceof AbstractBuiltInBean) {
            AbstractBuiltInBean abstractBuiltInBean = (AbstractBuiltInBean)contextual;
            return abstractBuiltInBean.isDependentContextOptimizationAllowed();
        }
        return false;
    }
}

