/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.ssh;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGeneratorImpl;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyPair;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SSHKeyUtilityImpl
implements SSHKeyUtility {
    private static final TraceComponent tc = Tr.register(SSHKeyUtilityImpl.class);
    public static final String DIR_SSH = ".ssh";
    public static final String FILE_AUTHORIZED_KEYS = "authorized_keys";
    private static final String CP1047_ENCODING = "Cp1047";
    private static String LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){
        static final long serialVersionUID = 1105686949376067619L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    });
    static final long serialVersionUID = 6434751352298290834L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void writeKeyToFile(@Sensitive String key, File file) throws IOException {
        OutputStreamWriter out = null;
        try {
            if (!AccessController.doPrivileged(new MKDirsAction(file.getParentFile())).booleanValue()) {
                throw new IOException("Unable to create all of the required parent directories for the key file: " + file.getAbsolutePath());
            }
            try {
                if (!AccessController.doPrivileged(new CreateAndSetKeyFilePermsAction(file)).booleanValue()) {
                    throw new IOException("Unable to set the permissions for the key file: " + file.getAbsolutePath());
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                Object[] objectArray = new Object[2];
                objectArray[0] = "<sensitive java.lang.String>";
                objectArray[1] = file;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl", (String)"171", (Object)this, (Object[])objectArray);
                Exception wrapped = e.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught PrivilegedActionException during CreateAndSetKeyFilePermsAction. Dumping wrapped exception...", (Object[])new Object[]{wrapped});
                }
                if (wrapped instanceof IOException) {
                    throw (IOException)wrapped;
                }
                throw new IOException("Unexpected exception thrown", wrapped);
            }
            out = this.getWriter(file, false);
            if (out != null) {
                out.write(key);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Successfully wrote key to file " + file.getAbsolutePath()), (Object[])new Object[0]);
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private SSHKeyPair generateKeys(String publicKeyComment, File publicKeyFile, File privateKeyFile) throws NoSuchAlgorithmException, IOException {
        long start = System.nanoTime();
        Tr.info((TraceComponent)tc, (String)"SSH_KEY_GENERATION_START", (Object[])new Object[0]);
        SSHKeyGeneratorImpl keyGenerator = new SSHKeyGeneratorImpl();
        SSHKeyPair generatedKeys = keyGenerator.generate(publicKeyComment);
        String publicKey = generatedKeys.getPublickKey();
        String privateKey = generatedKeys.getPrivatekey();
        this.writeKeyToFile(publicKey, publicKeyFile);
        this.writeKeyToFile(privateKey, privateKeyFile);
        Tr.info((TraceComponent)tc, (String)"SSH_KEY_GENERATION_END", (Object[])new Object[]{TimestampUtils.getElapsedTimeNanos((long)start)});
        return generatedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Sensitive
    public String readStringFromFile(File file) throws IOException {
        InputStreamReader reader = this.getReader(file);
        if (reader == null) {
            return null;
        }
        StringBuilder contents = new StringBuilder();
        char[] buffer = new char[4096];
        int read = 0;
        try {
            do {
                contents.append(buffer, 0, read);
            } while ((read = reader.read(buffer)) >= 0);
        }
        finally {
            reader.close();
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendPublicKeyToAuthorizedKeys(String publicKeyString, File fAuthorizedkeys) throws IOException {
        OutputStreamWriter out = null;
        try {
            boolean hasTrailingLineFeed = this.hasTrailingLineFeed(fAuthorizedkeys);
            out = this.getWriter(fAuthorizedkeys, true);
            if (out != null) {
                if (!hasTrailingLineFeed) {
                    out.write(LINE_SEPARATOR);
                }
                out.write(publicKeyString);
                out.write(LINE_SEPARATOR);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateAuthorizedKeys(String homeDir, String publicKeyString) throws IOException, FileNotFoundException {
        File fAuthorizedkeys = new File(new File(homeDir, DIR_SSH).getCanonicalFile(), FILE_AUTHORIZED_KEYS);
        Boolean exists = AccessController.doPrivileged(new FileExistsAction(fAuthorizedkeys));
        if (exists.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("reading authorized_keys from " + fAuthorizedkeys.getAbsolutePath()), (Object[])new Object[0]);
            }
            BufferedReader in = new BufferedReader(new FileReader(fAuthorizedkeys));
            try {
                String str;
                while ((str = in.readLine()) != null) {
                    if (str.indexOf(publicKeyString) != 0) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The public key already exists in file " + fAuthorizedkeys.getAbsolutePath()), (Object[])new Object[0]);
                    }
                    return;
                }
            }
            finally {
                in.close();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("File " + fAuthorizedkeys.getAbsolutePath() + " doesn't exist, it will be created"), (Object[])new Object[0]);
        }
        if (!AccessController.doPrivileged(new MKDirsAction(fAuthorizedkeys.getParentFile())).booleanValue()) {
            throw new IOException("Unable to create all of the required parent directories for the file: " + fAuthorizedkeys.getAbsolutePath());
        }
        try {
            if (!AccessController.doPrivileged(new CreateAndSetKeyFilePermsAction(fAuthorizedkeys)).booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CreateAndSetKeyFilePermsAction did not complete successfully.", (Object[])new Object[0]);
                }
                throw new IOException("Unable to set the permissions for the file: " + fAuthorizedkeys.getAbsolutePath());
            }
        }
        catch (PrivilegedActionException in) {
            void e;
            FFDCFilter.processException((Throwable)in, (String)"com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl", (String)"318", (Object)this, (Object[])new Object[]{homeDir, publicKeyString});
            Exception wrapped = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught PrivilegedActionException during CreateAndSetKeyFilePermsAction. Dumping wrapped exception...", (Object[])new Object[]{wrapped});
            }
            if (wrapped instanceof IOException) {
                throw (IOException)wrapped;
            }
            throw new IOException("Unexpected exception thrown", wrapped);
        }
        this.appendPublicKeyToAuthorizedKeys(publicKeyString, fAuthorizedkeys);
    }

    @Override
    @Sensitive
    public String useSSHKeyPair(String serverName, String homeDir, String publicKeyPathName, String privateKeyPathName) throws NoSuchAlgorithmException, IOException {
        File publicKeyFile = null;
        File privateKeyFile = null;
        boolean publicKeyFileIsFile = false;
        boolean privateKeyFileIsFile = false;
        if (privateKeyPathName != null) {
            privateKeyFile = new File(privateKeyPathName);
            boolean isPrivateKeyFileExist = this.isFileExist(privateKeyFile);
            if (!isPrivateKeyFileExist && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("File " + privateKeyPathName + " does not exist."), (Object[])new Object[0]);
            }
            privateKeyFileIsFile = AccessController.doPrivileged(new IsFileAction(privateKeyFile));
        }
        if (publicKeyPathName != null) {
            publicKeyFile = new File(publicKeyPathName);
            boolean isPublicKeyFileExist = this.isFileExist(publicKeyFile);
            if (!isPublicKeyFileExist && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("File " + publicKeyPathName + " does not exist."), (Object[])new Object[0]);
            }
            publicKeyFileIsFile = AccessController.doPrivileged(new IsFileAction(publicKeyFile));
        }
        String publicKeyString = null;
        String privateKeyString = null;
        if (privateKeyFileIsFile && publicKeyPathName == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Only private key was specified, reading available private key", (Object[])new Object[0]);
            }
            privateKeyString = this.readStringFromFile(privateKeyFile);
        } else if (privateKeyFileIsFile & !publicKeyFileIsFile) {
            Tr.warning((TraceComponent)tc, (String)"SSH_KEYGEN_PUB_DOESNT_EXIST", (Object[])new Object[]{publicKeyPathName});
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Both private key and public key were specified, but public key does not exist. Reading available private key", (Object[])new Object[0]);
            }
            privateKeyString = this.readStringFromFile(privateKeyFile);
        } else if (privateKeyFileIsFile && publicKeyFileIsFile) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Both key files are exist, reading available public and private keys", (Object[])new Object[0]);
            }
            publicKeyString = this.readStringFromFile(publicKeyFile);
            privateKeyString = this.readStringFromFile(privateKeyFile);
        } else {
            if (!privateKeyFileIsFile && publicKeyPathName == null) {
                Tr.error((TraceComponent)tc, (String)"SSH_KEYGEN_PRIV_DOESNT_EXIST", (Object[])new Object[]{privateKeyPathName});
                throw new IllegalStateException("SSH private key file does not exist or is not a regular file. No corresponding public key path specified, so can not generate key pair. SSH private key path: " + privateKeyPathName);
            }
            if (!privateKeyFileIsFile && !publicKeyFileIsFile) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"The key files do not exist or are not files, key generation is required.", (Object[])new Object[0]);
                }
                SSHKeyPair generatedKeys = this.generateKeys(serverName, publicKeyFile, privateKeyFile);
                publicKeyString = generatedKeys.getPublickKey();
                privateKeyString = generatedKeys.getPrivatekey();
            } else {
                if (!privateKeyFileIsFile && publicKeyFileIsFile) {
                    Tr.error((TraceComponent)tc, (String)"SSH_KEYGEN_INCOMPELTE_KEY_PAIR", (Object[])new Object[]{privateKeyPathName});
                    throw new IllegalStateException("SSH private key file does not exist or is not a regualr file. The specific public key exists, so we seem to have an incomplete key pair. SSH private key path: " + privateKeyPathName);
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"This scenario should never be hit. If it is, then we're in a really funky state.", (Object[])new Object[0]);
                }
            }
        }
        if (publicKeyString != null) {
            this.updateAuthorizedKeys(homeDir, publicKeyString);
        }
        return PasswordUtil.passwordEncode((String)privateKeyString);
    }

    private boolean isFileExist(File file) {
        return file.exists();
    }

    private OutputStreamWriter getWriter(File filename, boolean append) {
        final File finalFilename = filename;
        final boolean finalAppend = append;
        return AccessController.doPrivileged(new PrivilegedAction<OutputStreamWriter>(){
            static final long serialVersionUID = 4377528590947148618L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public OutputStreamWriter run() {
                block5: {
                    try {
                        if (System.getProperty("os.name").equalsIgnoreCase("z/OS")) {
                            return new OutputStreamWriter((OutputStream)new FileOutputStream(finalFilename, finalAppend), SSHKeyUtilityImpl.CP1047_ENCODING);
                        }
                        return new OutputStreamWriter(new FileOutputStream(finalFilename, finalAppend));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl$2", (String)"455", (Object)this, (Object[])new Object[0]);
                        if (tc.isDebugEnabled()) {
                            void e;
                            Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                    catch (FileNotFoundException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl$2", (String)"459", (Object)this, (Object[])new Object[0]);
                        Tr.error((TraceComponent)tc, (String)"SSH_KEYGEN_IOEXCEPTION", (Object[])new Object[]{e.getLocalizedMessage()});
                        if (!tc.isDebugEnabled()) break block5;
                        Tr.debug((TraceComponent)tc, (String)("Unable to write SSH keys. Caught IOException: " + e.getMessage()), (Object[])new Object[]{e});
                    }
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
    }

    private InputStreamReader getReader(File filename) throws UnsupportedEncodingException, FileNotFoundException {
        final File finalFilename = filename;
        return AccessController.doPrivileged(new PrivilegedAction<InputStreamReader>(){
            static final long serialVersionUID = -190976199676040067L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public InputStreamReader run() {
                block5: {
                    try {
                        if (System.getProperty("os.name").equalsIgnoreCase("z/OS")) {
                            return new InputStreamReader((InputStream)new FileInputStream(finalFilename), SSHKeyUtilityImpl.CP1047_ENCODING);
                        }
                        return new InputStreamReader(new FileInputStream(finalFilename));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl$3", (String)"482", (Object)this, (Object[])new Object[0]);
                        if (tc.isDebugEnabled()) {
                            void e;
                            Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                    catch (FileNotFoundException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl$3", (String)"486", (Object)this, (Object[])new Object[0]);
                        Tr.error((TraceComponent)tc, (String)"SSH_KEYGEN_IOEXCEPTION", (Object[])new Object[]{e.getLocalizedMessage()});
                        if (!tc.isDebugEnabled()) break block5;
                        Tr.debug((TraceComponent)tc, (String)("Unable to read SSH keys. Caught IOException: " + e.getMessage()), (Object[])new Object[]{e});
                    }
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTrailingLineFeed(File f) throws IOException {
        InputStreamReader isr = null;
        char[] buf = new char[1024];
        int numRead = 0;
        boolean match = false;
        int lineFeed = 10;
        int b = 120;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
            while ((numRead = isr.read(buf)) != -1) {
                b = (byte)buf[numRead - 1];
            }
            match = b == lineFeed;
            isr.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl", (String)"514", (Object)this, (Object[])new Object[]{f});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to create a file reader for file " + f.getAbsolutePath()), (Object[])new Object[0]);
            }
        }
        finally {
            if (isr != null) {
                isr.close();
            }
        }
        return match;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class IsFileAction
    implements PrivilegedAction<Boolean> {
        private final File file;
        static final long serialVersionUID = -9099839660763146916L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public IsFileAction(File f) {
            this.file = f;
        }

        @Override
        public Boolean run() {
            return this.file.isFile();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(IsFileAction.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class CreateAndSetKeyFilePermsAction
    implements PrivilegedExceptionAction<Boolean> {
        private final File file;
        static final long serialVersionUID = -4988951263011546410L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CreateAndSetKeyFilePermsAction(File f) {
            this.file = f;
        }

        @Override
        public Boolean run() throws IOException {
            if (this.file.exists()) {
                return true;
            }
            boolean lastOp = this.file.createNewFile();
            if (!lastOp && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to create new, empty file: " + this.file.getAbsolutePath()), (Object[])new Object[0]);
            }
            FileUtils.setUserReadWriteOnly((File)this.file);
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CreateAndSetKeyFilePermsAction.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class MKDirsAction
    implements PrivilegedAction<Boolean> {
        private final File file;
        static final long serialVersionUID = -2406076591706708457L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public MKDirsAction(File f) {
            this.file = f;
        }

        @Override
        public Boolean run() {
            if (this.file.exists()) {
                return true;
            }
            return this.file.mkdirs();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MKDirsAction.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class FileExistsAction
    implements PrivilegedAction<Boolean> {
        private final File file;
        static final long serialVersionUID = -4002194653630617941L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FileExistsAction(File f) {
            this.file = f;
        }

        @Override
        public Boolean run() {
            return this.file.exists();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FileExistsAction.class);
        }
    }
}

