/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.member.internal.HostAuthConfig;
import com.ibm.ws.collective.member.internal.publisher.HostNameUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={HostAuthConfig.class}, configurationPid={"com.ibm.ws.management.repository.member.hostAuthInfo"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class HostAuthConfigImpl
implements HostAuthConfig {
    private static final TraceComponent tc = Tr.register(HostAuthConfigImpl.class);
    static final Integer DEFAULT_SSH_PORT = 22;
    static final String INTERNAL_KEY_DEFAULT_SSH_PUBLIC_KEY_PATH = "defaultSSHPublicKeyPath";
    static final String INTERNAL_KEY_DEFAULT_SSH_PRIVATE_KEY_PATH = "defaultSSHPrivateKeyPath";
    private static final List<String> EXPECTED_KEYS = new ArrayList<String>(Arrays.asList("rpcHost", "rpcPort", "rpcUser", "rpcUserPassword", "rpcUserHome", "useSudo", "sudoUser", "sudoUserPassword", "sshPublicKeyPath", "sshPrivateKeyPath", "sshPrivateKeyPassword", "useHostCredentials", "defaultSSHPublicKeyPath", "defaultSSHPrivateKeyPath"));
    private static final List<String> KEYS_TO_ENCDODE = new ArrayList<String>(Arrays.asList("rpcUserPassword", "sudoUserPassword", "sshPrivateKeyPassword"));
    private static final String SYSKEY_OSNAME = "os.name";
    private static final String SYSKEY_USER_NAME = "user.name";
    private static final String SYSKEY_USER_HOME = "user.home";
    @Sensitive
    private Map<String, Object> hostAuthInfo;
    private String hostname;
    static final long serialVersionUID = -6696046911903417518L;

    private boolean propertyExists(@Sensitive Map<String, Object> properties, String key) {
        return properties.containsKey(key) && properties.get(key) != null && !properties.get(key).toString().trim().isEmpty();
    }

    private String getSystemProperty(String key) {
        return AccessController.doPrivileged(new GetSystemPropertyAction(key));
    }

    @Sensitive
    private Object encodeSensitiveData(String mapKey, @Sensitive Object sensitive) {
        String toEncode;
        if (sensitive instanceof SerializableProtectedString) {
            toEncode = String.valueOf(((SerializableProtectedString)sensitive).getChars());
        } else if (sensitive instanceof String) {
            toEncode = (String)sensitive;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected object type: " + sensitive.getClass().getCanonicalName()), (Object[])new Object[0]);
            }
            return sensitive;
        }
        if (PasswordUtil.isEncrypted((String)toEncode)) {
            return toEncode;
        }
        String encoded = PasswordUtil.passwordEncode((String)toEncode);
        if (encoded == null) {
            Tr.error((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_PASSWORD_ENCODER_ERROR", (Object[])new Object[]{mapKey});
        }
        return encoded;
    }

    @Sensitive
    private Map<String, Object> encodeSensitiveKeys(@Sensitive Map<String, Object> properties) {
        Set<Map.Entry<String, Object>> entries = properties.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            if (!KEYS_TO_ENCDODE.contains(key)) continue;
            Object value = this.encodeSensitiveData(key, entry.getValue());
            properties.put(key, value);
        }
        return properties;
    }

    private void validateSSHConfiguration(@Sensitive Map<String, Object> hostAuthInfo) {
        if (hostAuthInfo.containsKey("sshPublicKeyPath") && !hostAuthInfo.containsKey("sshPrivateKeyPath")) {
            Tr.warning((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_ONLY_PUBLIC_KEY", (Object[])new Object[0]);
            hostAuthInfo.remove("sshPublicKeyPath");
        }
        if (hostAuthInfo.containsKey("sshPrivateKeyPassword") && !hostAuthInfo.containsKey("sshPrivateKeyPath")) {
            Tr.warning((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_KEY_PASSWORD_WITHOUT_KEY", (Object[])new Object[0]);
            hostAuthInfo.remove("sshPrivateKeyPassword");
        }
    }

    private void validateConfiguration(@Sensitive Map<String, Object> hostAuthInfo) {
        this.validateSSHConfiguration(hostAuthInfo);
        if (this.propertyExists(hostAuthInfo, "rpcUserPassword") && this.propertyExists(hostAuthInfo, "sshPrivateKeyPath")) {
            Tr.warning((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_KEY_CONFIG_WITH_USER_PASSWORD", (Object[])new Object[0]);
            hostAuthInfo.remove("rpcUserPassword");
        }
        if (!hostAuthInfo.containsKey("sshPrivateKeyPath") && !hostAuthInfo.containsKey("rpcUserPassword")) {
            Tr.info((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_USE_DEFAULT_SSH_CONFIG", (Object[])new Object[0]);
            hostAuthInfo.put("sshPublicKeyPath", hostAuthInfo.get(INTERNAL_KEY_DEFAULT_SSH_PUBLIC_KEY_PATH));
            hostAuthInfo.put("sshPrivateKeyPath", hostAuthInfo.get(INTERNAL_KEY_DEFAULT_SSH_PRIVATE_KEY_PATH));
        }
        hostAuthInfo.remove(INTERNAL_KEY_DEFAULT_SSH_PUBLIC_KEY_PATH);
        hostAuthInfo.remove(INTERNAL_KEY_DEFAULT_SSH_PRIVATE_KEY_PATH);
        if (this.propertyExists(hostAuthInfo, "useSudo")) {
            boolean useSudo = (Boolean)hostAuthInfo.get("useSudo");
            if (!useSudo && (this.propertyExists(hostAuthInfo, "sudoUser") || this.propertyExists(hostAuthInfo, "sudoUserPassword"))) {
                hostAuthInfo.remove("sudoUser");
                hostAuthInfo.remove("sudoUserPassword");
                Tr.warning((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_USE_SUDO_WARNING", (Object[])new Object[0]);
            }
        } else if (this.propertyExists(hostAuthInfo, "sudoUser") || this.propertyExists(hostAuthInfo, "sudoUserPassword")) {
            hostAuthInfo.put("useSudo", true);
        }
    }

    @Sensitive
    private Map<String, Object> filterUnexpectedKeys(@Sensitive Map<String, Object> serviceProperties) {
        HashMap<String, Object> hostAuthInfo = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> entries = serviceProperties.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            if (!EXPECTED_KEYS.contains(key)) continue;
            hostAuthInfo.put(key, entry.getValue());
        }
        return hostAuthInfo;
    }

    @Trivial
    private void writeEffectiveConfigInfoMessage(@Sensitive Map<String, Object> hostAuthInfo) {
        if (hostAuthInfo.isEmpty()) {
            Tr.info((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_STATE_HOST_CREDENTIALS", (Object[])new Object[0]);
        } else {
            String host = (String)hostAuthInfo.get("rpcHost");
            String port = ((Integer)hostAuthInfo.get("rpcPort")).toString();
            String user = (String)hostAuthInfo.get("rpcUser");
            String authType = null;
            if (hostAuthInfo.containsKey("rpcUserPassword")) {
                authType = "password";
            } else if (hostAuthInfo.containsKey("sshPrivateKeyPath")) {
                authType = "ssh-key";
            }
            Tr.info((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_STATE", (Object[])new Object[]{host, port, user, authType});
        }
    }

    @Sensitive
    private Map<String, Object> processHostAuthConfig(@Sensitive Map<String, Object> serviceProperties) {
        Map<String, Object> hostAuthInfo = this.filterUnexpectedKeys(serviceProperties);
        if (hostAuthInfo.get("useHostCredentials") != null && ((Boolean)hostAuthInfo.get("useHostCredentials")).booleanValue()) {
            hostAuthInfo = new HashMap<String, Object>();
        } else {
            hostAuthInfo.put("osName", this.getSystemProperty(SYSKEY_OSNAME));
            if (!this.propertyExists(hostAuthInfo, "rpcHost")) {
                hostAuthInfo.put("rpcHost", HostNameUtil.getFQDN());
            } else if ("*".equals(hostAuthInfo.get("rpcHost"))) {
                hostAuthInfo.put("rpcHost", HostNameUtil.getFQDN());
            }
            this.hostname = (String)hostAuthInfo.get("rpcHost");
            if (!this.propertyExists(hostAuthInfo, "rpcPort")) {
                hostAuthInfo.put("rpcPort", DEFAULT_SSH_PORT);
            }
            if (!this.propertyExists(hostAuthInfo, "rpcUser")) {
                hostAuthInfo.put("rpcUser", this.getSystemProperty(SYSKEY_USER_NAME));
            }
            if (!this.propertyExists(hostAuthInfo, "rpcUserHome")) {
                hostAuthInfo.put("rpcUserHome", this.getSystemProperty(SYSKEY_USER_HOME));
            }
            this.validateConfiguration(hostAuthInfo);
        }
        this.writeEffectiveConfigInfoMessage(hostAuthInfo);
        return this.encodeSensitiveKeys(hostAuthInfo);
    }

    @Activate
    protected void activate(@Sensitive Map<String, Object> properties) {
        this.hostAuthInfo = this.processHostAuthConfig(properties);
    }

    @Modified
    protected void modified(@Sensitive Map<String, Object> properties) {
        this.hostAuthInfo = this.processHostAuthConfig(properties);
    }

    @Deactivate
    protected void deactivate() {
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    @Sensitive
    public Map<String, Object> getHostAuthConfig() {
        return this.hostAuthInfo;
    }

    @Trivial
    static class GetSystemPropertyAction
    implements PrivilegedAction<String> {
        private final String property;

        public GetSystemPropertyAction(String prop) {
            this.property = prop;
        }

        @Override
        public String run() {
            return System.getProperty(this.property);
        }
    }
}

