/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.AbstractDelegatingLogger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class LogUtils {
    public static final String KEY = "org.apache.cxf.Logger";
    private static final Object[] NO_PARAMETERS;
    private static Class<?> loggerClass;
    static final long serialVersionUID = -3816470334620016436L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private LogUtils() {
    }

    public static void setLoggerClass(Class<? extends AbstractDelegatingLogger> cls) {
        loggerClass = cls;
    }

    public static Logger getLogger(Class<?> cls) {
        return LogUtils.createLogger(cls, null, cls.getName() + cls.getClassLoader());
    }

    public static Logger getLogger(Class<?> cls, String resourcename) {
        return LogUtils.createLogger(cls, resourcename, cls.getName() + cls.getClassLoader());
    }

    public static Logger getLogger(Class<?> cls, String resourcename, String loggerName) {
        return LogUtils.createLogger(cls, resourcename, loggerName);
    }

    public static Logger getL7dLogger(Class<?> cls) {
        return LogUtils.createLogger(cls, null, cls.getName() + cls.getClassLoader());
    }

    public static Logger getL7dLogger(Class<?> cls, String resourcename) {
        return LogUtils.createLogger(cls, resourcename, cls.getName() + cls.getClassLoader());
    }

    public static Logger getL7dLogger(Class<?> cls, String resourcename, String loggerName) {
        return LogUtils.createLogger(cls, resourcename, loggerName);
    }

    /*
     * Exception decompiling
     */
    @FFDCIgnore(value={MissingResourceException.class, IllegalArgumentException.class})
    protected static Logger createLogger(Class<?> cls, String name, String loggerName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 28[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setContextClassLoader(final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = -852293059178115520L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        } else {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = -2742648237406683519L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private static ClassLoader getClassLoader(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = 7869141953395107595L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        return clazz.getClassLoader();
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object parameter) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameter);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object ... parameters) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameters);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message) {
        LogUtils.log(logger, level, message, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable) {
        LogUtils.log(logger, level, message, throwable, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level, String message, Object parameter) {
        LogUtils.log(logger, level, message, new Object[]{parameter});
    }

    public static void log(Logger logger, Level level, String message, Object[] parameters) {
        if (logger.isLoggable(level)) {
            String msg = LogUtils.localize(logger, message);
            try {
                msg = MessageFormat.format(msg, parameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"org.apache.cxf.common.logging.LogUtils", (String)"459", null, (Object[])new Object[]{logger, level, message, parameters});
            }
            LogUtils.doLog(logger, level, msg, null);
        }
    }

    private static void doLog(Logger log, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(log.getName());
        record.setResourceBundleName(log.getResourceBundleName());
        record.setResourceBundle(log.getResourceBundle());
        if (t != null) {
            record.setThrown(t);
        }
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String cname = LogUtils.class.getName();
        for (int x = 0; x < stack.length; ++x) {
            StackTraceElement frame = stack[x];
            if (frame.getClassName().equals(cname)) continue;
            record.setSourceClassName(frame.getClassName());
            record.setSourceMethodName(frame.getMethodName());
            break;
        }
        log.log(record);
    }

    private static String localize(Logger logger, String message) {
        ResourceBundle bundle = logger.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(message) : message;
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException((Throwable)missingResourceException, (String)"org.apache.cxf.common.logging.LogUtils", (String)"503", null, (Object[])new Object[]{logger, message});
            return message;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LogUtils.class);
        NO_PARAMETERS = new Object[0];
        loggerClass = null;
    }
}

