/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal.discrim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.InboundVirtualConnection;
import com.ibm.ws.channelfw.internal.discrim.DiscriminationAlgorithm;
import com.ibm.ws.channelfw.internal.discrim.DiscriminationGroup;
import com.ibm.ws.channelfw.internal.discrim.DiscriminatorNode;
import com.ibm.ws.channelfw.internal.discrim.FailureDiscriminatorAlgorithm;
import com.ibm.ws.channelfw.internal.discrim.MultiDiscriminatorAlgorithm;
import com.ibm.ws.channelfw.internal.discrim.SingleDiscriminatorAlgorithm;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.exception.DiscriminationProcessException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class DiscriminationProcessImpl
implements DiscriminationGroup {
    private static final TraceComponent tc = Tr.register(DiscriminationProcessImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private Class<?> discriminantClass;
    private DiscriminationAlgorithm discriminationAlgorithm = null;
    private int status = 2;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private static Object indexLock = new Object();
    private static int masterIndex = 0;
    private int myIndex;
    private String name = null;
    private DiscriminatorNode discriminators;
    private List<Discriminator> discAL = null;
    private Channel[] channelList = null;
    private boolean changed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscriminationProcessImpl(Class<?> discClass, String channelName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ctor, discClass=" + discClass + ", channelName=" + channelName), (Object[])new Object[0]);
        }
        this.discriminators = null;
        this.discAL = new ArrayList<Discriminator>(0);
        this.discriminantClass = discClass;
        this.discriminationAlgorithm = new FailureDiscriminatorAlgorithm();
        this.status = 2;
        this.name = channelName;
        Object object = indexLock;
        synchronized (object) {
            this.myIndex = masterIndex++;
        }
    }

    public DiscriminationProcessImpl(Class<?> discClass, DiscriminationGroup dg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ctor, discClass=" + discClass + ", DiscriminatorGroup=" + dg), (Object[])new Object[0]);
        }
        this.discriminators = null;
        this.discAL = new ArrayList<Discriminator>(0);
        this.discriminantClass = discClass;
        this.discriminationAlgorithm = new FailureDiscriminatorAlgorithm();
        this.status = 2;
        this.name = dg.getChannelName();
        DiscriminatorNode dn = (DiscriminatorNode)dg.getDiscriminatorNodes();
        this.buildDiscriminatorNodes(dn);
    }

    private void buildDiscriminatorNodes(DiscriminatorNode node) {
        DiscriminatorNode dn;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("buildDiscriminatorNodes: " + node), (Object[])new Object[0]);
        }
        if ((dn = node) == null) {
            return;
        }
        DiscriminatorNode newDN = null;
        DiscriminatorNode lastDN = null;
        this.discriminators = new DiscriminatorNode(dn.disc, dn.weight, null, null);
        this.discAL.add(dn.disc);
        Channel chan = dn.disc.getChannel();
        this.addChannel(chan);
        newDN = this.discriminators;
        lastDN = this.discriminators;
        while (dn.next != null) {
            dn = dn.next;
            lastDN.next = newDN = new DiscriminatorNode(dn.disc, dn.weight, null, lastDN);
            lastDN = newDN;
            this.discAL.add(dn.disc);
            chan = dn.disc.getChannel();
            this.addChannel(chan);
        }
    }

    @Override
    public int discriminate(VirtualConnection vcx, Object discrimData, ConnectionLink ccl) throws DiscriminationProcessException {
        InboundVirtualConnection vc = (InboundVirtualConnection)vcx;
        if (this.discriminationAlgorithm == null) {
            DiscriminationProcessException e = new DiscriminationProcessException("No Discriminators in this group or the group was not properly started");
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".discriminate"), (String)"202", (Object)this, (Object[])new Object[]{vc});
            throw e;
        }
        if (this.changed) {
            if (null != vc) {
                vc.setDiscriminatorStatus(null);
                vc.setDiscriminationGroup(null);
            }
            this.changed = false;
        }
        return this.discriminationAlgorithm.discriminate(vc, discrimData, ccl);
    }

    @Override
    public int discriminate(VirtualConnection vc, ConnectionLink currentChannel, String inputChannelName) {
        Channel channel = null;
        String channelName = null;
        String matchString = inputChannelName + "_CFINTERNAL_CHILD_";
        int result = 0;
        for (int i = 0; this.channelList != null && i < this.channelList.length; ++i) {
            channel = this.channelList[i];
            channelName = channel.getName();
            if (channelName == null || !channelName.startsWith(matchString)) continue;
            ConnectionLink link = channel.getConnectionLink(vc);
            currentChannel.setApplicationCallback(link);
            link.setDeviceLink(currentChannel);
            result = 1;
            break;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addDiscriminator(Discriminator d, int weight) throws DiscriminationProcessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addDiscriminator: " + d + " weight=" + weight), (Object[])new Object[0]);
        }
        if (this.status == 1) {
            DiscriminationProcessException e = new DiscriminationProcessException("Should not add to DiscriminationGroup while started!");
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addDiscriminator"), (String)"239", (Object)this, (Object[])new Object[]{d});
            throw e;
        }
        if (weight < 0) {
            DiscriminationProcessException e = new DiscriminationProcessException("Invalid weight for discriminator, " + weight);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addDiscriminator"), (String)"260", (Object)this, (Object[])new Object[]{(long)weight});
            throw e;
        }
        if (this.discAL.contains(d)) {
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"Same discriminator added twice?", (Object[])new Object[0]);
            return;
        }
        if (!d.getDiscriminatoryDataType().isAssignableFrom(this.discriminantClass)) {
            ClassCastException e = new ClassCastException();
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addDiscriminator"), (String)"292", (Object)this, (Object[])new Object[]{d});
            throw e;
        }
        if (d.getChannel() == null || d.getChannel().getName() == null) {
            DiscriminationProcessException e = new DiscriminationProcessException("Discriminator does not have channel or its channel has no name");
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".addDiscriminator"), (String)"273", (Object)this, (Object[])new Object[]{d});
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Add discriminator " + d.getChannel().getName()), (Object[])new Object[0]);
        }
        this.addDiscriminatorNode(new DiscriminatorNode(d, weight));
        this.discAL.add(d);
        Channel chan = d.getChannel();
        this.addChannel(chan);
        this.changed = true;
    }

    public boolean containsDiscriminator(Discriminator d) {
        return this.discAL.contains(d);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Index: ").append(this.getIndex());
        sb.append(" Discriminators:\n");
        DiscriminatorNode tempNode = this.discriminators;
        while (null != tempNode) {
            sb.append("\t").append(tempNode.disc.getChannel().getName());
            sb.append(" weight=").append(tempNode.disc.getWeight());
            tempNode = tempNode.next;
        }
        return sb.toString();
    }

    private void addDiscriminatorNode(DiscriminatorNode dn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addDiscriminatorNode, weight=" + dn.weight), (Object[])new Object[0]);
        }
        if (this.discriminators == null) {
            this.discriminators = dn;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addDiscriminatorNode");
            }
            return;
        }
        DiscriminatorNode thisDN = this.discriminators;
        if (thisDN.weight > dn.weight) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding disc first in list", (Object[])new Object[0]);
            }
            thisDN.prev = dn;
            dn.next = thisDN;
            this.discriminators = dn;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addDiscriminatorNode");
            }
            return;
        }
        DiscriminatorNode lastDN = this.discriminators;
        while (thisDN.next != null) {
            lastDN = thisDN;
            thisDN = thisDN.next;
            if (thisDN.weight <= dn.weight) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding disc before " + thisDN.disc.getChannel().getName()), (Object[])new Object[0]);
            }
            thisDN.prev = dn;
            dn.next = thisDN;
            lastDN.next = dn;
            dn.prev = lastDN;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addDiscriminatorNode");
            }
            return;
        }
        thisDN.next = dn;
        dn.prev = thisDN;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addDiscriminatorNode");
        }
    }

    @Override
    public void removeDiscriminator(Discriminator d) throws DiscriminationProcessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeDiscriminator: " + d), (Object[])new Object[0]);
        }
        if (this.status == 1) {
            DiscriminationProcessException e = new DiscriminationProcessException("Should not remove form DiscriminationGroup while started!");
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeDiscriminator"), (String)"401", (Object)this, (Object[])new Object[]{d});
            throw e;
        }
        if (!this.discAL.remove(d)) {
            NoSuchElementException e = new NoSuchElementException("Discriminator does not exist, " + d.getChannel().getName());
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeDiscriminator"), (String)"410", (Object)this, (Object[])new Object[]{d});
            throw e;
        }
        this.changed = true;
        String chanName = d.getChannel().getName();
        if (this.channelList == null) {
            NoSuchElementException e = new NoSuchElementException("No Channel's exist, " + chanName);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeDiscriminator"), (String)"422", (Object)this, (Object[])new Object[]{d});
            throw e;
        }
        Channel[] oldList = this.channelList;
        this.channelList = new Channel[oldList.length - 1];
        int j = 0;
        for (int i = 0; i < oldList.length; ++i) {
            String tempName = oldList[i].getName();
            if (tempName != null && !tempName.equals(chanName)) {
                if (j >= oldList.length) {
                    NoSuchElementException e = new NoSuchElementException("Channel does not exist, " + d.getChannel().getName());
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeDiscriminator"), (String)"440", (Object)this, (Object[])new Object[]{d});
                    throw e;
                }
                this.channelList[j++] = oldList[i];
                continue;
            }
            if (chanName != null) continue;
            DiscriminationProcessException e = new DiscriminationProcessException("Channel does not have a name associated with it, " + oldList[i]);
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeDiscriminator"), (String)"454", (Object)this, (Object[])new Object[]{oldList[i]});
            throw e;
        }
        this.removeDiscriminatorNode(d);
    }

    private void removeDiscriminatorNode(Discriminator d) throws DiscriminationProcessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeDiscriminatorNode: " + d), (Object[])new Object[0]);
        }
        if (d == null) {
            DiscriminationProcessException e = new DiscriminationProcessException("Can't remove a null discriminator");
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".removeDiscriminatorNode"), (String)"484", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeDiscriminatorNode");
            }
            throw e;
        }
        if (this.discriminators.disc.equals(d)) {
            this.discriminators = this.discriminators.next;
            if (this.discriminators != null) {
                this.discriminators.prev = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeDiscriminatorNode");
            }
            return;
        }
        DiscriminatorNode thisDN = this.discriminators.next;
        DiscriminatorNode lastDN = this.discriminators;
        while (thisDN.next != null) {
            if (thisDN.disc.equals(d)) {
                thisDN.next.prev = lastDN;
                lastDN.next = thisDN.next;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeDiscriminatorNode");
                }
                return;
            }
            lastDN = thisDN;
            thisDN = thisDN.next;
        }
        if (thisDN.disc.equals(d)) {
            lastDN.next = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeDiscriminatorNode");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeDiscriminatorNode: not found");
        }
        throw new NoSuchElementException();
    }

    @Override
    public List<Discriminator> getDiscriminators() {
        return this.discAL;
    }

    @Override
    public Object getDiscriminatorNodes() {
        return this.discriminators;
    }

    @Override
    public DiscriminationAlgorithm getDiscriminationAlgorithm() {
        return this.discriminationAlgorithm;
    }

    @Override
    public void setDiscriminationAlgorithm(DiscriminationAlgorithm da) {
        this.discriminationAlgorithm = da;
    }

    @Override
    public void start() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Started discriminator list " + this.discAL + "with size" + this.discAL.size()), (Object[])new Object[0]);
        }
        if (this.discAL.size() > 1) {
            this.rebuildDiscriminatorList();
            this.discriminationAlgorithm = new MultiDiscriminatorAlgorithm(this);
        } else {
            this.discriminationAlgorithm = this.discAL.size() == 1 ? new SingleDiscriminatorAlgorithm(this) : new FailureDiscriminatorAlgorithm();
        }
        this.status = 1;
    }

    @Override
    public String getChannelName() {
        return this.name;
    }

    private void rebuildDiscriminatorList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rebuildDiscriminatorList", (Object[])new Object[0]);
        }
        this.discAL.clear();
        DiscriminatorNode dn = this.discriminators;
        this.discAL.add(dn.disc);
        dn = dn.next;
        while (dn != null) {
            this.discAL.add(dn.disc);
            dn = dn.next;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rebuildDiscriminatorList");
        }
    }

    @Override
    public int compareTo(DiscriminationGroup o) {
        if (o == null || !(o instanceof DiscriminationProcessImpl)) {
            return -1;
        }
        return o.hashCode() - this.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof DiscriminationProcessImpl)) {
            return false;
        }
        return this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        return this.myIndex;
    }

    int getIndex() {
        return this.myIndex;
    }

    private void addChannel(Channel chan) {
        if (this.channelList == null) {
            this.channelList = new Channel[1];
            this.channelList[0] = chan;
        } else {
            Channel[] oldList = this.channelList;
            this.channelList = new Channel[oldList.length + 1];
            System.arraycopy(oldList, 0, this.channelList, 0, oldList.length);
            this.channelList[oldList.length] = chan;
        }
    }
}

