/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.EndpointManager;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WsocHttpSessionListener
implements HttpSessionListener {
    private static final TraceComponent tc = Tr.register(WsocHttpSessionListener.class);
    EndpointManager endpointManager = null;
    static final long serialVersionUID = 1921922728398434524L;

    public void initialize(EndpointManager em) {
        this.endpointManager = em;
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("HttpSession created: HttpSession ID: " + event.getSession().getId()), (Object[])new Object[0]);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        String id = event.getSession().getId();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("HttpSession destroyed: HttpSession ID: " + event.getSession().getId()), (Object[])new Object[0]);
        }
        if (this.endpointManager != null) {
            this.endpointManager.httpSessionExpired(id);
        }
    }
}

