/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.was;

import com.ibm.xml.xlxp2.api.sax.impl.SAX2DTDScanner;
import com.ibm.xml.xlxp2.api.sax.impl.SAX2DocumentScanner;
import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParserBase;
import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParserCallbacks;
import com.ibm.xml.xlxp2.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp2.api.util.ParsedEntityStream;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.Version;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.InputStream;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.DeclHandler;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class WSXMLReader
extends SAX2ParserBase
implements SAX2ParserCallbacks {
    protected static final int ELEMENT_EVENT_EMPTY = 0;
    protected static final int ELEMENT_EVENT_START = 1;
    protected static final int ELEMENT_EVENT_INVALID = 2;
    protected SAX2ParsedEntityFactory fEntityFactory;
    protected SAX2DTDScanner fDTDScanner;
    protected SAX2DocumentScanner fScanner;
    protected int fElementEventState;

    public WSXMLReader() {
        this(true);
    }

    protected WSXMLReader(boolean bl) {
        this.fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
        this.fElementEventState = 2;
        if (bl) {
            this.initialize();
        }
    }

    protected void initialize() {
        this.fScanner = this.createSAX2DocumentScanner();
        this.fDTDScanner = this.createSAX2DTDScanner();
        this.fScanner.setDTDSupport(this.fDTDScanner);
    }

    protected void reset(boolean bl) {
        this.fDTDScanner.reset(bl);
        this.fEntityFactory.reset(bl);
        this.fElementEventState = 2;
        this.fScanner.reset(bl);
        super.reset(bl);
    }

    protected SAX2DocumentScanner createSAX2DocumentScanner() {
        return new SAX2DocumentScanner(this.fBufferFactory, this.fSymbolTable, this);
    }

    protected SAX2DTDScanner createSAX2DTDScanner() {
        return new SAX2DTDScanner(this.fScanner, this.fSymbolTable, this.fEntityFactory, this);
    }

    protected CharConversionError parseEvents(InputSource inputSource) {
        this.fScanner.setNamespaceAwareness(this.fNamespaces);
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputSource);
        if (parsedEntity != null && parsedEntity.error == null) {
            this.fScanner.parseDocumentEntity(parsedEntity);
            return null;
        }
        return parsedEntity == null ? null : parsedEntity.error;
    }

    protected void startElementAction(QName qName, XMLString xMLString, boolean bl) {
        this.fElementEventState = bl ? 0 : 1;
        super.startElementAction(qName, xMLString, bl);
        this.fElementEventState = 2;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith("http://ibm.com/xlxp/properties/")) {
            String string2 = string.substring("http://ibm.com/xlxp/properties/".length());
            if (string2.equals("subtree-as-stream")) {
                if (this.fElementEventState == 2) {
                    throw new SAXNotSupportedException(string);
                }
                return this.subtreeAsStream();
            }
            if (string2.equals("build-time-stamp")) {
                return Version.getBuildTimeStamp();
            }
        }
        return super.getProperty(string);
    }

    public void endDTD() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endDTD();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public boolean skippedExternalSubsetEntity() {
        if (this.fContentHandler != null) {
            try {
                this.fContentHandler.skippedEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        return true;
    }

    public void startDTDEntity() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endDTDEntity() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void startPE(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                String string = xMLString.toString();
                StringBuilder stringBuilder = new StringBuilder(string.length() + 1);
                stringBuilder.append('%');
                stringBuilder.append(string);
                string = stringBuilder.toString();
                this.fLexicalHandler.startEntity(string);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endPE(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                String string = xMLString.toString();
                StringBuilder stringBuilder = new StringBuilder(string.length() + 1);
                stringBuilder.append('%');
                stringBuilder.append(string);
                string = stringBuilder.toString();
                this.fLexicalHandler.endEntity(string);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void processingInstructionInDTD(XMLString xMLString, XMLString xMLString2) {
        super.processingInstruction(xMLString, xMLString2);
    }

    public void commentInDTD(XMLString xMLString) {
        super.comment(xMLString);
    }

    protected boolean isStandalone(String string) {
        return this.fDTDScanner.isStandalone();
    }

    protected boolean getScanExternalGeneralEntities(String string) {
        return this.fDTDScanner.getScanExternalGeneralEntities();
    }

    protected void setScanExternalGeneralEntities(String string, boolean bl) {
        this.fDTDScanner.setScanExternalGeneralEntities(bl);
    }

    protected boolean getScanExternalParameterEntities(String string) {
        return this.fDTDScanner.getScanExternalParameterEntities();
    }

    protected void setScanExternalParameterEntities(String string, boolean bl) {
        this.fDTDScanner.setScanExternalParameterEntities(bl);
    }

    protected boolean getResolveDTDURIs(String string) {
        return this.fDTDScanner.getResolveDTDURIs(string);
    }

    protected void setResolveDTDURIs(String string, boolean bl) {
        this.fDTDScanner.setResolveDTDURIs(string, bl);
    }

    protected DeclHandler getDeclHandler() {
        return this.fDTDScanner.getDeclHandler();
    }

    protected void setDeclHandler(DeclHandler declHandler) {
        this.fDTDScanner.setDeclHandler(declHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDScanner.getDTDHandler();
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDScanner.setDTDHandler(dTDHandler);
    }

    public EntityResolver getEntityResolver() {
        return this.fEntityFactory.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fEntityFactory.setEntityResolver(entityResolver);
    }

    protected InputStream subtreeAsStream() {
        ParsedEntityStream parsedEntityStream = new ParsedEntityStream();
        XMLString xMLString = parsedEntityStream.skippedContent();
        if (this.fElementEventState == 0) {
            NullDataBufferFactory.setEmptyStringValues(xMLString);
            return parsedEntityStream;
        }
        if (this.fScanner.skipContent(xMLString)) {
            return parsedEntityStream;
        }
        return null;
    }
}

