/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.sax.impl;

import com.ibm.xml.xlxp2.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp2.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.msg.MessageProvider;
import com.ibm.xml.xlxp2.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.AttrList;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.NSDeclList;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.SymbolTable;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class SAX2ParserBase
implements Attributes,
Locator,
XMLReader {
    private static final boolean RETAIN_OBJECTS_ACROSS_RESET = true;
    private static final String SAX2_FEATURES_PREFIX = "http://xml.org/sax/features/";
    protected static final String XLXP_FEATURES_PREFIX = "http://ibm.com/xlxp/features/";
    private static final String SAX2_PROPERTIES_PREFIX = "http://xml.org/sax/properties/";
    protected static final String XLXP_PROPERTIES_PREFIX = "http://ibm.com/xlxp/properties/";
    protected final DataBufferFactory fBufferFactory = new SimpleDataBufferFactory();
    protected final SymbolTable fSymbolTable = new SymbolTable();
    protected final InputSource fInputSource = new InputSource();
    protected ErrorHandler fErrorHandler;
    protected ContentHandler fContentHandler;
    protected LexicalHandler fLexicalHandler;
    protected char[][] fCharBuffer = ArrayAllocator.newCharArray2(1);
    protected int[] fCharBufferOffset;
    protected boolean fValidation;
    protected boolean fNamespaces;
    protected boolean fNamespacePrefixes;
    protected boolean fSeenEnumeration;
    protected XMLString fEnumeration;
    protected boolean fNeedReset;
    protected int fAttrCount;
    protected int fAttrOffset;
    protected NSDeclList fNSDecls;
    protected AttrList fAttrs;
    protected int fElementDepth;
    protected boolean fInElementContent;
    protected String[] fQNameStringStack;
    protected int fQNameStackDepth;
    protected boolean fCalledStartDocument;
    protected String fDocumentVersion;
    private XMLString fPartialContent;

    protected abstract CharConversionError parseEvents(InputSource var1);

    protected abstract boolean isStandalone(String var1);

    protected abstract boolean getScanExternalGeneralEntities(String var1);

    protected abstract void setScanExternalGeneralEntities(String var1, boolean var2);

    protected abstract boolean getScanExternalParameterEntities(String var1);

    protected abstract void setScanExternalParameterEntities(String var1, boolean var2);

    protected abstract DeclHandler getDeclHandler();

    protected abstract void setDeclHandler(DeclHandler var1);

    public abstract DTDHandler getDTDHandler();

    public abstract void setDTDHandler(DTDHandler var1);

    public abstract EntityResolver getEntityResolver();

    public abstract void setEntityResolver(EntityResolver var1);

    protected SAX2ParserBase() {
        this.fCharBuffer[0] = ArrayAllocator.newCharArray(256);
        this.fCharBufferOffset = ArrayAllocator.newIntArray(1);
        this.fQNameStringStack = ArrayAllocator.newStringArray(48);
        this.fNamespaces = true;
        this.fDocumentVersion = "1.0";
    }

    protected void reset(boolean bl) {
        this.fElementDepth = 0;
        this.fQNameStackDepth = 0;
        this.fDocumentVersion = "1.0";
        this.fCalledStartDocument = false;
        this.fSymbolTable.reset(bl);
        this.fBufferFactory.reset(bl);
    }

    public void startDocumentEvent(XMLString xMLString) {
        if (xMLString.firstBuffer != null) {
            this.fDocumentVersion = xMLString.toString();
        }
    }

    public void startDTD(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startDTD(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3 == null ? null : xMLString3.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    protected void startPrefixMappings(NSDeclList nSDeclList) {
        int n = nSDeclList.nsDeclCount();
        try {
            for (int i = 0; i < n; ++i) {
                String string = nSDeclList.nsDeclPrefix(i);
                String string2 = nSDeclList.nsDeclURI(i);
                this.fContentHandler.startPrefixMapping(string, string2);
            }
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    protected void endPrefixMappings(NSDeclList nSDeclList) {
        int n = nSDeclList.nsDeclCount();
        try {
            for (int i = n - 1; i >= 0; --i) {
                String string = nSDeclList.nsDeclPrefix(i);
                this.fContentHandler.endPrefixMapping(string);
            }
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void startElementEvent(QName qName, NSDeclList nSDeclList, AttrList attrList, XMLString xMLString, boolean bl) {
        this.fNSDecls = nSDeclList;
        this.fAttrs = attrList;
        this.startElementAction(qName, xMLString, bl);
        if (!bl) {
            ++this.fElementDepth;
        }
    }

    protected void startElementAction(QName qName, XMLString xMLString, boolean bl) {
        this.fAttrCount = -1;
        if (this.fContentHandler != null) {
            try {
                this.startPrefixMappings(this.fNSDecls);
                String string = qName.nsURI;
                String string2 = qName.localName;
                String string3 = qName.rawName;
                this.fContentHandler.startElement(string, string2, string3, this);
                if (bl) {
                    if (xMLString != null) {
                        this.characters(xMLString);
                    }
                    this.fContentHandler.endElement(string, string2, string3);
                    this.endPrefixMappings(this.fNSDecls);
                }
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endElementEvent(QName qName, NSDeclList nSDeclList) {
        --this.fElementDepth;
        if (this.fContentHandler != null) {
            String string = qName.nsURI;
            String string2 = qName.localName;
            String string3 = qName.rawName;
            this.fNSDecls = nSDeclList;
            try {
                this.fContentHandler.endElement(string, string2, string3);
                this.endPrefixMappings(this.fNSDecls);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void characters(XMLString xMLString) {
        if (this.fContentHandler != null) {
            if (xMLString.bytes != null || xMLString.firstBuffer == xMLString.lastBuffer || xMLString.firstBuffer.next == xMLString.lastBuffer) {
                this.fCharBufferOffset[0] = 0;
                xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
                try {
                    this.fContentHandler.characters(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            } else {
                this.processCharactersInPieces(xMLString);
            }
        }
    }

    private final void processCharactersInPieces(XMLString xMLString) {
        if (this.fPartialContent == null) {
            this.fPartialContent = new XMLString();
        }
        this.fPartialContent.flags = xMLString.flags;
        boolean bl = (this.fPartialContent.flags & 4) != 0;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        int n = xMLString.startOffset;
        do {
            int n2;
            DataBuffer dataBuffer2;
            if (n == dataBuffer.endOffset) {
                dataBuffer2 = dataBuffer.next;
                n2 = dataBuffer2.startOffset;
            } else {
                dataBuffer2 = dataBuffer;
                n2 = n;
            }
            if (dataBuffer2 == xMLString.lastBuffer) {
                dataBuffer = dataBuffer2;
                n = xMLString.endOffset;
            } else {
                dataBuffer = dataBuffer2.next;
                if (dataBuffer == xMLString.lastBuffer) {
                    n = xMLString.endOffset;
                } else {
                    n = dataBuffer.endOffset;
                    if (dataBuffer.bytes[n - 1] < 0) {
                        DataBuffer dataBuffer3 = dataBuffer.next;
                        int n3 = dataBuffer3.startOffset;
                        while ((0xC0 & dataBuffer3.bytes[n3]) == 128) {
                            ++n3;
                        }
                        if (n3 > dataBuffer3.startOffset) {
                            dataBuffer = dataBuffer3;
                            n = n3;
                        }
                    }
                    if (bl && dataBuffer.bytes[n - 1] == 13) {
                        --n;
                    }
                }
            }
            this.setPartialContentValues(dataBuffer2, dataBuffer, n2, n);
            this.fCharBufferOffset[0] = 0;
            this.fPartialContent.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fContentHandler.characters(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        } while (dataBuffer != xMLString.lastBuffer);
        this.setPartialContentValues(null, null, 0, 0);
    }

    private final void setPartialContentValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        this.fPartialContent.firstBuffer = dataBuffer;
        this.fPartialContent.lastBuffer = dataBuffer2;
        this.fPartialContent.startOffset = n;
        this.fPartialContent.endOffset = n2;
    }

    public void cdataSection(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startCDATA();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        this.characters(xMLString);
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endCDATA();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void whitespace(XMLString xMLString) {
        if (this.fContentHandler != null) {
            this.fCharBufferOffset[0] = 0;
            xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fContentHandler.ignorableWhitespace(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    private String predefinedEntityToString(int n) {
        switch (n) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 38: {
                return "amp";
            }
            case 39: {
                return "apos";
            }
            case 34: {
                return "quot";
            }
        }
        return null;
    }

    public void character(int n, boolean bl) {
        String string = null;
        if (bl && this.fLexicalHandler != null) {
            string = this.predefinedEntityToString(n);
            try {
                this.fLexicalHandler.startEntity(string);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        if (this.fContentHandler != null) {
            int n2;
            if (n < 65536) {
                this.fCharBuffer[0][0] = (char)n;
                n2 = 1;
            } else {
                int n3 = n - 65536;
                this.fCharBuffer[0][0] = (char)(55296 + (n3 >> 10));
                this.fCharBuffer[0][1] = (char)(56320 + (n3 & 0x3FF));
                n2 = 2;
            }
            try {
                this.fContentHandler.characters(this.fCharBuffer[0], 0, n2);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        if (string != null) {
            try {
                this.fLexicalHandler.endEntity(string);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void processingInstruction(XMLString xMLString, XMLString xMLString2) {
        if (this.fContentHandler != null) {
            String string = this.fSymbolTable.addSymbol(xMLString);
            try {
                this.fContentHandler.processingInstruction(string, xMLString2.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public boolean skippedEntity(XMLString xMLString) {
        if (this.fContentHandler != null) {
            try {
                this.fContentHandler.skippedEntity(xMLString.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        return true;
    }

    public void startEntity(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startEntity(xMLString.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endEntity(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endEntity(xMLString.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void comment(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            this.fCharBufferOffset[0] = 0;
            xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fLexicalHandler.comment(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void reportWarning(String string, int n, int n2, XMLString[] xMLStringArray) {
        if (this.fErrorHandler != null) {
            try {
                MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string);
                String string2 = messageProvider.createMessage(null, n, xMLStringArray);
                SAXParseException sAXParseException = new SAXParseException(string2, this);
                this.fErrorHandler.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void reportRecoverableError(String string, int n, int n2, XMLString[] xMLStringArray) {
        if (this.fErrorHandler != null) {
            try {
                MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string);
                String string2 = messageProvider.createMessage(null, n, xMLStringArray);
                SAXParseException sAXParseException = new SAXParseException(string2, this);
                this.fErrorHandler.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void reportFatalError(String string, int n, int n2, XMLString[] xMLStringArray) {
        try {
            MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string);
            String string2 = messageProvider.createMessage(null, n, xMLStringArray);
            SAXParseException sAXParseException = new SAXParseException(string2, this);
            if (this.fErrorHandler != null) {
                this.fErrorHandler.fatalError(sAXParseException);
            }
            throw sAXParseException;
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    private void calculateAttrCount() {
        this.fAttrOffset = this.fNamespacePrefixes ? this.fNSDecls.nsDeclCount() : 0;
        this.fAttrCount = this.fAttrOffset + this.fAttrs.attributeCount();
    }

    public int getLength() {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        return this.fAttrCount;
    }

    public String getURI(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.fAttrs.attributeName((int)(n - this.fAttrOffset)).nsURI;
            }
        } else if (n >= 0) {
            return "";
        }
        return null;
    }

    public String getLocalName(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.fAttrs.attributeName((int)(n - this.fAttrOffset)).localName;
            }
        } else if (n >= 0) {
            return "";
        }
        return null;
    }

    public String getQName(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.fAttrs.attributeName((int)(n - this.fAttrOffset)).rawName;
            }
        } else if (n >= 0) {
            return this.fNSDecls.nsDeclQName(n);
        }
        return null;
    }

    public String getType(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                String string = this.fAttrs.attributeType(n - this.fAttrOffset);
                if (string == null) {
                    return "NMTOKEN";
                }
                if (string.length() == 0) {
                    return "CDATA";
                }
                return string;
            }
        } else if (n >= 0) {
            return "CDATA";
        }
        return null;
    }

    public String getValue(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.fAttrs.attributeValue(n -= this.fAttrOffset).toString();
            }
        } else if (n >= 0) {
            return this.fNSDecls.nsDeclURI(n);
        }
        return null;
    }

    public int getIndex(String string, String string2) {
        int n;
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if ((n = this.fAttrCount - this.fAttrOffset) > 0) {
            for (int i = 0; i < n; ++i) {
                QName qName = this.fAttrs.attributeName(i);
                if (!string2.equals(qName.localName) || !string.equals(qName.nsURI)) continue;
                return this.fAttrOffset + i;
            }
        }
        return -1;
    }

    public int getIndex(String string) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (this.fAttrCount > 0) {
            int n;
            int n2 = this.fAttrCount - this.fAttrOffset;
            for (n = 0; n < n2; ++n) {
                if (!string.equals(this.fAttrs.attributeName((int)n).rawName)) continue;
                return this.fAttrOffset + n;
            }
            for (n = 0; n < this.fAttrOffset; ++n) {
                if (!string.equals(this.fNSDecls.nsDeclQName(n))) continue;
                return n;
            }
        }
        return -1;
    }

    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        return this.getType(n);
    }

    public String getType(String string) {
        int n = this.getIndex(string);
        return this.getType(n);
    }

    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        return this.getValue(n);
    }

    public String getValue(String string) {
        int n = this.getIndex(string);
        return this.getValue(n);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    protected boolean getValidation(String string) {
        return false;
    }

    protected void setValidation(String string, boolean bl) throws SAXNotSupportedException {
        if (bl) {
            throw new SAXNotSupportedException(string);
        }
    }

    protected boolean getResolveDTDURIs(String string) {
        return true;
    }

    protected void setResolveDTDURIs(String string, boolean bl) throws SAXNotSupportedException {
        if (!bl) {
            throw new SAXNotSupportedException(string);
        }
    }

    protected boolean getGrammarCachingEnabled(String string) {
        return false;
    }

    protected void setGrammarCachingEnabled(String string, boolean bl) throws SAXNotSupportedException {
        if (bl) {
            throw new SAXNotSupportedException(string);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        String string2;
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string3 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string3.equals("namespaces")) {
                return this.fNamespaces;
            }
            if (string3.equals("namespace-prefixes")) {
                return this.fNamespacePrefixes;
            }
            if (string3.equals("string-interning")) {
                return false;
            }
            if (string3.equals("validation")) {
                return this.getValidation(string);
            }
            if (string3.equals("external-general-entities")) {
                return this.getScanExternalGeneralEntities(string);
            }
            if (string3.equals("external-parameter-entities")) {
                return this.getScanExternalParameterEntities(string);
            }
            if (string3.equals("lexical-handler/parameter-entities")) {
                return false;
            }
            if (string3.equals("is-standalone")) {
                if (this.fCalledStartDocument) {
                    return this.isStandalone(string);
                }
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("resolve-dtd-uris")) {
                return this.getResolveDTDURIs(string);
            }
            if (string3.equals("unicode-normalization-checking")) {
                return false;
            }
            if (string3.equals("use-attributes2")) {
                return false;
            }
            if (string3.equals("use-locator2")) {
                return false;
            }
            if (string3.equals("use-entity-resolver2")) {
                return false;
            }
            if (string3.equals("xmlns-uris")) {
                return false;
            }
            if (string3.equals("xml-1.1")) {
                return true;
            }
        } else if (string.startsWith(XLXP_FEATURES_PREFIX) && (string2 = string.substring(XLXP_FEATURES_PREFIX.length())).equals("validation/grammar-caching-enabled")) {
            return this.getGrammarCachingEnabled(string);
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        String string2;
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string3 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string3.equals("namespaces")) {
                this.fNamespaces = bl;
                return;
            }
            if (string3.equals("namespace-prefixes")) {
                this.fNamespacePrefixes = bl;
                return;
            }
            if (string3.equals("string-interning")) {
                if (bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string3.equals("validation")) {
                this.setValidation(string, bl);
                return;
            }
            if (string3.equals("external-general-entities")) {
                this.setScanExternalGeneralEntities(string, bl);
                return;
            }
            if (string3.equals("external-parameter-entities")) {
                this.setScanExternalParameterEntities(string, bl);
                return;
            }
            if (string3.equals("lexical-handler/parameter-entities")) {
                if (bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string3.equals("is-standalone")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("resolve-dtd-uris")) {
                this.setResolveDTDURIs(string, bl);
                return;
            }
            if (string3.equals("unicode-normalization-checking")) {
                if (bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string3.equals("use-attributes2")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("use-locator2")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("use-entity-resolver2")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("xmlns-uris")) {
                if (bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string3.equals("xml-1.1")) {
                throw new SAXNotSupportedException(string);
            }
        } else if (string.startsWith(XLXP_FEATURES_PREFIX) && (string2 = string.substring(XLXP_FEATURES_PREFIX.length())).equals("validation/grammar-caching-enabled")) {
            this.setGrammarCachingEnabled(string, bl);
            return;
        }
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string2 = string.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("xml-string")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("lexical-handler")) {
                return this.fLexicalHandler;
            }
            if (string2.equals("declaration-handler")) {
                return this.getDeclHandler();
            }
            if (string2.equals("document-xml-version")) {
                if (this.fCalledStartDocument) {
                    return this.fDocumentVersion;
                }
                throw new SAXNotSupportedException(string);
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string2 = string.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("xml-string")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("lexical-handler")) {
                try {
                    this.fLexicalHandler = (LexicalHandler)object;
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
            }
            if (string2.equals("declaration-handler")) {
                try {
                    this.setDeclHandler((DeclHandler)object);
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
            }
            if (string2.equals("document-xml-version")) {
                throw new SAXNotSupportedException(string);
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    private void parseEntity(InputSource inputSource) throws SAXException, IOException {
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        try {
            CharConversionError charConversionError;
            if (this.fContentHandler != null) {
                this.fContentHandler.setDocumentLocator(this);
                this.fCalledStartDocument = true;
                this.fContentHandler.startDocument();
            }
            if ((charConversionError = this.parseEvents(inputSource)) != null) {
                try {
                    SAXParseException sAXParseException = new SAXParseException(charConversionError.formatErrorMessage(), this);
                    if (this.fErrorHandler != null) {
                        this.fErrorHandler.fatalError(sAXParseException);
                    }
                    throw sAXParseException;
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.endDocument();
            }
            this.fCalledStartDocument = false;
        }
        catch (IOExceptionWrapper iOExceptionWrapper) {
            throw iOExceptionWrapper.getIOException();
        }
        catch (SAXExceptionWrapper sAXExceptionWrapper) {
            throw sAXExceptionWrapper.getSAXException();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception.getMessage());
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.fInputSource.setPublicId(inputSource.getPublicId());
        this.fInputSource.setSystemId(inputSource.getSystemId());
        this.fInputSource.setEncoding(inputSource.getEncoding());
        this.fInputSource.setByteStream(inputSource.getByteStream());
        this.fInputSource.setCharacterStream(inputSource.getCharacterStream());
        this.parseEntity(this.fInputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        this.fInputSource.setSystemId(string);
        this.fInputSource.setPublicId(null);
        this.fInputSource.setEncoding(null);
        this.fInputSource.setByteStream(null);
        this.fInputSource.setCharacterStream(null);
        this.parseEntity(this.fInputSource);
    }
}

